/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets.ssi;

import com.caucho.servlets.ssi.ErrorStatement;
import com.caucho.servlets.ssi.ExprParser;
import com.caucho.servlets.ssi.SSIExpr;
import com.caucho.servlets.ssi.Statement;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IfStatement
extends Statement {
    private final SSIExpr _test;
    private Statement _trueBlock;
    private Statement _falseBlock;

    protected IfStatement(SSIExpr test) {
        this._test = test;
    }

    static Statement create(HashMap<String, String> attr, Path path) {
        String test = attr.get("expr");
        if (test == null) {
            return new ErrorStatement("['test' is a required attribute of #if]");
        }
        return new IfStatement(ExprParser.parseString(test, path));
    }

    void setTrueBlock(Statement trueBlock) {
        this._trueBlock = trueBlock;
    }

    void setFalseBlock(Statement falseBlock) {
        this._falseBlock = falseBlock;
    }

    @Override
    public void apply(WriteStream out, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._test.evalBoolean(request, response)) {
            if (this._trueBlock != null) {
                this._trueBlock.apply(out, request, response);
            }
        } else if (this._falseBlock != null) {
            this._falseBlock.apply(out, request, response);
        }
    }
}

