/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployControllerType;
import com.caucho.env.deploy.DeployMode;
import com.caucho.env.deploy.ExpandDeployGenerator;
import com.caucho.env.deploy.ExpandVersion;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentListener;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.server.webapp.WebAppExpandDeployGeneratorAdmin;
import com.caucho.server.webapp.WebAppVersioningController;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppExpandDeployGenerator
extends ExpandDeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final Logger log = Logger.getLogger(WebAppExpandDeployGenerator.class.getName());
    private final WebAppExpandDeployGeneratorAdmin _admin;
    private WebAppContainer _container;
    private WebAppController _parent;
    private String _urlPrefix = "";
    private ArrayList<WebAppConfig> _webAppDefaults = new ArrayList();
    private HashMap<Path, WebAppConfig> _webAppConfigMap = new HashMap();
    private HashMap<String, Path> _contextPathMap = new HashMap();
    private HashMap<String, String> _nameToKeyMap = new HashMap();
    private ClassLoader _parentLoader;

    public WebAppExpandDeployGenerator(String id, DeployContainer<WebAppController> container, WebAppContainer webAppContainer) {
        super(id, container, webAppContainer.getRootDirectory());
        this._container = webAppContainer;
        this._parentLoader = webAppContainer.getClassLoader();
        try {
            this.setExtension(".war");
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        this.setEntryNamePrefix("/");
        this._admin = new WebAppExpandDeployGeneratorAdmin(this);
    }

    @Override
    public String getId() {
        return super.getId() + this._urlPrefix;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setParent(WebAppController parent) {
        this._parent = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (prefix.equals("")) {
            // empty if block
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setLazyInit(boolean lazyInit) throws ConfigException {
        log.config("lazy-init is deprecated.  Use <startup>lazy</startup> instead.");
        if (lazyInit) {
            this.setStartupMode(DeployMode.LAZY);
        } else {
            this.setStartupMode(DeployMode.AUTOMATIC);
        }
    }

    public void addWebApp(WebAppConfig config) {
        String docDir = config.getRootDirectory();
        Path appDir = this.getExpandDirectory().lookup(docDir);
        this._webAppConfigMap.put(appDir, config);
        if (config.getContextPath() != null) {
            this._contextPathMap.put(config.getContextPath(), appDir);
            String tail = appDir.getTail();
            this._nameToKeyMap.put(config.getContextPath(), tail);
        }
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._webAppDefaults.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void fillDeployedNames(Set<String> keys) {
        super.fillDeployedNames(keys);
        for (WebAppConfig cfg : this._webAppConfigMap.values()) {
            if (cfg.getContextPath() == null) continue;
            keys.add(cfg.getContextPath());
        }
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        Environment.addEnvironmentListener((EnvironmentListener)this, (ClassLoader)this._parentLoader);
        this._admin.register();
    }

    @Override
    protected WebAppController createController(ExpandVersion version) {
        String key = version.getKey();
        String baseKey = version.getBaseKey();
        String contextPath = this.keyToName(baseKey);
        Path rootDirectory = this.getExpandPath(key);
        if (rootDirectory == null) {
            throw new NullPointerException();
        }
        if (this.isVersioning()) {
            WebAppVersioningController controller = new WebAppVersioningController(this.getId() + "/" + baseKey, baseKey, contextPath, this, this._container);
            controller.setControllerType(DeployControllerType.VERSIONING);
            return controller;
        }
        return this.createVersionController(version);
    }

    public WebAppController createVersionController(ExpandVersion version) {
        String key = version.getKey();
        String baseKey = version.getBaseKey();
        String contextPath = this.keyToName(baseKey);
        Path rootDirectory = this.getExpandPath(key);
        Path archivePath = this.getArchivePath(key);
        String id = this.getId() + "/" + key;
        WebAppController controller = new WebAppController(id, rootDirectory, this._container, contextPath);
        controller.setArchivePath(archivePath);
        controller.setWarName(key);
        controller.setParentWebApp(this._parent);
        controller.setDynamicDeploy(true);
        controller.setSourceType("expand");
        controller.setControllerType(DeployControllerType.DYNAMIC);
        controller.setStartupMode(this.getStartupMode());
        controller.setRedeployMode(this.getRedeployMode());
        controller.setVersion(version.getVersion());
        return controller;
    }

    @Override
    protected void afterUpdate() {
        this._container.clearCache();
    }

    @Override
    protected void mergeController(WebAppController controller, String key) {
        try {
            Path expandDirectory = this.getExpandDirectory();
            Path rootDirectory = controller.getRootDirectory();
            if (!expandDirectory.equals((Object)rootDirectory.getParent())) {
                return;
            }
            super.mergeController(controller, key);
            if (controller.getArchivePath() == null) {
                String archiveName = rootDirectory.getTail() + ".war";
                Path jarPath = this.getArchiveDirectory().lookup(archiveName);
                if (!jarPath.isDirectory()) {
                    controller.setArchivePath(jarPath);
                    controller.addDepend(jarPath);
                }
            }
            controller.setStartupMode(this.getStartupMode());
            for (int i = 0; i < this._webAppDefaults.size(); ++i) {
                controller.addConfigDefault((DeployConfig)this._webAppDefaults.get(i));
            }
            WebAppConfig cfg = this._webAppConfigMap.get(rootDirectory);
            if (cfg != null) {
                if (cfg.getContextPath() != null) {
                    controller.setContextPath(cfg.getContextPath());
                }
                controller.addConfigDefault(cfg);
            }
        }
        catch (ConfigException e) {
            log.warning(e.toString());
            log.log(Level.FINEST, e.toString(), e);
            controller.setConfigException(e);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            controller.setConfigException(e);
        }
    }

    @Override
    protected String keyToName(String key) {
        if (key.equalsIgnoreCase("root")) {
            return this._urlPrefix;
        }
        return this._urlPrefix + "/" + key;
    }

    @Override
    protected String nameToKey(String name) {
        if (!name.startsWith(this._urlPrefix)) {
            return null;
        }
        String key = this._nameToKeyMap.get(name);
        if (key != null) {
            return key;
        }
        String tail = name.substring(this._urlPrefix.length());
        if (tail.startsWith("/")) {
            tail = tail.substring(1);
        }
        key = tail.equals("") ? "ROOT" : tail;
        return key;
    }

    @Override
    protected void destroyImpl() {
        this._admin.unregister();
        this._container.removeWebAppDeploy(this);
        Environment.removeEnvironmentListener((EnvironmentListener)this, (ClassLoader)this._parentLoader);
        super.destroyImpl();
    }
}

