/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigAdmin;
import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.management.server.ConfigMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.management.server.WebAppMXBean;
import com.caucho.server.host.Host;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppController;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class WebAppAdmin
extends DeployControllerAdmin<WebAppController>
implements WebAppMXBean {
    public WebAppAdmin(WebAppController controller) {
        super(controller);
    }

    @Override
    public HostMXBean getHost() {
        Host host = ((WebAppController)this.getController()).getHost();
        if (host != null) {
            return host.getAdmin();
        }
        return null;
    }

    @Override
    public SessionManagerMXBean getSessionManager() {
        WebApp app = this.getWebApp();
        if (app == null) {
            return null;
        }
        return app.getSessionManager().getAdmin();
    }

    @Override
    public ConfigMXBean[] getConfigs() {
        WebApp app = this.getWebApp();
        if (app == null) {
            return null;
        }
        Collection beans = ConfigAdmin.getMBeans((ClassLoader)app.getClassLoader());
        ConfigMXBean[] array = new ConfigMXBean[beans.size()];
        beans.toArray(array);
        return array;
    }

    @Override
    public String getContextPath() {
        return ((WebAppController)this.getController()).getContextPath();
    }

    @Override
    public String getVersion() {
        return ((WebAppController)this.getController()).getVersion();
    }

    @Override
    public Map<String, String> getManifestAttributes() {
        return ((WebAppController)this.getController()).getManifestAttributes();
    }

    @Override
    public boolean isEnabled() {
        WebApp webApp = this.getWebApp();
        return webApp != null && webApp.isEnabled();
    }

    @Override
    public long getStatus500CountTotal() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getStatus500CountTotal();
        }
        return 0L;
    }

    @Override
    public Date getStatus500LastTime() {
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return null;
        }
        long lastTime = webApp.getStatus500LastTime();
        if (lastTime > 0L) {
            return new Date(lastTime);
        }
        return null;
    }

    @Override
    public int getRequestCount() {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            return webApp.getRequestCount();
        }
        return 0;
    }

    @Override
    public long getRequestCountTotal() {
        return ((WebAppController)this.getController()).getLifetimeConnectionCount();
    }

    @Override
    public long getRequestTimeTotal() {
        return ((WebAppController)this.getController()).getLifetimeConnectionTime();
    }

    @Override
    public long getRequestReadBytesTotal() {
        return ((WebAppController)this.getController()).getLifetimeReadBytes();
    }

    @Override
    public long getRequestWriteBytesTotal() {
        return ((WebAppController)this.getController()).getLifetimeWriteBytes();
    }

    @Override
    public long getClientDisconnectCountTotal() {
        return ((WebAppController)this.getController()).getLifetimeClientDisconnectCount();
    }

    protected WebApp getWebApp() {
        return ((WebAppController)this.getController()).getWebApp();
    }
}

