/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class StatisticsFilterChain
implements FilterChain {
    private final FilterChain _next;
    private WebApp _webApp;

    public StatisticsFilterChain(FilterChain next, WebApp webApp) {
        this._next = next;
        this._webApp = webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block6: {
            ClientDisconnectException clientDisconnectException;
            QSocket socket;
            long writeBytes;
            long readBytes;
            long time;
            block5: {
                HttpServletRequestImpl httpRequest;
                SocketLink connection;
                if (!(request instanceof HttpServletRequestImpl) || !((connection = (httpRequest = (HttpServletRequestImpl)request).getConnection()) instanceof TcpSocketLink)) break block6;
                TcpSocketLink tcpConnection = (TcpSocketLink)connection;
                time = CurrentTime.getExactTime();
                readBytes = -1L;
                writeBytes = -1L;
                socket = tcpConnection.getSocket();
                readBytes = socket.getTotalReadBytes();
                writeBytes = socket.getTotalWriteBytes();
                clientDisconnectException = null;
                try {
                    this._next.doFilter(request, response);
                    if (httpRequest.getResponse() == null) break block5;
                    httpRequest.getResponse().flushBuffer();
                }
                catch (ClientDisconnectException ex) {
                    try {
                        clientDisconnectException = ex;
                    }
                    catch (Throwable throwable) {
                        time = CurrentTime.getExactTime() - time;
                        readBytes = socket.getTotalReadBytes() - readBytes;
                        writeBytes = socket.getTotalWriteBytes() - writeBytes;
                        this._webApp.updateStatistics(time, (int)readBytes, (int)writeBytes, clientDisconnectException != null);
                        throw throwable;
                    }
                    time = CurrentTime.getExactTime() - time;
                    readBytes = socket.getTotalReadBytes() - readBytes;
                    writeBytes = socket.getTotalWriteBytes() - writeBytes;
                    this._webApp.updateStatistics(time, (int)readBytes, (int)writeBytes, clientDisconnectException != null);
                }
            }
            time = CurrentTime.getExactTime() - time;
            readBytes = socket.getTotalReadBytes() - readBytes;
            writeBytes = socket.getTotalWriteBytes() - writeBytes;
            this._webApp.updateStatistics(time, (int)readBytes, (int)writeBytes, clientDisconnectException != null);
            if (clientDisconnectException != null) {
                throw clientDisconnectException;
            }
            return;
        }
        this._next.doFilter(request, response);
    }
}

