/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.VersionFactory;
import com.caucho.config.Configurable;
import com.caucho.server.webapp.ListenerConfig;
import com.caucho.server.webapp.ServletContextCompat;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class ServletContextImpl
extends ServletContextCompat
implements ServletContext {
    static final Logger log = Logger.getLogger(ServletContextImpl.class.getName());
    static final L10N L = new L10N(ServletContextImpl.class);
    private String _name;
    private HashMap<String, Object> _attributes = new HashMap();
    private ArrayList<ServletContextAttributeListener> _applicationAttributeListeners;
    private HashMap<String, String> _initParams = new HashMap();

    public Path getRootDirectory() {
        throw new UnsupportedOperationException();
    }

    public void setDisplayName(String name) {
        this._name = name;
    }

    public String getServletContextName() {
        return this._name;
    }

    public String getContextPath() {
        return this._name;
    }

    protected void addAttributeListener(ServletContextAttributeListener listener) {
        if (this._applicationAttributeListeners == null) {
            this._applicationAttributeListeners = new ArrayList();
        }
        this._applicationAttributeListeners.add(listener);
    }

    public String getServerInfo() {
        return "Resin/" + VersionFactory.getVersion();
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public boolean setInitParameter(String name, String value) {
        if (this.isActive()) {
            throw new IllegalStateException(L.l("setInitParameter must be called before the web-app has been initialized, because it's required by the servlet spec."));
        }
        if (this._initParams.containsKey(name)) {
            return false;
        }
        this._initParams.put(name, value);
        return true;
    }

    protected void setInitParam(String name, String value) {
        this._initParams.put(name, value);
    }

    public String getInitParameter(String name) {
        return this._initParams.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            Object value = this._attributes.get(name);
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<String> getAttributeNames() {
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            return Collections.enumeration(this._attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = value != null ? this._attributes.put(name, value) : this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                ServletContextAttributeListener objListener;
                ServletContextAttributeListener listener = objListener = this._applicationAttributeListeners.get(i);
                try {
                    if (oldValue != null) {
                        listener.attributeReplaced(event);
                        continue;
                    }
                    listener.attributeAdded(event);
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        HashMap<String, Object> hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, oldValue);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                ServletContextAttributeListener objListener;
                ServletContextAttributeListener listener = objListener = this._applicationAttributeListeners.get(i);
                try {
                    listener.attributeRemoved(event);
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
    }

    public String getRealPath(String uri) {
        return this.getRootDirectory().lookup("./" + uri).getNativePath();
    }

    public URL getResource(String name) throws MalformedURLException {
        if (!name.startsWith("/")) {
            throw new MalformedURLException(name);
        }
        String realPath = this.getRealPath(name);
        Path rootDirectory = this.getRootDirectory();
        Path path = rootDirectory.lookupNative(realPath);
        URL url = new URL("jndi:/server" + this.getContextPath() + name);
        if (path.exists() && name.startsWith("/resources/")) {
            return url;
        }
        if (path.isFile()) {
            return new URL(path.getURL());
        }
        if (this.getClassLoader().getResource("META-INF/resources/" + realPath) != null) {
            return url;
        }
        if (path.exists()) {
            return new URL(path.getURL());
        }
        return null;
    }

    public URLConnection getResource(URL url) throws IOException {
        String context;
        int fileIdx;
        if (!"jndi".equals(url.getProtocol())) {
            return null;
        }
        String file = url.getFile();
        if ("".equals(url.getHost()) && file.startsWith("/server")) {
            if ((file = file.substring(7, file.length())).startsWith(this.getContextPath())) {
                file = file.substring(this.getContextPath().length());
            } else {
                String contextPath;
                WebApp webApp;
                int p = file.indexOf(47, 1);
                if (p > 0 && (webApp = (WebApp)this.getContext(contextPath = file.substring(0, p))) != null) {
                    return webApp.getResource(url);
                }
            }
        }
        String realPath = this.getRealPath(file);
        Path rootDirectory = this.getRootDirectory();
        Path path = rootDirectory.lookup(realPath);
        if (path.exists()) {
            return new URL(path.getURL()).openConnection();
        }
        URLConnection connection = null;
        if (file.length() > 1 && (fileIdx = file.indexOf("/", 1)) > -1 && (context = file.substring(0, file.indexOf("/", 1))).equals(this.getContextPath()) && (path = rootDirectory.lookup(realPath = this.getRealPath(file = file.substring(fileIdx, file.length())))).exists()) {
            connection = new URL(path.getURL()).openConnection();
        }
        if (connection != null) {
            return connection;
        }
        return new FileNotFoundURLConnection(url);
    }

    public Path getCauchoPath(String name) {
        String realPath = this.getRealPath(name);
        Path rootDirectory = this.getRootDirectory();
        Path path = rootDirectory.lookupNative(realPath);
        return path;
    }

    public InputStream getResourceAsStream(String uripath) {
        Path rootDirectory = this.getRootDirectory();
        Path path = rootDirectory.lookupNative(this.getRealPath(uripath));
        try {
            if (path.canRead()) {
                return path.openRead();
            }
            String resource = "META-INF/resources" + uripath;
            return this.getClassLoader().getResourceAsStream(resource);
        }
        catch (IOException e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    public Set<String> getResourcePaths(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        Path path = this.getRootDirectory().lookup(this.getRealPath(prefix));
        HashSet<String> set = new HashSet<String>();
        try {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                if (path.lookup(list[i]).isDirectory()) {
                    set.add(prefix + list[i] + '/');
                    continue;
                }
                set.add(prefix + list[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return set;
    }

    public ServletContext getContext(String uri) {
        return this;
    }

    public String getMimeType(String uri) {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String servletName) {
        return null;
    }

    public final void log(String message) {
        this.log(message, null);
    }

    public final void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String message, Throwable e) {
        if (e != null) {
            log.log(Level.WARNING, message, e);
        } else {
            log.info(message);
        }
    }

    public Servlet getServlet(String name) {
        throw new UnsupportedOperationException("getServlet is deprecated");
    }

    public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException("getServletNames is deprecated");
    }

    public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException("getServlets is deprecated");
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> modes) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public ServletRegistration getServletRegistration(String servletName) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
        throw new UnsupportedOperationException("unimplemented");
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        throw new UnsupportedOperationException("unimplemented");
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Configurable
    public void addListener(ListenerConfig config) throws Exception {
    }

    public void addListener(String className) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public <T extends EventListener> void addListener(T t) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ClassLoader getClassLoader() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected boolean isActive() {
        throw new UnsupportedOperationException("unimplemented");
    }

    public <T extends EventListener> T createListener(Class<T> listenerClass) throws ServletException {
        return null;
    }

    class FileNotFoundURLConnection
    extends URLConnection {
        FileNotFoundURLConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            throw new FileNotFoundException(this.url.toString());
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.url + "]";
        }
    }
}

