/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.enhancer.ScanClass;
import com.caucho.loader.enhancer.ScanListener;
import com.caucho.server.webapp.ClassHierarchyScanClass;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

class ClassHierarchyScanListener
implements ScanListener {
    private static final Logger log = Logger.getLogger(ClassHierarchyScanListener.class.getName());
    private final ClassLoader _loader;
    private final ArrayList<Entry> _classList = new ArrayList();

    ClassHierarchyScanListener(ClassLoader loader) {
        this._loader = loader;
    }

    public ScanClass scanClass(Path root, String packageRoot, String name, int modifiers) {
        ClassHierarchyScanClass scanClass = new ClassHierarchyScanClass(this, name);
        return scanClass;
    }

    void addEntry(String name, String superName) {
        if (superName == null || "java.lang.Object".equals(superName)) {
            return;
        }
        this._classList.add(new Entry(name, superName));
    }

    public HashSet<Class<?>> findClasses(Class<?>[] value) {
        int i;
        int oldSize;
        ArrayList classList = new ArrayList();
        for (Class<?> cl : value) {
            classList.add(cl);
        }
        do {
            oldSize = classList.size();
            for (int i2 = oldSize - 1; i2 >= 0; --i2) {
                this.findClasses(classList, ((Class)classList.get(i2)).getName());
            }
        } while (classList.size() != oldSize);
        if (classList.size() == value.length) {
            return null;
        }
        LinkedHashSet classSet = new LinkedHashSet();
        for (i = 0; i < value.length; ++i) {
            classList.remove(0);
        }
        Collections.sort(classList, new ClassComparator());
        for (i = 0; i < classList.size(); ++i) {
            classSet.add(classList.get(i));
        }
        return classSet;
    }

    private void findClasses(ArrayList<Class<?>> classList, String superName) {
        ArrayList<Entry> classEntryList = this._classList;
        int size = classEntryList.size();
        for (int i = 0; i < size; ++i) {
            Entry entry = classEntryList.get(i);
            if (!superName.equals(entry.getSuperName())) continue;
            try {
                Class<?> cl = Class.forName(entry.getName(), false, this._loader);
                if (classList.contains(cl)) continue;
                classList.add(cl);
                continue;
            }
            catch (Exception e) {
                log.finer("ClassHierarchyScan: " + e.toString());
            }
        }
    }

    public boolean isScanMatchAnnotation(CharBuffer string) {
        return false;
    }

    public void classMatchEvent(EnvironmentClassLoader loader, Path root, String className) {
    }

    public int getScanPriority() {
        return 2;
    }

    public boolean isRootScannable(Path root, String packageRoot) {
        return true;
    }

    static class ClassComparator
    implements Comparator<Class<?>> {
        ClassComparator() {
        }

        @Override
        public int compare(Class<?> a, Class<?> b) {
            return a.getName().compareTo(b.getName());
        }
    }

    static class Entry {
        private final String _name;
        private final String _superName;

        Entry(String name, String superName) {
            this._name = name;
            this._superName = superName;
        }

        public String getName() {
            return this._name;
        }

        public String getSuperName() {
            return this._superName;
        }
    }
}

