/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.snmp.types;

import com.caucho.server.snmp.types.SnmpValue;

public class ObjectIdentifierValue
extends SnmpValue {
    protected String _id;

    public ObjectIdentifierValue(String id) {
        this._id = id;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getString() {
        return this._id;
    }

    @Override
    public void toAsn1(StringBuilder sb) {
        char ch;
        StringBuilder innerSb = new StringBuilder();
        int x = 0;
        int i = 0;
        while (i < this._id.length() && (ch = this._id.charAt(i++)) != '.') {
            x = x * 10 + ch - 48;
        }
        int y = 0;
        while (i < this._id.length() && (ch = this._id.charAt(i++)) != '.') {
            y = y * 10 + ch - 48;
        }
        this.encodeInteger(innerSb, x * 40 + y);
        while (i < this._id.length()) {
            int val = 0;
            while (i < this._id.length() && (ch = this._id.charAt(i++)) != '.') {
                val = val * 10 + ch - 48;
            }
            this.encodeInteger(innerSb, val);
        }
        this.header(sb, innerSb.length());
        sb.append((CharSequence)innerSb);
    }

    private void encodeInteger(StringBuilder sb, int val) {
        int len = 1;
        int total = val;
        while ((total >>= 7) > 0) {
            ++len;
        }
        for (int i = 1; i < len; ++i) {
            int shift = (len - i) * 7;
            sb.append((char)(val >> shift & 0x7F | 0x80));
        }
        sb.append((char)(val & 0x7F));
    }

    public String toString() {
        return "ObjectIdentifier[" + this._id + "]";
    }
}

