/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Period;
import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.ClusterCache;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.distcache.ResinCacheBuilder;
import com.caucho.env.meter.AverageSensor;
import com.caucho.env.meter.MeterService;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.json.JsonOutput;
import com.caucho.management.server.SessionManagerMXBean;
import com.caucho.security.Authenticator;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.distcache.AbstractCacheBacking;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.PersistentStoreConfig;
import com.caucho.server.session.HashChunkInputStream;
import com.caucho.server.session.HessianSessionDeserializer;
import com.caucho.server.session.HessianSessionSerializer;
import com.caucho.server.session.JavaSessionDeserializer;
import com.caucho.server.session.JavaSessionSerializer;
import com.caucho.server.session.SessionDeserializer;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManagerAdmin;
import com.caucho.server.session.SessionSerializer;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.Crc64;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.RandomUtil;
import com.caucho.util.WeakAlarm;
import com.caucho.vfs.TempOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public final class SessionManager
implements SessionCookieConfig,
AlarmListener {
    private static final L10N L = new L10N(SessionManager.class);
    private static final Logger log = Logger.getLogger(SessionManager.class.getName());
    private static final int FALSE = 0;
    private static final int COOKIE = 1;
    private static final int TRUE = 2;
    private static final int UNSET = 0;
    private static final int SET_TRUE = 1;
    private static final int SET_FALSE = 2;
    private static final int SAVE_BEFORE_HEADERS = 1;
    private static final int SAVE_BEFORE_FLUSH = 2;
    private static final int SAVE_AFTER_REQUEST = 4;
    private static final int SAVE_ON_SHUTDOWN = 8;
    private static final int[] DECODE = new int[128];
    private final WebApp _webApp;
    private final SessionManagerAdmin _admin;
    private final ServletService _servletContainer;
    private final ClusterServer _selfServer;
    private final int _selfIndex;
    private CacheImpl _sessionStore;
    private LruCache<String, SessionImpl> _sessions;
    private Iterator<SessionImpl> _sessionIter;
    private ArrayList<SessionImpl> _sessionList = new ArrayList();
    private boolean _enableSessionCookies = true;
    private boolean _enableSessionUrls = true;
    private boolean _isAppendServerIndex = false;
    private boolean _isTwoDigitSessionIndex = false;
    private boolean _isInvalidateAfterListener;
    private int _sessionMax = 8192;
    private long _sessionTimeout = 1800000L;
    private String _cookieName = "JSESSIONID";
    private String _sslCookieName;
    private String _sessionSuffix = ";jsessionid=";
    private String _sessionPrefix;
    private int _cookieVersion;
    private String _cookieDomain;
    private String _cookieDomainRegexp;
    private boolean _isCookieUseContextPath;
    private String _cookiePath;
    private long _cookieMaxAge;
    private int _isCookieHttpOnly;
    private String _cookieComment;
    private String _cookiePort;
    private int _reuseSessionId = 1;
    private int _cookieLength = 21;
    private AtomicLong _sessionIdSequence = new AtomicLong();
    private HashSet<SessionTrackingMode> _trackingModes;
    private boolean _isSecure;
    private int _sessionSaveMode = 4;
    private boolean _isPersistenceEnabled = false;
    private boolean _isSaveTriplicate = true;
    private boolean _isSaveBackup = true;
    private boolean _isDestroyOnLru = true;
    private boolean _ignoreSerializationErrors = true;
    private boolean _isHessianSerialization = false;
    private SerializerFactory _hessianFactory;
    private boolean _isSerializeCollectionType = true;
    private ArrayList<HttpSessionListener> _listeners;
    private ArrayList<HttpSessionActivationListener> _activationListeners;
    private ArrayList<HttpSessionAttributeListener> _attributeListeners;
    private int _alwaysLoadSession;
    private int _alwaysSaveSession;
    private boolean _isClosed;
    private String _distributionId;
    private Alarm _alarm;
    private volatile long _sessionCreateCount;
    private volatile long _sessionTimeoutCount;
    private volatile long _sessionInvalidateCount;
    private final AverageSensor _sessionSaveSample;
    private final Charset UTF_8 = Charset.forName("UTF-8");

    public SessionManager(WebApp webApp) throws Exception {
        this._webApp = webApp;
        this._servletContainer = webApp.getServer();
        if (this._servletContainer == null) {
            throw new IllegalStateException(L.l("Server is not active in this context {0}", (Object)Thread.currentThread().getContextClassLoader()));
        }
        this._selfServer = this._servletContainer.getSelfServer();
        this._selfIndex = this._selfServer.getIndex();
        PersistentStoreConfig cfg = this._servletContainer.getPersistentStore();
        if (cfg != null) {
            this.setAlwaysSaveSession(cfg.isAlwaysSave());
            this._isSaveBackup = cfg.isSaveBackup();
            this._isSaveTriplicate = cfg.isSaveTriplicate();
        }
        this._sessionSuffix = this._servletContainer.getSessionURLPrefix();
        this._sessionPrefix = this._servletContainer.getAlternateSessionURLPrefix();
        this._cookieName = this._servletContainer.getSessionCookie();
        this._sslCookieName = this._servletContainer.getSSLSessionCookie();
        long initSequence = CurrentTime.getCurrentTime();
        if (CurrentTime.isTest()) {
            initSequence -= initSequence % 1000L;
        }
        this._sessionIdSequence.set(initSequence);
        String hostName = webApp.getHostName();
        String contextPath = webApp.getContextPath();
        if (hostName == null || hostName.equals("")) {
            hostName = "default";
        }
        String name = hostName + contextPath;
        if (this._distributionId == null) {
            this._distributionId = name;
        }
        this._alarm = new WeakAlarm((AlarmListener)this);
        this._sessionSaveSample = MeterService.createAverageMeter((String)"Resin|Http|Session Save", (String)"Size");
        this._admin = new SessionManagerAdmin(this);
    }

    public SessionManagerMXBean getAdmin() {
        return this._admin;
    }

    public String getSessionPrefix() {
        return this._sessionSuffix;
    }

    public String getAlternateSessionPrefix() {
        return this._sessionPrefix;
    }

    public int getCookieVersion() {
        return this._cookieVersion;
    }

    public void setCookieVersion(int cookieVersion) {
        this._cookieVersion = cookieVersion;
    }

    public void setCookiePort(String port) {
        this._cookiePort = port;
    }

    public void setCookieUseContextPath(boolean isCookieUseContextPath) {
        this._isCookieUseContextPath = isCookieUseContextPath;
    }

    public String getCookiePort() {
        return this._cookiePort;
    }

    public Logger getDebug() {
        return log;
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    ClassLoader getClassLoader() {
        return this.getWebApp().getClassLoader();
    }

    Authenticator getAuthenticator() {
        return this._webApp.getAuthenticator();
    }

    ByteStreamCache getCache() {
        if (this._isPersistenceEnabled) {
            return this._sessionStore;
        }
        return null;
    }

    boolean isAlwaysLoadSession() {
        return this._alwaysLoadSession == 1;
    }

    public void setAlwaysLoadSession(boolean load) {
        this._alwaysLoadSession = load ? 1 : 2;
    }

    boolean getAlwaysSaveSession() {
        return this._alwaysSaveSession == 1;
    }

    public void setAlwaysSaveSession(boolean save) {
        this._alwaysSaveSession = save ? 1 : 2;
    }

    public boolean isSaveOnShutdown() {
        return (this._sessionSaveMode & 8) != 0;
    }

    public boolean isSaveOnlyOnShutdown() {
        return (this._sessionSaveMode & 8) == 8;
    }

    public boolean isSaveBeforeHeaders() {
        return (this._sessionSaveMode & 1) != 0;
    }

    public boolean isSaveBeforeFlush() {
        return (this._sessionSaveMode & 2) != 0;
    }

    public boolean isSaveAfterRequest() {
        return (this._sessionSaveMode & 4) != 0;
    }

    boolean isTwoDigitSessionIndex() {
        return this._isTwoDigitSessionIndex;
    }

    public void setSaveMode(String mode) throws ConfigException {
        if ("before-headers".equals(mode)) {
            this._sessionSaveMode = 1;
        } else if ("after-request".equals(mode)) {
            this._sessionSaveMode = 4;
        } else if ("on-shutdown".equals(mode)) {
            this._sessionSaveMode = 8;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown session save-mode.  Values are: before-headers, after-request, and on-shutdown.", (Object)mode));
        }
    }

    public String getSaveMode() {
        if (this.isSaveBeforeFlush()) {
            return "before-flush";
        }
        if (this.isSaveBeforeHeaders()) {
            return "before-headers";
        }
        if (this.isSaveAfterRequest()) {
            return "after-request";
        }
        if (this.isSaveOnShutdown()) {
            return "on-shutdown";
        }
        return "unknown";
    }

    public void setSaveOnlyOnShutdown(boolean save) {
        log.warning("<save-only-on-shutdown> is deprecated.  Use <save-mode>on-shutdown</save-mode> instead");
        if (save) {
            this._sessionSaveMode = 8;
        }
    }

    public void setSaveOnShutdown(boolean save) {
        log.warning("<save-on-shutdown> is deprecated.  Use <save-only-on-shutdown> instead");
        this.setSaveOnlyOnShutdown(save);
    }

    public void setSerializationType(String type) {
        if ("hessian".equals(type)) {
            this._isHessianSerialization = true;
        } else if ("java".equals(type)) {
            this._isHessianSerialization = false;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown valud for serialization-type.  The valid types are 'hessian' and 'java'.", (Object)type));
        }
    }

    public void setSerializeCollectionType(boolean isEnable) {
        this._isSerializeCollectionType = isEnable;
    }

    public boolean isHessianSerialization() {
        return this._isHessianSerialization;
    }

    public void setInvalidateAfterListener(boolean inv) {
        this._isInvalidateAfterListener = inv;
    }

    public boolean isInvalidateAfterListener() {
        return this._isInvalidateAfterListener;
    }

    public int getActiveSessionCount() {
        if (this._sessions == null) {
            return -1;
        }
        return this._sessions.size();
    }

    public int getSessionActiveCount() {
        return this.getActiveSessionCount();
    }

    public long getSessionCreateCount() {
        return this._sessionCreateCount;
    }

    public long getSessionTimeoutCount() {
        return this._sessionTimeoutCount;
    }

    public long getSessionInvalidateCount() {
        return this._sessionInvalidateCount;
    }

    public void addListener(HttpSessionListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    ArrayList<HttpSessionListener> getListeners() {
        return this._listeners;
    }

    public void addActivationListener(HttpSessionActivationListener listener) {
        if (this._activationListeners == null) {
            this._activationListeners = new ArrayList();
        }
        this._activationListeners.add(listener);
    }

    ArrayList<HttpSessionActivationListener> getActivationListeners() {
        return this._activationListeners;
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        if (this._attributeListeners == null) {
            this._attributeListeners = new ArrayList();
        }
        this._attributeListeners.add(listener);
    }

    ArrayList<HttpSessionAttributeListener> getAttributeListeners() {
        return this._attributeListeners;
    }

    boolean getIgnoreSerializationErrors() {
        return this._ignoreSerializationErrors;
    }

    public void setIgnoreSerializationErrors(boolean ignore) {
        this._ignoreSerializationErrors = ignore;
    }

    public int getReuseSessionId() {
        return this._reuseSessionId;
    }

    public boolean reuseSessionId(boolean fromCookie) {
        int reuseSessionId = this._reuseSessionId;
        return reuseSessionId == 2 || fromCookie && reuseSessionId == 1;
    }

    public void setReuseSessionId(String reuse) throws ConfigException {
        if (reuse == null) {
            this._reuseSessionId = 1;
        } else if (reuse.equalsIgnoreCase("true") || reuse.equalsIgnoreCase("yes") || reuse.equalsIgnoreCase("cookie")) {
            this._reuseSessionId = 1;
        } else if (reuse.equalsIgnoreCase("false") || reuse.equalsIgnoreCase("no")) {
            this._reuseSessionId = 0;
        } else if (reuse.equalsIgnoreCase("all")) {
            this._reuseSessionId = 2;
        } else {
            throw new ConfigException(L.l("'{0}' is an invalid value for reuse-session-id.  'true' or 'false' are the allowed values.", (Object)reuse));
        }
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setUsePersistentStore(boolean enable) throws Exception {
        this._isPersistenceEnabled = enable;
    }

    public boolean isUsePersistentStore() {
        return this.isPersistenceEnabled();
    }

    public boolean isPersistenceEnabled() {
        return this._isPersistenceEnabled;
    }

    public void setDestroyOnLru(boolean isDestroy) {
        this._isDestroyOnLru = isDestroy;
    }

    public boolean isDestroyOnLru() {
        return this._isDestroyOnLru || !this.isPersistenceEnabled();
    }

    public String getDistributionId() {
        return this._distributionId;
    }

    public void setDistributionId(String distributionId) {
        this._distributionId = distributionId;
    }

    public long getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setSessionTimeout(long timeout) {
        this._sessionTimeout = timeout <= 0L || 0x3FFFFFFFL < timeout ? 0x3FFFFFFFFFFFFFFFL : 60000L * timeout;
    }

    public long getMaxIdleTime() {
        return this._sessionTimeout;
    }

    public int getSessionMax() {
        return this._sessionMax;
    }

    public void setSessionMax(int max) {
        if (max < 1) {
            throw new ConfigException(L.l("session-max '{0}' is too small.  session-max must be a positive number", (long)max));
        }
        this._sessionMax = max;
    }

    public boolean enableSessionCookies() {
        return this._enableSessionCookies;
    }

    public void setEnableCookies(boolean enableCookies) {
        this._enableSessionCookies = enableCookies;
    }

    public boolean enableSessionUrls() {
        return this._enableSessionUrls;
    }

    public void setEnableUrlRewriting(boolean enableUrls) {
        this._enableSessionUrls = enableUrls;
    }

    public void setName(String name) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this.setCookieName(name);
    }

    public String getName() {
        return this.getCookieName();
    }

    public void setDomain(String domain) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this.setCookieDomain(domain);
    }

    public String getDomain() {
        return this.getCookieDomain();
    }

    public void setPath(String path) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this._cookiePath = path;
    }

    public String getPath() {
        return this._cookiePath;
    }

    public void setComment(String comment) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this._cookieComment = comment;
    }

    public String getComment() {
        return this._cookieComment;
    }

    public void setHttpOnly(boolean httpOnly) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this.setCookieHttpOnly(httpOnly);
    }

    public boolean isHttpOnly() {
        return this.isCookieHttpOnly();
    }

    public void setSecure(boolean secure) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException(L.l("SessionCookieConfig must be set during initialization"));
        }
        this._isSecure = secure;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public void setMaxAge(int maxAge) {
        if (!this._webApp.isInitializing()) {
            throw new IllegalStateException();
        }
        this._cookieMaxAge = maxAge * 1000;
    }

    public int getMaxAge() {
        return (int)(this._cookieMaxAge / 1000L);
    }

    @Configurable
    public SessionCookieConfig createCookieConfig() {
        return this;
    }

    public void setCookieName(String cookieName) {
        this._cookieName = cookieName;
    }

    public void setTrackingMode(SessionTrackingMode mode) {
        if (this._trackingModes == null) {
            this._trackingModes = new HashSet();
            this.setEnableCookies(false);
            this.setEnableUrlRewriting(false);
        }
        switch (mode) {
            case COOKIE: {
                this.setEnableCookies(true);
                break;
            }
            case URL: {
                this.setEnableUrlRewriting(true);
            }
        }
    }

    public String getCookieName() {
        return this._cookieName;
    }

    public String getSSLCookieName() {
        if (this._sslCookieName != null) {
            return this._sslCookieName;
        }
        return this._cookieName;
    }

    public String getCookieDomain() {
        return this._cookieDomain;
    }

    public void setCookieDomain(String domain) {
        this._cookieDomain = domain;
    }

    public String getCookieDomainRegexp() {
        return this._cookieDomainRegexp;
    }

    public void setCookieDomainRegexp(String regexp) {
        this._cookieDomainRegexp = regexp;
    }

    public void setCookiePath(String path) {
        this._cookiePath = path;
    }

    public long getCookieMaxAge() {
        return this._cookieMaxAge;
    }

    public void setCookieMaxAge(Period maxAge) {
        this._cookieMaxAge = maxAge.getPeriod();
    }

    public boolean isCookieSecure() {
        if (this._isSecure) {
            return true;
        }
        return !this._cookieName.equals(this._sslCookieName);
    }

    public void setCookieSecure(boolean isSecure) {
        this._isSecure = isSecure;
    }

    public boolean isCookieHttpOnly() {
        if (this._isCookieHttpOnly == 1) {
            return true;
        }
        if (this._isCookieHttpOnly == 2) {
            return false;
        }
        return this.getWebApp().getCookieHttpOnly();
    }

    public void setCookieHttpOnly(boolean httpOnly) {
        this._isCookieHttpOnly = httpOnly ? 1 : 2;
    }

    public void setCookieLength(int cookieLength) {
        if (cookieLength < 7) {
            cookieLength = 7;
        }
        this._cookieLength = cookieLength;
    }

    public long getCookieLength() {
        return this._cookieLength;
    }

    public void setCookieModuloCluster(boolean isModulo) {
    }

    public void setCookieAppendServerIndex(boolean isAppend) {
        this._isAppendServerIndex = isAppend;
    }

    public boolean isCookieAppendServerIndex() {
        return this._isAppendServerIndex;
    }

    public void init() {
        if (this._sessionSaveMode == 8 && (this._alwaysSaveSession == 1 || this._alwaysLoadSession == 1)) {
            throw new ConfigException(L.l("save-mode='on-shutdown' cannot be used with <always-save-session/> or <always-load-session/>"));
        }
        this._sessions = new LruCache(this._sessionMax);
        this._sessionIter = this._sessions.values();
        if (this._isPersistenceEnabled) {
            AbstractCacheBacking<?, ?> backing;
            ClusterCache cacheBuilder = new ClusterCache();
            cacheBuilder.setName("resin:session");
            if (this._isSaveTriplicate) {
                cacheBuilder.setScopeMode(ResinCacheBuilder.Scope.CLUSTER);
            } else if (this._isSaveBackup) {
                cacheBuilder.setScopeMode(ResinCacheBuilder.Scope.CLUSTER);
            } else {
                cacheBuilder.setScopeMode(ResinCacheBuilder.Scope.LOCAL);
            }
            if (this.isAlwaysLoadSession()) {
                cacheBuilder.setLocalExpireTimeoutMillis(20L);
            } else {
                cacheBuilder.setLocalExpireTimeoutMillis(1000L);
            }
            cacheBuilder.setAccessedExpireTimeoutMillis(this._sessionTimeout);
            cacheBuilder.setLeaseExpireTimeoutMillis(300000L);
            cacheBuilder.setLocalExpireTimeoutMillis(100L);
            PersistentStoreConfig persistConfig = PersistentStoreConfig.getCurrent();
            if (persistConfig != null && (backing = persistConfig.getBacking()) != null) {
                cacheBuilder.setBacking(backing);
                cacheBuilder.setReadThroughExpireTimeoutMillis(500L);
            }
            this._sessionStore = cacheBuilder.createIfAbsent();
        }
        if (this._cookiePath == null && this._isCookieUseContextPath) {
            this._cookiePath = this._webApp.getContextPath();
        }
        if (this._cookiePath == null || "".equals(this._cookiePath)) {
            this._cookiePath = "/";
        }
    }

    public void start() throws Exception {
        this._alarm.queue(60000L);
    }

    public ByteStreamCache getSessionStore() {
        return this._sessionStore;
    }

    public SessionSerializer createSessionSerializer(OutputStream os) throws IOException {
        if (this._isHessianSerialization) {
            if (this._hessianFactory == null) {
                this._hessianFactory = new SerializerFactory(this.getClassLoader());
            }
            HessianSessionSerializer ser = new HessianSessionSerializer(os, this._hessianFactory);
            ser.setSerializeCollectionType(this._isSerializeCollectionType);
            return ser;
        }
        return new JavaSessionSerializer(os, this.getClassLoader());
    }

    public SessionDeserializer createSessionDeserializer(InputStream is) throws IOException {
        if (this._isHessianSerialization) {
            return new HessianSessionDeserializer(is, this.getClassLoader());
        }
        return new JavaSessionDeserializer(is, this.getClassLoader());
    }

    public boolean containsSession(String id) {
        return this._sessions.get((Object)id) != null;
    }

    public String createSessionId(HttpServletRequest request) {
        return this.createSessionId(request, false);
    }

    public String createSessionId(HttpServletRequest request, boolean create) {
        String id;
        do {
            id = this.createSessionIdImpl(request);
        } while (create && this.getSession(id, 0L, create, true) != null);
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    public String createCookieValue() {
        return this.createCookieValue(null);
    }

    public String createSessionIdImpl(HttpServletRequest request) {
        Object owner = request.getAttribute("caucho.session-server-id");
        return this.createCookieValue(owner);
    }

    public boolean isOwner(String id) {
        return id.startsWith(this._selfServer.getServerClusterId());
    }

    protected String createCookieValue(Object owner) {
        int i;
        StringBuilder sb = new StringBuilder();
        int index = this._selfIndex;
        CloudServer server = this._selfServer.getCloudServer();
        if (owner != null) {
            if (owner instanceof Number) {
                index = ((Number)owner).intValue();
                int podIndex = this._selfServer.getCloudPod().getIndex();
                server = this._selfServer.getCluster().findServer(podIndex, index);
                if (server == null) {
                    server = this._selfServer.getCloudServer();
                }
            } else if (owner instanceof String && (server = this._selfServer.getCluster().findServer((String)owner)) == null) {
                server = this._selfServer.getCloudServer();
            }
        }
        index = server.getIndex();
        ClusterServer clusterServer = server.getData(ClusterServer.class);
        clusterServer.generateIdPrefix(sb);
        int length = this._cookieLength;
        length -= sb.length();
        long random = RandomUtil.getRandomLong();
        for (i = 0; i < 11 && length-- > 0; ++i) {
            sb.append(SessionManager.convert(random));
            random >>= 6;
        }
        if (length > 0) {
            long seq = this._sessionIdSequence.incrementAndGet();
            for (int i2 = 0; i2 < 7 && length-- > 0; ++i2) {
                sb.append(SessionManager.convert(seq));
                seq >>= 6;
            }
        }
        while (length > 0) {
            random = RandomUtil.getRandomLong();
            for (i = 0; i < 11 && length-- > 0; ++i) {
                sb.append(SessionManager.convert(random));
                random >>= 6;
            }
        }
        if (this._isAppendServerIndex) {
            sb.append('.');
            sb.append(index + 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl createSession(boolean isCreate, HttpServletRequest request, String sessionId, long now, boolean fromCookie) {
        ExtCacheEntry entry;
        if (this._sessions == null) {
            return null;
        }
        SessionImpl session = (SessionImpl)this._sessions.get((Object)sessionId);
        if (session != null) {
            if (!session.isValid()) {
                session = null;
            } else if (!session.getId().equals(sessionId)) {
                log.warning("Session creation issue. Old session " + session.getId() + " " + sessionId);
                session = null;
            }
        }
        boolean isNew = false;
        if (session == null && sessionId != null && this._sessionStore != null && (entry = this._sessionStore.getExtCacheEntry(sessionId)) != null && !entry.isValueNull()) {
            session = this.create(sessionId, now, isCreate);
            isNew = true;
        }
        if (session != null) {
            SessionImpl sessionImpl = session;
            synchronized (sessionImpl) {
                if (session.isTimeout(now)) {
                    session.invalidateTimeout();
                    session = null;
                } else {
                    session.addUse();
                    if (session.load(isNew)) {
                        if (isCreate) {
                            session.setAccess(now);
                        }
                        return session;
                    }
                    session.endUse();
                    if (!isNew) {
                        if (log.isLoggable(Level.FINER)) {
                            log.fine(session + " load failed for existing session");
                        }
                        session.reset(0L);
                    }
                }
            }
        }
        if (!isCreate) {
            return null;
        }
        if (sessionId == null || sessionId.length() <= 6 || !this.reuseSessionId(fromCookie)) {
            sessionId = this.createSessionId(request, true);
        }
        session = new SessionImpl(this, sessionId, now);
        if (!sessionId.equals((session = (SessionImpl)this._sessions.putIfNew((Object)sessionId, (Object)session)).getId())) {
            throw new IllegalStateException(sessionId + " != " + session.getId());
        }
        if (!session.addUse()) {
            throw new IllegalStateException(L.l("Can't use session for unknown reason"));
        }
        ++this._sessionCreateCount;
        session.create(now, true);
        this.handleCreateListeners(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl getSession(String key, long now, boolean create, boolean fromCookie) {
        boolean isNew = false;
        boolean killSession = false;
        if (this._sessions == null) {
            return null;
        }
        SessionImpl session = (SessionImpl)this._sessions.get((Object)key);
        if (session != null && !session.getId().equals(key)) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        if (now <= 0L) {
            return session;
        }
        if (session != null && !session.addUse()) {
            session = null;
        }
        if (session == null && this._sessionStore != null) {
            session = this.create(key, now, create);
            if (!session.addUse()) {
                session = null;
            }
            isNew = true;
        }
        if (session == null) {
            return null;
        }
        SessionImpl sessionImpl = session;
        synchronized (sessionImpl) {
            if (isNew) {
                isNew = killSession = !this.load(session, now, create);
            } else if (!session.load(isNew)) {
                if (log.isLoggable(Level.FINER)) {
                    log.fine(session + " load failed for existing session");
                }
                session.setModified();
                isNew = true;
            }
        }
        if (!(!killSession || create && this.reuseSessionId(fromCookie))) {
            session.endUse();
            this._sessions.remove((Object)key);
            return null;
        }
        if (isNew) {
            this.handleCreateListeners(session);
        }
        return session;
    }

    public SessionImpl getSession(String key) {
        LruCache<String, SessionImpl> sessions = this._sessions;
        if (sessions != null) {
            return (SessionImpl)sessions.get((Object)key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl createSession(String oldId, long now, HttpServletRequest request, boolean fromCookie) {
        SessionImpl session;
        if (this._sessions == null) {
            log.fine(this + " createSession called when sessionManager closed");
            return null;
        }
        String id = oldId;
        if (id == null || id.length() < 4 || !this.reuseSessionId(fromCookie)) {
            id = this.createSessionId(request, true);
        }
        if ((session = this.create(id, now, true)) == null) {
            return null;
        }
        session.addUse();
        ++this._sessionCreateCount;
        SessionImpl sessionImpl = session;
        synchronized (sessionImpl) {
            if (this._isPersistenceEnabled && id.equals(oldId)) {
                this.load(session, now, true);
            } else {
                session.create(now, true);
            }
        }
        this.handleCreateListeners(session);
        return session;
    }

    private SessionImpl create(String key, long now, boolean isCreate) {
        SessionImpl session = new SessionImpl(this, key, now);
        if (!key.equals((session = (SessionImpl)this._sessions.putIfNew((Object)key, (Object)session)).getId())) {
            throw new IllegalStateException(key + " != " + session.getId());
        }
        return session;
    }

    public void notifyRemove(String id) {
        SessionImpl session = (SessionImpl)this._sessions.get((Object)id);
        if (session != null) {
            session.invalidateRemote();
        }
    }

    private void handleCreateListeners(SessionImpl session) {
        ArrayList<HttpSessionListener> listeners = this._listeners;
        if (listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (int i = 0; i < listeners.size(); ++i) {
                HttpSessionListener listener = listeners.get(i);
                listener.sessionCreated(event);
            }
        }
    }

    private boolean load(SessionImpl session, long now, boolean isCreate) {
        try {
            if (now <= 0L) {
                return false;
            }
            if (session.load(true)) {
                session.setAccess(now);
                return true;
            }
            session.create(now, isCreate);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            session.reset(now);
        }
        return false;
    }

    void addSession(SessionImpl session) {
        this._sessions.put((Object)session.getId(), (Object)session);
    }

    void removeSession(SessionImpl session) {
        this._sessions.remove((Object)session.getId());
    }

    void addSessionSaveSample(long size) {
        this._sessionSaveSample.add(size);
    }

    public String getSessionSerializationDebug(String id) {
        ByteStreamCache cache = this.getCache();
        if (cache == null) {
            return null;
        }
        if (!this._isHessianSerialization) {
            return "session is not hessian";
        }
        try {
            TempOutputStream os = new TempOutputStream();
            if (cache.get(id, (OutputStream)os)) {
                InputStream is = os.getInputStream();
                is = new HashChunkInputStream(is);
                StringWriter writer = new StringWriter();
                HessianDebugInputStream dis = new HessianDebugInputStream(is, new PrintWriter(writer));
                while (dis.read() >= 0) {
                }
                return writer.toString();
            }
            os.close();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return e.toString();
        }
        return null;
    }

    public String getSessionAsJsonString(String id) {
        SessionImpl session = this.getSession(id);
        if (session == null) {
            return null;
        }
        TempOutputStream buffer = new TempOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)buffer, this.UTF_8));
        JsonOutput jsonOutput = new JsonOutput(out);
        try {
            jsonOutput.writeObject(session, true);
            jsonOutput.flush();
            jsonOutput.close();
            out.flush();
            return new String(buffer.toByteArray(), this.UTF_8);
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("can't serialize session {0} due to {1}", (Object)session, (Object)e), e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] sessionIdList() {
        ArrayList<Object> sessionIds = new ArrayList<Object>();
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            Iterator sessionsIterator = this._sessions.iterator();
            while (sessionsIterator.hasNext()) {
                sessionIds.add(((LruCache.Entry)sessionsIterator.next()).getKey());
            }
        }
        String[] ids = new String[sessionIds.size()];
        sessionIds.toArray(ids);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSessionsAsJsonString() {
        ArrayList<Object> sessionList;
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            sessionList = new ArrayList<Object>(this._sessions.size());
            Iterator sessionsIterator = this._sessions.iterator();
            while (sessionsIterator.hasNext()) {
                sessionList.add(((LruCache.Entry)sessionsIterator.next()).getValue());
            }
        }
        SessionImpl[] sessions = new SessionImpl[sessionList.size()];
        sessionList.toArray(sessions);
        TempOutputStream buffer = new TempOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)buffer, this.UTF_8));
        JsonOutput jsonOutput = new JsonOutput(out);
        try {
            jsonOutput.writeObject(sessions, true);
            jsonOutput.flush();
            jsonOutput.close();
            out.flush();
            return new String(buffer.toByteArray(), this.UTF_8);
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("can't serialize sessions due to {0}", (Object)e), e);
            }
            return null;
        }
    }

    public long getEstimatedMemorySize() {
        Iterator sessions = this._sessions.values();
        long l = 0L;
        while (sessions.hasNext()) {
            l += (long)((SessionImpl)sessions.next()).getLastSaveLength();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAlarm(Alarm alarm) {
        try {
            SessionImpl session;
            this._sessionList.clear();
            int liveSessions = 0;
            if (this._isClosed) {
                return;
            }
            long now = CurrentTime.getCurrentTime();
            LruCache<String, SessionImpl> lruCache = this._sessions;
            synchronized (lruCache) {
                this._sessionIter = this._sessions.values(this._sessionIter);
                while (this._sessionIter.hasNext()) {
                    session = this._sessionIter.next();
                    if (session.isTimeout(now)) {
                        this._sessionList.add(session);
                        continue;
                    }
                    ++liveSessions;
                }
            }
            this._sessionTimeoutCount += (long)this._sessionList.size();
            for (int i = 0; i < this._sessionList.size(); ++i) {
                session = this._sessionList.get(i);
                try {
                    session.timeout();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
        }
        finally {
            if (!this._isClosed) {
                this._alarm.queue(60000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
        }
        if (this._sessions == null) {
            return;
        }
        Alarm alarm = this._alarm;
        this._alarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        ArrayList<SessionImpl> list = new ArrayList<SessionImpl>();
        LruCache<String, SessionImpl> lruCache = this._sessions;
        synchronized (lruCache) {
            this._sessionIter = this._sessions.values(this._sessionIter);
            while (this._sessionIter.hasNext()) {
                SessionImpl session = this._sessionIter.next();
                if (!session.isValid()) continue;
                list.add(session);
            }
        }
        boolean isError = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            SessionImpl session = (SessionImpl)list.get(i);
            if (!session.isValid()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("close session " + session.getId());
            }
            try {
                session.saveOnShutdown();
            }
            catch (Exception e) {
                if (!isError) {
                    log.log(Level.WARNING, "Can't store session: " + e, e);
                }
                isError = true;
            }
            try {
                if (!session.isValid()) continue;
                this._sessions.remove((Object)session.getId());
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (this._admin != null) {
            this._admin.unregister();
        }
        this._sessionList = new ArrayList();
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    static int getServerCode(String id, int count) {
        if (id == null) {
            return -1;
        }
        if (count == 0) {
            return SessionManager.decode(id.charAt(0));
        }
        long hash = Crc64.generate((String)id);
        for (int i = 0; i < count; ++i) {
            hash >>= 6;
        }
        return (int)(hash & 0x3FL);
    }

    private static int decode(int code) {
        return DECODE[code & 0x7F];
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._webApp.getContextPath() + "]";
    }

    static {
        for (int i = 0; i < 64; ++i) {
            SessionManager.DECODE[SessionManager.convert((long)((long)i))] = i;
        }
    }
}

