/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteUserCondition
extends AbstractCondition {
    private static final L10N L = new L10N(RemoteUserCondition.class);
    private final String _remoteUser;
    private boolean _sendVary = true;

    public RemoteUserCondition(String remoteUser) {
        this._remoteUser = remoteUser;
    }

    @Override
    public String getTagName() {
        return "remote-user";
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    @Override
    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", "Cookie");
        } else {
            this.addHeaderValue(response, "Cache-Control", "private");
        }
        String remoteUser = request.getRemoteUser();
        return remoteUser != null && remoteUser.equals(this._remoteUser);
    }
}

