/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.server.dispatch.ForwardAbsoluteFilterChain;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.rewrite.AbstractRuleWithConditions;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;

public class ForwardRule
extends AbstractRuleWithConditions {
    private static final L10N L = new L10N(ForwardRule.class);
    private static final Pattern ALL_PATTERN = Pattern.compile("^.*$");
    private String _target;
    private String _absoluteTarget;
    private String _targetHost;
    private boolean _isAbsolute;

    protected ForwardRule(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
    }

    @Override
    public String getTagName() {
        return "forward";
    }

    public void setAbsoluteTarget(String target) {
        this._target = target;
        this._isAbsolute = true;
    }

    public void setTarget(String target) {
        this._target = target;
    }

    public void setTargetHost(String target) {
        this._targetHost = target;
    }

    @Override
    public String rewrite(String uri, Matcher matcher) {
        return matcher.replaceAll(this._target);
    }

    @Override
    public FilterChain dispatch(String uri, String queryString, FilterChain accept, FilterChainMapper next) {
        String uriArg = null;
        uriArg = uri;
        if (this._isAbsolute) {
            return new ForwardAbsoluteFilterChain(uriArg, WebApp.getCurrent());
        }
        if (this.getRewriteDispatch().getWebApp() == null) {
            return new ForwardFilterChain(uriArg, true);
        }
        return new ForwardFilterChain(uriArg);
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        super.init();
        this.required(this._target, "target");
        if (this.getRegexp() == null && this.getFullUrlRegexp() == null) {
            this.setRegexp(ALL_PATTERN);
        }
    }
}

