/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.rewrite.Condition;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ConditionFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(ConditionFilterChain.class.getName());
    private final String _logPrefix;
    private final String _uri;
    private final String _targetUri;
    private final FilterChain _failChain;
    private final Condition[] _conditions;
    private final FilterChain _passChain;
    private final boolean _isFiner;
    private final boolean _isFinest;

    public ConditionFilterChain(String logPrefix, String uri, String targetUri, Condition[] conditions, FilterChain passChain, FilterChain failChain) {
        assert (conditions != null);
        assert (passChain != null);
        assert (failChain != null);
        this._logPrefix = logPrefix;
        this._uri = uri;
        this._targetUri = targetUri;
        this._conditions = conditions;
        this._passChain = passChain;
        this._failChain = failChain;
        this._isFiner = log.isLoggable(Level.FINER);
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (res instanceof HttpServletResponseImpl) {
            HttpServletResponseImpl cRes = (HttpServletResponseImpl)res;
            cRes.setNoCacheUnlessVary(true);
        }
        for (int i = 0; i < this._conditions.length; ++i) {
            if (this._conditions[i].isMatch(req, res)) continue;
            if (this._isFiner) {
                log.finer(this._logPrefix + " '" + this._uri + "' --> '" + this._targetUri + "'");
            }
            this._failChain.doFilter(request, response);
            return;
        }
        if (this._isFiner) {
            log.finer(this._logPrefix + " '" + this._uri + "' --> '" + this._targetUri + "'");
        }
        this._passChain.doFilter(request, response);
    }
}

