/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.ConfigException;
import com.caucho.config.types.CronType;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.RewriteRuleMXBean;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.rewrite.Rule;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public abstract class AbstractRule
implements Rule {
    private static final L10N L = new L10N(AbstractRule.class);
    private static final Logger log = Logger.getLogger(AbstractRule.class.getName());
    private final RewriteDispatch _rewriteDispatch;
    private String _name;
    private volatile boolean _isEnabled = true;
    private CronType _enableAt;
    private CronType _disableAt;
    private String _logPrefix = this.getTagName();
    private FilterChainMapper _passFilterChainMapper;
    private FilterChainMapper _failFilterChainMapper;
    private RewriteRuleAdmin _admin;
    private EnableAlarmListener _enableAlarmListener;
    private EnableAlarmListener _disableAlarmListener;

    public AbstractRule(RewriteDispatch rewriteDispatch) {
        this._rewriteDispatch = rewriteDispatch;
    }

    protected RewriteDispatch getRewriteDispatch() {
        return this._rewriteDispatch;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setEnabled(boolean isEnabled) {
        if (this._isEnabled != isEnabled) {
            this._isEnabled = isEnabled;
            this._rewriteDispatch.clearCache();
        }
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setDisableAt(CronType disableAt) {
        this._disableAt = disableAt;
    }

    public void setEnableAt(CronType enableAt) {
        this._enableAt = enableAt;
    }

    @Override
    public void setPassFilterChainMapper(FilterChainMapper passFilterChainMapper) {
        this._passFilterChainMapper = passFilterChainMapper;
    }

    protected final FilterChainMapper getPassFilterChainMapper() {
        return this._passFilterChainMapper;
    }

    @Override
    public void setFailFilterChainMapper(FilterChainMapper failFilterChainMapper) {
        this._failFilterChainMapper = failFilterChainMapper;
    }

    protected final FilterChainMapper getFailFilterChainMapper() {
        return this._failFilterChainMapper;
    }

    public void setLogPrefix(String logPrefix) {
        this._logPrefix = logPrefix;
    }

    public String getLogPrefix() {
        return this._logPrefix;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._name == null && !this._isEnabled && this._enableAt == null) {
            throw new ConfigException(L.l("{0} requires 'name' if enabled='false' and enable-at is undefined", (Object)this.getTagName()));
        }
        if (this._enableAt != null) {
            this._enableAlarmListener = new EnableAlarmListener(this, this._enableAt, true);
        }
        if (this._disableAt != null) {
            this._disableAlarmListener = new EnableAlarmListener(this, this._disableAt, false);
        }
    }

    @Override
    public void register() {
        if (this._admin == null && this._name != null) {
            this._admin = this.createAdmin();
            this._admin.register();
        }
    }

    @Override
    public void unregister() {
        RewriteRuleAdmin admin = this._admin;
        this._admin = null;
        if (admin != null) {
            admin.unregister();
        }
    }

    protected RewriteRuleAdmin createAdmin() {
        return new RewriteRuleAdmin(this);
    }

    protected void clearCache() {
        this._rewriteDispatch.clearCache();
    }

    @Override
    @PreDestroy
    public void destroy() {
        try {
            this.unregister();
        }
        finally {
            EnableAlarmListener enableAlarmListener = this._enableAlarmListener;
            this._enableAlarmListener = null;
            EnableAlarmListener disableAlarmListener = this._disableAlarmListener;
            this._disableAlarmListener = null;
            if (enableAlarmListener != null) {
                enableAlarmListener.destroy();
            }
            if (disableAlarmListener != null) {
                disableAlarmListener.destroy();
            }
        }
    }

    private static class EnableAlarmListener
    implements AlarmListener {
        private final AbstractRule _rule;
        private final CronType _cron;
        private final boolean _isEnable;
        private volatile Alarm _alarm;

        public EnableAlarmListener(AbstractRule rule, CronType cron, boolean isEnable) {
            this._rule = rule;
            this._cron = cron;
            this._isEnable = isEnable;
            String type = isEnable ? "enable" : "disable";
            this._alarm = new Alarm("rewrite-rule-" + type, (AlarmListener)this);
            this.queue();
        }

        private void queue() {
            long now = CurrentTime.getCurrentTime();
            long nextTime = this._cron.nextTime(now);
            Alarm alarm = this._alarm;
            if (alarm == null) {
                return;
            }
            this._rule.setEnabled(this._isEnable);
            alarm.queue(nextTime - now);
        }

        public void handleAlarm(Alarm alarm) {
            alarm = this._alarm;
            if (alarm == null) {
                return;
            }
            this._rule.setEnabled(this._isEnable);
            this.queue();
        }

        public void destroy() {
            Alarm alarm = this._alarm;
            this._alarm = null;
            if (alarm != null) {
                alarm.dequeue();
            }
        }
    }

    public static class RewriteRuleAdmin
    extends AbstractManagedObject
    implements RewriteRuleMXBean {
        private final AbstractRule _rule;

        public RewriteRuleAdmin(AbstractRule rule) {
            this._rule = rule;
        }

        public String getName() {
            return this._rule.getName();
        }

        public String getType() {
            return "RewriteRule";
        }

        @Override
        public String getState() {
            if (this._rule.isEnabled()) {
                return "active";
            }
            return "stopped";
        }

        @Override
        public void start() {
            this._rule.setEnabled(true);
        }

        @Override
        public void stop() {
            this._rule.setEnabled(false);
        }

        public void register() {
            this.registerSelf();
        }

        public void unregister() {
            this.unregisterSelf();
        }
    }
}

