/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.log;

import com.caucho.config.types.Bytes;
import com.caucho.env.actor.AbstractWorkerQueue;
import com.caucho.log.AbstractRolloverLog;
import com.caucho.server.httpcache.TempFileService;
import com.caucho.server.log.AccessLog;
import com.caucho.server.log.LogBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeRing;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempStreamApi;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AccessLogWriter
extends AbstractRolloverLog {
    protected static final L10N L = new L10N(AccessLogWriter.class);
    protected static final Logger log = Logger.getLogger(AccessLogWriter.class.getName());
    private final AccessLog _log;
    private boolean _isAutoFlush;
    private final Object _bufferLock = new Object();
    private int _logBufferSize = 1024;
    private final FreeRing<LogBuffer> _freeList = new FreeRing(512);
    private final LogWriterTask _logWriterTask = new LogWriterTask();
    private TempFileService _tempService;

    AccessLogWriter(AccessLog log) {
        this._log = log;
        this._tempService = TempFileService.getCurrent();
        if (this._tempService == null) {
            throw new IllegalStateException(L.l("'{0}' is required for AccessLog", (Object)TempFileService.class.getSimpleName()));
        }
    }

    void setBufferSize(Bytes bytes) {
        this._logBufferSize = (int)bytes.getBytes();
    }

    int getBufferSize() {
        return this._logBufferSize;
    }

    public void init() throws IOException {
        super.init();
        this._isAutoFlush = this._log.isAutoFlush();
        for (int i = 0; i < 64; ++i) {
            this._freeList.free((Object)new LogBuffer(this._logBufferSize));
        }
    }

    boolean isBufferAvailable() {
        return this._freeList.getSize() >= 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeThrough(byte[] buffer, int offset, int length) throws IOException {
        Object object = this._bufferLock;
        synchronized (object) {
            this.write(buffer, offset, length);
        }
        this.flushStream();
    }

    void writeBuffer(LogBuffer buffer) {
        this._logWriterTask.offer(buffer);
        this._logWriterTask.wake();
    }

    protected void flush() {
        this._logWriterTask.wake();
        this.waitForFlush(10L);
        try {
            super.flush();
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    protected void wake() {
        this._logWriterTask.wake();
    }

    protected void waitForFlush(long timeout) {
        long expire = CurrentTime.getCurrentTimeActual() + timeout;
        while (!this._logWriterTask.isEmpty()) {
            long delta = expire - CurrentTime.getCurrentTimeActual();
            if (delta < 0L) {
                return;
            }
            if (delta > 50L) {
                delta = 50L;
            }
            try {
                this._logWriterTask.wake();
                Thread.sleep(delta);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    LogBuffer allocateBuffer() {
        LogBuffer buffer = (LogBuffer)this._freeList.allocate();
        if (buffer == null) {
            buffer = new LogBuffer(this._logBufferSize);
        }
        return buffer;
    }

    void freeBuffer(LogBuffer logBuffer) {
        logBuffer.clear();
        if (!logBuffer.isPrivate()) {
            this._freeList.free((Object)logBuffer);
        }
    }

    protected TempStreamApi createTempStream() {
        return this._tempService.getManager().createTempStream();
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            super.close();
        }
    }

    public void destroy() throws IOException {
        this._logWriterTask.close();
    }

    class LogWriterTask
    extends AbstractWorkerQueue<LogBuffer> {
        private final String _threadName;

        LogWriterTask() {
            super(16384);
            this._threadName = this.toString();
        }

        public String getThreadName() {
            return this._threadName;
        }

        public void process(LogBuffer value) {
            if (value == null) {
                return;
            }
            try {
                AccessLogWriter.this.write(value.getBuffer(), 0, value.getLength());
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                AccessLogWriter.this.freeBuffer(value);
            }
        }

        public void onProcessComplete() {
            try {
                AccessLogWriter.this.flushStream();
            }
            catch (IOException e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }

        public void close() {
            this.wake();
        }

        public String toString() {
            Path path = AccessLogWriter.this.getPath();
            if (path != null) {
                return ((Object)((Object)this)).getClass().getSimpleName() + "[" + path.getTail() + "]";
            }
            return ((Object)((Object)this)).getClass().getSimpleName() + "[" + path + "]";
        }
    }
}

