/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.env.meter.ActiveTimeMeter;
import com.caucho.env.meter.AverageMeter;
import com.caucho.env.meter.MeterService;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.network.listen.SocketLinkDuplexController;
import com.caucho.network.listen.SocketLinkDuplexListener;
import com.caucho.network.listen.TcpSocketLink;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.ChunkedInputStream;
import com.caucho.server.http.ContentLengthStream;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.http.HttpResponse;
import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.http.HttpServletResponseImpl;
import com.caucho.server.http.RawInputStream;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.L10N;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.SocketTimeoutException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class HttpRequest
extends AbstractHttpRequest
implements ProtocolConnection {
    private static final L10N L;
    private static final Logger log;
    public static final int HTTP_0_9 = 9;
    public static final int HTTP_1_0 = 256;
    public static final int HTTP_1_1 = 257;
    private static final CharBuffer _getCb;
    private static final CharBuffer _headCb;
    private static final CharBuffer _postCb;
    private static final char[] _toLowerAscii;
    private static final char[] _toUpperAscii;
    private static final boolean[] _isHttpWhitespace;
    private static final String REQUEST_TIME_PROBE = "Resin|Http|Request";
    private static final String REQUEST_READ_BYTES_PROBE = "Resin|Http|Request Read Bytes";
    private static final String REQUEST_WRITE_BYTES_PROBE = "Resin|Http|Request Write Bytes";
    private final CharBuffer _method = new CharBuffer();
    private String _methodString;
    private final CharBuffer _uriHost = new CharBuffer();
    private CharSequence _host;
    private byte[] _uri;
    private int _uriLength;
    private final CharBuffer _protocol = new CharBuffer();
    private int _version;
    private char[] _headerBuffer;
    private int _headerLength;
    private CharSegment[] _headerKeys;
    private CharSegment[] _headerValues;
    private int _headerSize;
    private ChunkedInputStream _chunkedInputStream = new ChunkedInputStream();
    private ContentLengthStream _contentLengthStream = new ContentLengthStream();
    private RawInputStream _rawInputStream = new RawInputStream();
    private ActiveTimeMeter _requestTimeProbe = MeterService.createActiveTimeMeter((String)"Resin|Http|Request");
    private AverageMeter _requestReadBytesProbe = MeterService.createAverageMeter((String)"Resin|Http|Request Read Bytes", (String)"");
    private AverageMeter _requestWriteBytesProbe = MeterService.createAverageMeter((String)"Resin|Http|Request Write Bytes", (String)"");

    public HttpRequest(ServletService server, SocketLink conn) {
        super(server, conn);
    }

    @Override
    public HttpResponse createResponse() {
        return new HttpResponse(this, this.getConnection().getWriteStream());
    }

    @Override
    public final boolean isWaitForRead() {
        return true;
    }

    @Override
    public boolean hasRequest() {
        return this.getRequestFacade() != null;
    }

    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            switch (cb.charAt(0)) {
                case 'G': {
                    this._methodString = cb.equals((CharSegment)_getCb) ? "GET" : cb.toString();
                    break;
                }
                case 'H': {
                    this._methodString = cb.equals((CharSegment)_headCb) ? "HEAD" : cb.toString();
                    break;
                }
                case 'P': {
                    this._methodString = cb.equals((CharSegment)_postCb) ? "POST" : cb.toString();
                    break;
                }
                default: {
                    this._methodString = cb.toString();
                }
            }
        }
        return this._methodString;
    }

    @Override
    protected CharSequence getHost() {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this.getConnection().getVirtualHost();
        if (virtualHost != null) {
            this._host = virtualHost;
        } else if (this._uriHost.length() > 0) {
            this._host = this._uriHost;
        } else {
            this._host = this.getForwardedHostHeader();
            if (this._host == null) {
                this._host = this.getHostHeader();
            }
        }
        return this._host;
    }

    private CharSequence getInvocationHost() throws IOException {
        if (this._host != null) {
            return this._host;
        }
        String virtualHost = this.getConnection().getVirtualHost();
        if (virtualHost != null) {
            return virtualHost;
        }
        if (this._host == null) {
            if (this._uriHost.length() > 0) {
                this._host = this._uriHost;
            } else {
                this._host = this.getForwardedHostHeader();
                if (this._host == null && (this._host = this.getHostHeader()) == null && 257 <= this.getVersion()) {
                    throw new BadRequestException("HTTP/1.1 requires a Host header (Remote IP=" + this.getRemoteHost() + ")");
                }
            }
        }
        return this._host;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri;
    }

    @Override
    public int getUriLength() {
        return this._uriLength;
    }

    @Override
    public String getProtocol() {
        switch (this._version) {
            case 257: {
                return "HTTP/1.1";
            }
            case 256: {
                return "HTTP/1.0";
            }
        }
        return "HTTP/0.9";
    }

    public CharSegment getProtocolBuffer() {
        return this._protocol;
    }

    int getVersion() {
        char ch;
        if (this._version > 0) {
            return this._version;
        }
        CharSegment protocol = this.getProtocolBuffer();
        if (protocol.equals((Object)"HTTP/1.1")) {
            this._version = 257;
            return 257;
        }
        if (protocol.equals((Object)"HTTP/1.0")) {
            this._version = 256;
            return this._version;
        }
        if (protocol.equals((Object)"HTTP/0.9")) {
            this._version = 9;
            return 9;
        }
        if (protocol.length() < 8) {
            this._version = 9;
            return this._version;
        }
        int i = protocol.indexOf('/');
        int len = protocol.length();
        int major = 0;
        ++i;
        while (i < len) {
            char ch2 = protocol.charAt(i);
            if ('0' > ch2 || ch2 > '9') {
                if (ch2 == '.') break;
                this._version = 256;
                return this._version;
            }
            major = 10 * major + ch2 - 48;
            ++i;
        }
        int minor = 0;
        ++i;
        while (i < len && '0' <= (ch = protocol.charAt(i)) && ch <= '9') {
            minor = 10 * minor + ch - 48;
            ++i;
        }
        this._version = 256 * major + minor;
        return this._version;
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    @Override
    public int getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public CharSegment getHeaderKey(int index) {
        return this._headerKeys[index];
    }

    @Override
    public CharSegment getHeaderValue(int index) {
        return this._headerValues[index];
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this._headerBuffer;
        CharSegment[] headerKeys = this._headerKeys;
        char[] toLowerAscii = _toLowerAscii;
        for (int i = this._headerSize - 1; i >= 0; --i) {
            char b;
            char a;
            int j;
            CharSegment key = headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0 && ((a = testBuf[j]) == (b = keyBuf[offset + j]) || toLowerAscii[a] == toLowerAscii[b]); --j) {
            }
            if (j >= 0) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i]);
        }
    }

    @Override
    public Enumeration<String> getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this._headerSize;
        int length = key.length();
        char[] keyBuf = this._headerBuffer;
        char[] toLowerAscii = _toLowerAscii;
        while (i < size) {
            CharSegment header = this._headerKeys[i];
            if (header.length() == length) {
                char b;
                char a;
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length && ((a = key.charAt(j)) == (b = keyBuf[offset + j]) || toLowerAscii[a] == toLowerAscii[b]); ++j) {
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this._headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public void setHeader(String key, String value) {
        int i;
        int tail = this._headerSize > 0 ? this._headerValues[this._headerSize - 1].getOffset() + this._headerValues[this._headerSize - 1].getLength() : 0;
        int keyLength = key.length();
        int valueLength = value.length();
        char[] headerBuffer = this._headerBuffer;
        for (i = keyLength - 1; i >= 0; --i) {
            headerBuffer[tail + i] = key.charAt(i);
        }
        this._headerKeys[this._headerSize].init(headerBuffer, tail, keyLength);
        tail += keyLength;
        for (i = valueLength - 1; i >= 0; --i) {
            headerBuffer[tail + i] = value.charAt(i);
        }
        this._headerValues[this._headerSize].init(headerBuffer, tail, valueLength);
        ++this._headerSize;
    }

    @Override
    protected void initAttributes(HttpServletRequestImpl request) {
        SocketLink conn = this.getConnection();
        if (!(conn instanceof TcpSocketLink)) {
            return;
        }
        TcpSocketLink tcpConn = (TcpSocketLink)conn;
        if (!conn.isSecure()) {
            return;
        }
        QSocket socket = tcpConn.getSocket();
        String cipherSuite = socket.getCipherSuite();
        request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
        int keySize = socket.getCipherBits();
        if (keySize != 0) {
            request.setAttribute("javax.servlet.request.key_size", new Integer(keySize));
        }
        try {
            X509Certificate[] certs = socket.getClientCertificates();
            if (certs != null && certs.length > 0) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    @Override
    public String findSessionIdFromConnection() {
        SocketLink link = this.getConnection();
        TcpSocketLink tcpConn = null;
        if (link instanceof TcpSocketLink) {
            tcpConn = (TcpSocketLink)this.getConnection();
        }
        if (tcpConn == null || !tcpConn.isSecure()) {
            return null;
        }
        return null;
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawRead) throws IOException {
        rawRead.setSibling(null);
        if (this.getConnection().isDuplex()) {
            this._rawInputStream.init(rawRead);
            readStream.init((StreamImpl)this._rawInputStream, null);
            return true;
        }
        long contentLength = this.getLongContentLength();
        if (contentLength < 0L && 257 <= this.getVersion() && this.getHeader("Transfer-Encoding") != null) {
            this._chunkedInputStream.init(rawRead);
            readStream.init((StreamImpl)this._chunkedInputStream, null);
            return true;
        }
        if (contentLength >= 0L) {
            this._contentLengthStream.init(rawRead, contentLength);
            readStream.init((StreamImpl)this._contentLengthStream, null);
            return true;
        }
        if (this.getMethod().equals("POST")) {
            this._contentLengthStream.init(rawRead, 0L);
            readStream.init((StreamImpl)this._contentLengthStream, null);
            throw new BadRequestException("POST requires content-length");
        }
        this._contentLengthStream.init(rawRead, 0L);
        readStream.init((StreamImpl)this._contentLengthStream, null);
        return false;
    }

    @Override
    protected void skip() throws IOException {
        if (this.getMethod() == "GET") {
            return;
        }
        super.skip();
    }

    @Override
    public ReadStream getRawInput() {
        return this.getRawRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest() throws IOException {
        boolean isInvocation = false;
        ServletService server = this.getServer();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        long startTime = 0L;
        long startReadBytes = this.getRawRead().getPosition();
        long startWriteBytes = this.getRawWrite().getPosition();
        try {
            thread.setContextClassLoader((ClassLoader)server.getClassLoader());
            this.startRequest();
            if (!this.parseRequest()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this.dbgId() + " empty request");
                }
                boolean bl = false;
                return bl;
            }
            CharSequence host = this.getInvocationHost();
            Invocation invocation = this.getInvocation(host, this._uri, this._uriLength);
            if (invocation == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer(this.dbgId() + " empty invocation");
                }
                boolean bl = false;
                return bl;
            }
            HttpServletRequestImpl requestFacade = this.getRequestFacade();
            requestFacade.setInvocation(invocation);
            isInvocation = true;
            startTime = this._requestTimeProbe.start();
            this.startInvocation();
            invocation.service((ServletRequest)requestFacade, (ServletResponse)this.getResponseFacade());
        }
        catch (ClientDisconnectException e) {
            this.clientDisconnect();
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            HttpServletResponseImpl response = this.getResponseFacade();
            if (response != null) {
                response.killCache();
            }
            this.killKeepalive("http handleRequest exception: " + e);
            this.sendRequestError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (isInvocation) {
                this.finishInvocation();
            }
            if (!this.isSuspend()) {
                this.finishRequest();
            }
            if (startTime > 0L) {
                this._requestTimeProbe.end(startTime);
                long endReadBytes = this.getRawRead().getPosition();
                long endWriteBytes = this.getRawWrite().getPosition();
                this._requestReadBytesProbe.add(endReadBytes - startReadBytes);
                this._requestWriteBytesProbe.add(endWriteBytes - startWriteBytes);
            }
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    private boolean parseRequest() throws IOException {
        try {
            ReadStream is = this.getRawRead();
            if (!this.readRequest(is)) {
                this.clearRequest();
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.dbgId() + this._method + " " + new String(this._uri, 0, this._uriLength) + " " + this._protocol);
                log.fine(this.dbgId() + "Remote-IP: " + this.getRemoteHost() + ":" + this.getRemotePort());
            }
            this.parseHeaders(is);
            return true;
        }
        catch (ClientDisconnectException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.log(Level.FINEST, e.toString(), e);
            throw new BadRequestException(L.l("Invalid request: URL or headers are too long"), e);
        }
        catch (Throwable e) {
            log.log(Level.FINEST, e.toString(), e);
            throw new BadRequestException(String.valueOf(e), e);
        }
    }

    @Override
    protected void startRequest() throws IOException {
        super.startRequest();
        HttpBufferStore bufferStore = this.getHttpBufferStore();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._uriLength = 0;
        if (bufferStore != null) {
            this._uri = bufferStore.getUriBuffer();
            this._headerBuffer = bufferStore.getHeaderBuffer();
            this._headerKeys = bufferStore.getHeaderKeys();
            this._headerValues = bufferStore.getHeaderValues();
        } else {
            this._uri = this.getSmallUriBuffer();
            this._headerBuffer = this.getSmallHeaderBuffer();
            this._headerKeys = this.getSmallHeaderKeys();
            this._headerValues = this.getSmallHeaderValues();
        }
        this._uriHost.clear();
        this._host = null;
        this._headerSize = 0;
        this._headerLength = 0;
    }

    private boolean readRequest(ReadStream s) throws IOException {
        int readTail;
        int ch;
        this._version = 256;
        boolean[] isHttpWhitespace = _isHttpWhitespace;
        char[] toUpperAscii = _toUpperAscii;
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        do {
            if (readLength > readOffset) continue;
            readLength = s.fillBuffer();
            if (readLength < 0) {
                return false;
            }
            readOffset = 0;
        } while (isHttpWhitespace[ch = readBuffer[readOffset++] & 0xFF]);
        char[] buffer = this._method.getBuffer();
        int length = buffer.length;
        int offset = 0;
        while (true) {
            if (length > offset) {
                if (ch <= 32) break;
                buffer[offset++] = toUpperAscii[ch];
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        this._method.setLength(offset);
        while (ch == 32 || ch == 9) {
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return false;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        byte[] uriBuffer = this._uri;
        int uriLength = 0;
        if (ch != 47) {
            int ch1;
            while (ch > 32 && ch != 47) {
                if (readLength <= readOffset) {
                    readLength = s.fillBuffer();
                    if (readLength < 0) {
                        return false;
                    }
                    readOffset = 0;
                }
                ch = readBuffer[readOffset++];
            }
            if (ch != 47) {
                log.warning("Invalid Request (method='" + this._method + "' url ch=0x" + Integer.toHexString(ch & 0xFF) + ") (IP=" + this.getRemoteHost() + ")");
                throw new BadRequestException("Invalid Request(Remote IP=" + this.getRemoteHost() + ")");
            }
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    if (ch == 47) {
                        uriBuffer[uriLength++] = (byte)ch;
                        this._uriLength = uriLength;
                    }
                    this._version = 0;
                    return true;
                }
                readOffset = 0;
            }
            if ((ch1 = readBuffer[readOffset++] & 0xFF) != 47) {
                uriBuffer[uriLength++] = (byte)ch;
                ch = ch1;
            } else {
                block9: while (true) {
                    if (readLength <= readOffset) {
                        readLength = s.fillBuffer();
                        if (readLength < 0) {
                            this._version = 0;
                            return true;
                        }
                        readOffset = 0;
                    }
                    ch = readBuffer[readOffset++] & 0xFF;
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            break block9;
                        }
                        case 63: {
                            break block9;
                        }
                        case 47: {
                            break block9;
                        }
                        default: {
                            this._uriHost.append((char)ch);
                            continue block9;
                        }
                    }
                    break;
                }
            }
        }
        if (readLength < (readTail = uriBuffer.length - uriLength - 1)) {
            readTail = readLength;
        }
        while (!isHttpWhitespace[ch]) {
            uriBuffer[uriLength++] = (byte)ch;
            if (readTail <= readOffset) {
                readTail = this.fillUrlTail(s, readOffset, uriLength);
                if (readTail <= 0) {
                    this._uriLength = uriLength;
                    this._version = 0;
                    return true;
                }
                readOffset = s.getOffset();
                uriBuffer = this._uri;
                uriLength = this._uriLength;
            }
            ch = readBuffer[readOffset++] & 0xFF;
        }
        this._uriLength = uriLength;
        this._version = 0;
        while (ch == 32 || ch == 9) {
            if (readLength <= readOffset) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
            }
            ch = readBuffer[readOffset++] & 0xFF;
        }
        buffer = this._protocol.getBuffer();
        length = buffer.length;
        offset = 0;
        while (!isHttpWhitespace[ch]) {
            if (offset < length) {
                buffer[offset++] = toUpperAscii[ch];
            }
            if (readLength <= readOffset) {
                readOffset = 0;
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    this._protocol.setLength(offset);
                    return true;
                }
            }
            ch = readBuffer[readOffset++] & 0xFF;
        }
        this._protocol.setLength(offset);
        if (offset != 8) {
            this._protocol.append("HTTP/0.9");
            this._version = 9;
        } else {
            this._version = buffer[7] == '1' ? 257 : (buffer[7] == '0' ? 256 : 9);
        }
        while (ch != 10) {
            if (readLength <= readOffset) {
                readLength = s.fillBuffer();
                if (readLength < 0) {
                    return true;
                }
                readOffset = 0;
            }
            ch = readBuffer[readOffset++];
        }
        s.setOffset(readOffset);
        return true;
    }

    private void parseHeaders(ReadStream s) throws IOException {
        int version = this.getVersion();
        if (version < 256) {
            return;
        }
        if (version < 257) {
            this.killKeepalive("http client version less than 1.1: " + version);
        }
        byte[] readBuffer = s.getBuffer();
        int readOffset = s.getOffset();
        int readLength = s.getLength();
        char[] headerBuffer = this._headerBuffer;
        headerBuffer[0] = 122;
        int headerOffset = 1;
        this._headerSize = 0;
        int readTail = readLength;
        if (headerBuffer.length - 1 < readTail - readOffset) {
            readTail = headerBuffer.length - 1;
        }
        boolean isLogFine = log.isLoggable(Level.FINE);
        while (true) {
            int ch;
            int keyOffset = headerOffset;
            while (true) {
                if (readTail <= readOffset) {
                    readTail = this.fillHeaderTail(s, readOffset, headerOffset);
                    if (readTail <= 0) {
                        return;
                    }
                    readOffset = s.getOffset();
                    headerOffset = this._headerLength;
                    headerBuffer = this._headerBuffer;
                }
                if ((ch = readBuffer[readOffset++]) == 10) {
                    s.setOffset(readOffset);
                    return;
                }
                if (ch == 58) break;
                headerBuffer[headerOffset++] = (char)ch;
            }
            while (headerBuffer[headerOffset - 1] == ' ') {
                --headerOffset;
            }
            int keyLength = headerOffset - keyOffset;
            do {
                if (readTail > readOffset) continue;
                readTail = this.fillHeaderTail(s, readOffset, headerOffset);
                if (readTail <= 0) {
                    return;
                }
                readOffset = s.getOffset();
                headerOffset = this._headerLength;
                headerBuffer = this._headerBuffer;
            } while ((ch = readBuffer[readOffset++]) == 32 || ch == 9);
            int valueOffset = headerOffset;
            while (true) {
                if (readTail <= readOffset) {
                    readTail = this.fillHeaderTail(s, readOffset, headerOffset);
                    if (readTail <= 0) break;
                    readOffset = s.getOffset();
                    headerOffset = this._headerLength;
                    headerBuffer = this._headerBuffer;
                }
                if (ch == 10) {
                    byte ch1 = readBuffer[readOffset];
                    if (ch1 != 32 && ch1 != 9) break;
                    ch = 32;
                    ++readOffset;
                    if (headerBuffer[headerOffset - 1] == '\r') {
                        // empty if block
                    }
                }
                int n = --headerOffset;
                ++headerOffset;
                headerBuffer[n] = (char)ch;
                ch = readBuffer[readOffset++];
            }
            while (headerBuffer[headerOffset - 1] <= ' ') {
                --headerOffset;
            }
            int headerSize = this._headerSize;
            CharSegment[] headerKeys = this._headerKeys;
            CharSegment[] headerValues = this._headerValues;
            if (headerKeys.length <= headerSize) {
                this._headerLength = headerOffset;
                this.extendHeaderBuffers();
                headerBuffer = this._headerBuffer;
                headerKeys = this._headerKeys;
                headerValues = this._headerValues;
            }
            headerKeys[headerSize].init(headerBuffer, keyOffset, keyLength);
            int valueLength = headerOffset - valueOffset;
            headerValues[headerSize].init(headerBuffer, valueOffset, valueLength);
            if (isLogFine) {
                log.fine(this.dbgId() + headerKeys[headerSize] + ": " + headerValues[headerSize]);
            }
            if (this.addHeaderInt(headerBuffer, keyOffset, keyLength, headerValues[headerSize])) {
                // empty if block
            }
            this._headerSize = ++headerSize;
        }
    }

    private int fillUrlTail(ReadStream s, int readOffset, int uriOffset) throws IOException {
        int tail;
        this._uriLength = uriOffset;
        if (this._uri.length <= uriOffset) {
            this.extendHeaderBuffers();
        }
        if (s.getLength() <= readOffset) {
            if (s.fillBuffer() < 0) {
                return -1;
            }
        } else {
            s.setOffset(readOffset);
        }
        if (this._uri.length - uriOffset < (tail = s.getLength() - s.getOffset())) {
            tail = this._uri.length - uriOffset;
        }
        return tail;
    }

    private int fillHeaderTail(ReadStream s, int readOffset, int headerOffset) throws IOException {
        int tail;
        this._headerLength = headerOffset;
        if (this._headerBuffer.length <= headerOffset) {
            this.extendHeaderBuffers();
        }
        if (s.getLength() <= readOffset) {
            if (s.fillBuffer() < 0) {
                return -1;
            }
        } else {
            s.setOffset(readOffset);
        }
        if (this._headerBuffer.length - headerOffset < (tail = s.getLength() - s.getOffset())) {
            tail = this._headerBuffer.length - headerOffset;
        }
        return tail;
    }

    protected void extendHeaderBuffers() throws IOException {
        HttpBufferStore bufferStore = this.getHttpBufferStore();
        if (bufferStore != null) {
            throw new BadRequestException(L.l("URL or HTTP headers are too long (IP={0})", (Object)this.getRemoteAddr()));
        }
        bufferStore = this.allocateHttpBufferStore();
        byte[] uri = bufferStore.getUriBuffer();
        System.arraycopy(this._uri, 0, uri, 0, this._uriLength);
        char[] headerBuffer = bufferStore.getHeaderBuffer();
        CharSegment[] headerKeys = bufferStore.getHeaderKeys();
        CharSegment[] headerValues = bufferStore.getHeaderValues();
        if (headerBuffer == this._headerBuffer || this._uri == uri) {
            throw new IllegalStateException();
        }
        System.arraycopy(this._headerBuffer, 0, headerBuffer, 0, this._headerLength);
        for (int i = 0; i < this._headerSize; ++i) {
            headerKeys[i].init(headerBuffer, this._headerKeys[i].getOffset(), this._headerKeys[i].getLength());
            headerValues[i].init(headerBuffer, this._headerValues[i].getOffset(), this._headerValues[i].getLength());
        }
        this._uri = uri;
        this._headerBuffer = headerBuffer;
        this._headerKeys = headerKeys;
        this._headerValues = headerValues;
    }

    @Override
    public void onCloseConnection() {
        super.onCloseConnection();
        this._uri = null;
        this._headerBuffer = null;
        this._headerKeys = null;
        this._headerValues = null;
    }

    @Override
    public SocketLinkDuplexController startDuplex(SocketLinkDuplexListener handler) {
        TcpSocketLink conn = (TcpSocketLink)this.getConnection();
        SocketLinkDuplexController context = conn.startDuplex(handler);
        this._rawInputStream.init(conn.getReadStream());
        this.getReadStream().setSource((StreamImpl)this._rawInputStream);
        return context;
    }

    @Override
    public void finishRequest() throws IOException {
        super.finishRequest();
        this.skip();
    }

    @Override
    protected String dbgId() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return "Http[" + connId + "] ";
        }
        return "Http[" + serverId + ", " + connId + "] ";
    }

    public String toString() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return "HttpRequest[" + connId + "]";
        }
        return "HttpRequest[" + serverId + ", " + connId + "]";
    }

    static {
        int i;
        L = new L10N(HttpRequest.class);
        log = Logger.getLogger(HttpRequest.class.getName());
        _getCb = new CharBuffer("GET");
        _headCb = new CharBuffer("HEAD");
        _postCb = new CharBuffer("POST");
        _toLowerAscii = new char[256];
        for (i = 0; i < 256; ++i) {
            HttpRequest._toLowerAscii[i] = 65 <= i && i <= 90 ? (char)(i + 97 - 65) : (char)i;
        }
        _toUpperAscii = new char[256];
        for (i = 0; i < 256; ++i) {
            HttpRequest._toUpperAscii[i] = 97 <= i && i <= 122 ? (char)(i + 65 - 97) : (char)i;
        }
        _isHttpWhitespace = new boolean[256];
        HttpRequest._isHttpWhitespace[32] = true;
        HttpRequest._isHttpWhitespace[9] = true;
        HttpRequest._isHttpWhitespace[13] = true;
        HttpRequest._isHttpWhitespace[10] = true;
    }
}

