/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.xml.XmlChar;

class ContentType {
    private final String _userContentType;
    private String _contentType;
    private String _encoding;

    ContentType(String userContentType) {
        this._userContentType = userContentType;
        this.parseContentType(userContentType);
    }

    public String getUserContentType() {
        return this._userContentType;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getEncoding() {
        return this._encoding;
    }

    private void parseContentType(String value) {
        int length = value.length();
        int i = 0;
        while (i < length) {
            int encodingIndex;
            char ch;
            while (i < length && value.charAt(i) != ';') {
                ++i;
            }
            if (length <= i) break;
            int semicolon = i++;
            while (i < length && XmlChar.isWhitespace((int)value.charAt(i))) {
                ++i;
            }
            int keyIndex = i;
            while (i < length && !XmlChar.isWhitespace((int)(ch = value.charAt(i))) && ch != '=') {
                ++i;
            }
            if (length <= i) break;
            ch = value.charAt(keyIndex);
            if (ch != 'c' && ch != 'C') {
                ++i;
                continue;
            }
            if (!value.regionMatches(true, keyIndex, "charset", 0, i - keyIndex)) {
                ++i;
                continue;
            }
            while (i < length && XmlChar.isWhitespace((int)value.charAt(i))) {
                ++i;
            }
            if (length <= i || value.charAt(i) != '=') continue;
            ++i;
            while (i < length && XmlChar.isWhitespace((int)value.charAt(i))) {
                ++i;
            }
            if (i < length && value.charAt(i) == '\"') {
                encodingIndex = ++i;
                while (i < length && value.charAt(i) != '\"') {
                    ++i;
                }
                this._encoding = value.substring(encodingIndex, i).intern();
            } else {
                encodingIndex = i;
                while (i < length && !XmlChar.isWhitespace((int)(ch = value.charAt(i))) && ch != ';') {
                    ++i;
                }
                this._encoding = value.substring(encodingIndex, i).intern();
            }
            while (i < length && value.charAt(i) != ';') {
                ++i;
            }
            if (i < length) {
                StringBuilder sb = new StringBuilder();
                sb.append(value, 0, semicolon);
                sb.append(value, i, value.length());
                this._contentType = sb.toString().intern();
            } else {
                this._contentType = value.substring(0, semicolon).intern();
            }
            return;
        }
        this._contentType = value.intern();
    }
}

