/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.hmux.HmuxExtension;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class HmuxManager {
    private static EnvironmentLocal<HmuxManager> _localManager = new EnvironmentLocal();
    private ClassLoader _classLoader;
    private HashMap<Integer, WeakReference<HmuxExtension>> _extensionMap = new HashMap();

    private HmuxManager() {
        this._classLoader = Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HmuxManager getLocal() {
        EnvironmentLocal<HmuxManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            HmuxManager manager = (HmuxManager)_localManager.get();
            if (manager == null) {
                manager = new HmuxManager();
                _localManager.set((Object)manager);
            }
            return manager;
        }
    }

    public HmuxExtension getExtension(Integer id) {
        WeakReference<HmuxExtension> ref = this._extensionMap.get(id);
        if (ref != null) {
            return (HmuxExtension)ref.get();
        }
        return null;
    }

    public void putExtension(Integer id, HmuxExtension extension) {
        this._extensionMap.put(id, new WeakReference<HmuxExtension>(extension));
    }
}

