/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.fastcgi;

import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.dispatch.BadRequestException;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.dispatch.InvocationDecoder;
import com.caucho.server.dispatch.InvocationServer;
import com.caucho.server.fastcgi.FastCgiResponse;
import com.caucho.server.http.AbstractHttpRequest;
import com.caucho.server.http.HttpBufferStore;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FastCgiRequest
extends AbstractHttpRequest
implements ProtocolConnection {
    private static final Logger log = Logger.getLogger(FastCgiRequest.class.getName());
    private static final int FCGI_HEADER_LEN = 8;
    private static final int FCGI_VERSION_1 = 1;
    private static final int FCGI_BEGIN_REQUEST = 1;
    private static final int FCGI_ABORT_REQUEST = 2;
    private static final int FCGI_END_REQUEST = 3;
    private static final int FCGI_PARAMS = 4;
    private static final int FCGI_STDIN = 5;
    private static final int FCGI_STDOUT = 6;
    private static final int FCGI_STDERR = 7;
    private static final int FCGI_DATA = 8;
    private static final int FCGI_GET_VALUES = 9;
    private static final int FCGI_GET_VALUES_RESULT = 10;
    private static final int FCGI_UNKNOWN_TYPE = 11;
    private static final int FCGI_MAXTYPE = 11;
    private static final int FCGI_NULL_REQUEST_ID = 0;
    private static final int FCGI_KEEP_CONN = 1;
    private static final int FCGI_RESPONDER = 1;
    private static final int FCGI_AUTHORIZER = 2;
    private static final int FCGI_FILTER = 3;
    private static final int FCGI_REQUEST_COMPLETE = 0;
    private static final int FCGI_CANT_MPX_CONN = 1;
    private static final int FCGI_OVERLOADED = 2;
    private static final int FCGI_UNKNOWN_ROLE = 3;
    private static final int HTTP_1_1 = 17;
    private static final int LEN_CONTENT_LENGTH = 14;
    private static final int HU_CONTENT_LENGTH = 3651;
    private static final int HL_CONTENT_LENGTH = 3683;
    private static final int LEN_CONTENT_TYPE = 12;
    private static final byte[] REQUEST_METHOD = "REQUEST_METHOD".getBytes();
    private static final int HU_REQUEST_METHOD = 3666;
    private static final int HL_REQUEST_METHOD = 3698;
    private static final byte[] REQUEST_URI = "REQUEST_URI".getBytes();
    private static final int HU_REQUEST_URI = 2898;
    private static final int HL_REQUEST_URI = 2930;
    private static final byte[] SERVER_PROTOCOL = "SERVER_PROTOCOL".getBytes();
    private static final int HU_SERVER_PROTOCOL = 3923;
    private static final int HL_SERVER_PROTOCOL = 3955;
    private static final int LEN_SCRIPT_NAME = 11;
    private CharBuffer _method;
    private String _methodString;
    private CharBuffer _uriHost;
    private CharSequence _host;
    private CharBuffer _hostBuffer = new CharBuffer();
    private CharBuffer _queryString = new CharBuffer();
    private byte[] _uri;
    private int _uriLength;
    private int _urlLengthMax = 8192;
    private byte[] _keyBuffer = new byte[256];
    private CharBuffer _protocol;
    private int _version;
    private final InvocationKey _invocationKey = new InvocationKey();
    private char[] _headerBuffer;
    private int _headerOffset;
    private boolean _isSecure;
    private CharSegment[] _headerKeys;
    private CharSegment[] _headerValues;
    private int _headerSize;
    private boolean _hasRequest;
    private WriteStream _rawWrite;
    private WriteStream _writeStream;
    private ServletFilter _filter = new ServletFilter(this);
    private boolean _initAttributes;
    private byte[] _buffer = new byte[16];

    public FastCgiRequest(ServletService server, SocketLink conn) {
        super(server, conn);
        this._method = new CharBuffer();
        this._uriHost = new CharBuffer();
        this._protocol = new CharBuffer();
        this._rawWrite = conn.getWriteStream();
        this.getWriteStream();
    }

    @Override
    public FastCgiResponse createResponse() {
        return new FastCgiResponse(this, this.getWriteStream());
    }

    WriteStream getWriteStream() {
        if (this._writeStream == null) {
            this._writeStream = new WriteStream();
            this._writeStream.setReuseBuffer(true);
        }
        return this._writeStream;
    }

    @Override
    public final boolean isWaitForRead() {
        return true;
    }

    @Override
    public boolean hasRequest() {
        return this._hasRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleRequest() throws IOException {
        this._hasRequest = false;
        SocketLink conn = this.getConnection();
        ServletService server = this.getServer();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            block19: {
                thread.setContextClassLoader((ClassLoader)server.getClassLoader());
                this.startRequest();
                this.startInvocation();
                ReadStream is = this.getRawRead();
                WriteStream os = this.getRawWrite();
                this._filter.init(is, os);
                this._writeStream.init((StreamImpl)this._filter);
                this._hasRequest = false;
                while (this.readPacket(is)) {
                }
                if (this._hasRequest) break block19;
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.dbgId() + "read timeout");
                }
                boolean bl = false;
                return bl;
            }
            try {
                this.startInvocation();
                this._isSecure = conn.isSecure() || conn.getLocalPort() == 443;
            }
            catch (ClientDisconnectException e) {
                throw e;
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                throw new BadRequestException(String.valueOf(e), e);
            }
            CharSequence host = this.getHost();
            String ipHost = conn.getVirtualHost();
            if (ipHost != null) {
                host = ipHost;
            }
            this._invocationKey.init(this._isSecure, host, conn.getLocalPort(), this._uri, this._uriLength);
            Invocation invocation = this.getInvocation(host);
            if (invocation == null) {
                boolean bl = false;
                return bl;
            }
            this.getRequestFacade().setInvocation(invocation);
            this.startInvocation();
            invocation.service((ServletRequest)this.getRequestFacade(), (ServletResponse)this.getResponseFacade());
        }
        catch (ClientDisconnectException e) {
            throw e;
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
            this.killKeepalive("request exception: " + e);
            WebApp webApp = server.getDefaultWebApp();
            if (webApp != null) {
                webApp.accessLog(this.getRequestFacade(), this.getResponseFacade());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.finishInvocation();
            if (!this.isSuspend()) {
                this.finishRequest();
            }
            thread.setContextClassLoader(oldLoader);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.dbgId() + (this.isKeepalive() ? "keepalive" : "no-keepalive"));
        }
        return this.isKeepalive();
    }

    private Invocation getInvocation(CharSequence host) throws Throwable {
        InvocationServer server = this.getServer().getInvocationServer();
        Invocation invocation = server.getInvocation(this._invocationKey);
        if (invocation == null) {
            invocation = server.createInvocation();
            invocation.setSecure(this._isSecure);
            if (host != null) {
                String hostName = host.toString().toLowerCase(Locale.ENGLISH);
                invocation.setHost(hostName);
                invocation.setPort(this.getConnection().getLocalPort());
                int p = hostName.indexOf(58);
                if (p > 0) {
                    invocation.setHostName(hostName.substring(0, p));
                } else {
                    invocation.setHostName(hostName);
                }
            }
            InvocationDecoder decoder = server.getInvocationDecoder();
            decoder.splitQueryAndUnescape(invocation, this._uri, this._uriLength);
            invocation = server.buildInvocation(this._invocationKey.clone(), invocation);
        }
        invocation = invocation.getRequestInvocation(this.getRequestFacade());
        return invocation;
    }

    public int getVersion() {
        return 17;
    }

    @Override
    public byte[] getUriBuffer() {
        return this._uri;
    }

    @Override
    public int getUriLength() {
        return this._uriLength;
    }

    @Override
    public String getMethod() {
        if (this._methodString == null) {
            CharSegment cb = this.getMethodBuffer();
            if (cb.length() == 0) {
                this._methodString = "GET";
                return this._methodString;
            }
            this._methodString = cb.toString();
        }
        return this._methodString;
    }

    @Override
    public String getProtocol() {
        if (this._protocol.getLength() > 0) {
            return this._protocol.toString();
        }
        return "HTTP/1.1";
    }

    public CharSegment getMethodBuffer() {
        return this._method;
    }

    @Override
    public void setHeader(String key, String value) {
        int i;
        int tail = this._headerSize > 0 ? this._headerValues[this._headerSize - 1].getOffset() + this._headerValues[this._headerSize - 1].getLength() : 0;
        char[] headerBuffer = this._headerBuffer;
        for (i = key.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = key.charAt(i);
        }
        this._headerKeys[this._headerSize].init(headerBuffer, tail, key.length());
        tail += key.length();
        for (i = value.length() - 1; i >= 0; --i) {
            headerBuffer[tail + i] = value.charAt(i);
        }
        this._headerValues[this._headerSize].init(headerBuffer, tail, value.length());
        ++this._headerSize;
    }

    @Override
    public int getHeaderSize() {
        return this._headerSize;
    }

    @Override
    public CharSegment getHeaderKey(int index) {
        return this._headerKeys[index];
    }

    @Override
    public CharSegment getHeaderValue(int index) {
        return this._headerValues[index];
    }

    @Override
    public String getHeader(String key) {
        CharSegment buf = this.getHeaderBuffer(key);
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        char[] keyBuf = this._headerBuffer;
        CharSegment[] headerKeys = this._headerKeys;
        for (int i = this._headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = headerKeys[i];
            if (key.length() != length) continue;
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this._headerValues[i];
        }
        return null;
    }

    @Override
    public void getHeaderBuffers(String key, ArrayList<CharSegment> values) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i]);
        }
    }

    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this._headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this._headerSize;
        int length = key.length();
        char[] keyBuf = this._headerBuffer;
        while (i < size) {
            CharSegment header = this._headerKeys[i];
            if (header.length() == length) {
                int j;
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[offset + j])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this._headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this._headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    @Override
    public boolean initStream(ReadStream readStream, ReadStream rawRead) throws IOException {
        readStream.init((StreamImpl)this._filter, null);
        return true;
    }

    public boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    @Override
    protected void startRequest() throws IOException {
        super.startRequest();
        HttpBufferStore httpBuffer = this.getHttpBufferStore();
        this._method.clear();
        this._methodString = null;
        this._protocol.clear();
        this._uriLength = 0;
        this._uri = this.getSmallUriBuffer();
        this._uriHost.clear();
        this._host = null;
        this._headerSize = 0;
        this._headerBuffer = this.getSmallHeaderBuffer();
        this._headerKeys = this.getSmallHeaderKeys();
        this._headerValues = this.getSmallHeaderValues();
        this._initAttributes = false;
    }

    @Override
    public boolean isSecure() {
        return this._isSecure;
    }

    private boolean readPacket(ReadStream is) throws IOException {
        int version = is.read();
        int code = is.read();
        int id = (is.read() << 8) + is.read();
        int len = (is.read() << 8) + is.read();
        int pad = is.read();
        int reserved = is.read();
        if (reserved < 0) {
            return false;
        }
        if (version != 1) {
            log.warning(this + " unexpected fastcgi version '" + version + "'");
            return false;
        }
        switch (code) {
            case 1: {
                return this.readBeginRequest(is, id);
            }
            case 4: {
                return this.readParams(is, id, len, pad);
            }
            case 5: {
                return this.readStdin(is, id, len, pad);
            }
        }
        log.warning(this + " unexpected fastcgi code '" + code + "'");
        return false;
    }

    private boolean readBeginRequest(ReadStream is, int id) throws IOException {
        boolean isKeepConn;
        int role = (is.read() << 8) + is.read();
        int flags = is.read();
        is.skip(5L);
        if (role != 1) {
            log.warning(this + " does not support role=" + role);
            return false;
        }
        boolean bl = isKeepConn = (flags & 1) != 0;
        if (!isKeepConn) {
            this.killKeepalive("fcgi request close");
        }
        return true;
    }

    private boolean readParams(ReadStream is, int id, int len, int pad) throws IOException {
        if (len == 0) {
            return true;
        }
        long pos = is.getPosition();
        long end = pos + (long)len;
        while (is.getPosition() < end) {
            int keyLen = is.read();
            int valueLen = is.read();
            is.readAll(this._keyBuffer, 0, keyLen);
            this.readParam(is, this._keyBuffer, keyLen, valueLen);
        }
        is.skip((long)pad);
        return true;
    }

    private boolean readStdin(ReadStream is, int id, int len, int pad) throws IOException {
        if (len == 0) {
            return false;
        }
        this._filter.setPending(len, pad);
        return false;
    }

    private void readParam(ReadStream is, byte[] key, int keyLength, int valueLength) throws IOException {
        char ch = key[0];
        switch (keyLength << 8 | ch) {
            case 2898: 
            case 2930: {
                if (!this.isMatch(key, REQUEST_URI, keyLength)) break;
                is.readAll(this._uri, 0, valueLength);
                this._uriLength = valueLength;
                this._hasRequest = true;
                return;
            }
            case 3666: 
            case 3698: {
                if (!this.isMatch(key, REQUEST_METHOD, keyLength)) break;
                this._method.setLength(valueLength);
                is.readAll(this._method.getBuffer(), 0, valueLength);
                return;
            }
            case 3923: 
            case 3955: {
                if (!this.isMatch(key, SERVER_PROTOCOL, keyLength)) break;
                this._protocol.setLength(valueLength);
                is.readAll(this._protocol.getBuffer(), 0, valueLength);
                return;
            }
        }
        CharSegment headerKey = this._headerKeys[this._headerSize];
        CharSegment headerValue = this._headerValues[this._headerSize];
        char[] headerBuffer = this._headerBuffer;
        if (keyLength > 5 && ch == 'H' && key[1] == 84 && key[2] == 84 && key[3] == 80 && key[4] == 95) {
            int headerOffset = this._headerOffset;
            for (int i = 5; i < keyLength; ++i) {
                ch = (char)(key[i] & 0xFF);
                if (ch == '_') {
                    ch = (char)45;
                }
                headerBuffer[headerOffset++] = ch;
            }
            headerKey.init(headerBuffer, this._headerOffset, keyLength - 5);
            is.readAll(headerBuffer, headerOffset, valueLength);
            headerValue.init(headerBuffer, headerOffset, valueLength);
            this._headerOffset = headerOffset + valueLength;
            ++this._headerSize;
            return;
        }
        is.skip((long)valueLength);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " skipping " + new String(key, 0, keyLength));
        }
    }

    private boolean isMatch(byte[] bufferA, byte[] bufferB, int length) {
        for (int i = length - 1; i >= 0; --i) {
            if (bufferA[i] == bufferB[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ReadStream getRawInput() {
        return this.getRawRead();
    }

    void writeTail() throws IOException {
        this._writeStream.flushBuffer();
        int id = 1;
        byte[] tempBuf = this._buffer;
        tempBuf[0] = 1;
        tempBuf[1] = 6;
        tempBuf[2] = (byte)(id >> 8);
        tempBuf[3] = (byte)id;
        tempBuf[4] = 0;
        tempBuf[5] = 0;
        tempBuf[6] = 0;
        tempBuf[7] = 0;
        this._rawWrite.write(tempBuf, 0, 8);
        tempBuf[0] = 1;
        tempBuf[1] = 3;
        tempBuf[2] = (byte)(id >> 8);
        tempBuf[3] = (byte)id;
        tempBuf[4] = 0;
        tempBuf[5] = 8;
        tempBuf[6] = 0;
        tempBuf[7] = 0;
        this._rawWrite.write(tempBuf, 0, 8);
        int status = 0;
        tempBuf[0] = (byte)(status >> 24);
        tempBuf[1] = (byte)(status >> 16);
        tempBuf[2] = (byte)(status >> 8);
        tempBuf[3] = (byte)status;
        tempBuf[4] = 0;
        tempBuf[5] = 0;
        tempBuf[6] = 0;
        tempBuf[7] = 0;
        this._rawWrite.write(tempBuf, 0, 8);
        this._rawWrite.flush();
    }

    @Override
    protected String dbgId() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return "FastCgi[" + connId + "] ";
        }
        return "FastCgi[" + serverId + ", " + connId + "] ";
    }

    public String toString() {
        String serverId = this.getServer().getServerId();
        int connId = this.getConnectionId();
        if ("".equals(serverId)) {
            return this.getClass().getSimpleName() + "[" + connId + "]";
        }
        return this.getClass().getSimpleName() + "[" + serverId + ", " + connId + "]";
    }

    static class ServletFilter
    extends StreamImpl {
        private FastCgiRequest _request;
        private ReadStream _is;
        private WriteStream _os;
        private byte[] _buffer = new byte[16];
        private int _pendingData;
        private int _pad;
        private boolean _isClosed;
        private boolean _isClientClosed;

        ServletFilter(FastCgiRequest request) {
            this._request = request;
        }

        void init(ReadStream nextRead, WriteStream nextWrite) {
            this._is = nextRead;
            this._os = nextWrite;
            this._pendingData = 0;
            this._isClosed = false;
            this._isClientClosed = false;
        }

        void setPending(int pendingData, int pad) {
            this._pendingData = pendingData;
            this._pad = pad;
        }

        void setClientClosed(boolean isClientClosed) {
            this._isClientClosed = isClientClosed;
        }

        public boolean canRead() {
            return true;
        }

        public int getAvailable() {
            return this._pendingData;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            if (this._pendingData <= 0) {
                return -1;
            }
            int sublen = this._pendingData;
            if (length < sublen) {
                sublen = length;
            }
            ReadStream is = this._request.getRawRead();
            is.readAll(buf, offset, sublen);
            this._pendingData -= sublen;
            if (this._pendingData == 0) {
                if (this._pad > 0) {
                    is.skip((long)this._pad);
                }
                this._pad = 0;
                int version = is.read();
                int code = is.read();
                int id = (is.read() << 8) + is.read();
                this._pendingData = (is.read() << 8) + is.read();
                this._pad = is.read();
                int reserved = is.read();
                if (reserved < 0 || code != 5) {
                    this._pendingData = 0;
                }
            }
            return sublen;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + ":data " + length);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this._request.dbgId() + "data <" + new String(buf, offset, length) + ">");
                }
            }
            byte[] tempBuf = this._buffer;
            while (length > 0) {
                int sublen = length;
                if (32768 < sublen) {
                    sublen = 32768;
                }
                int id = 1;
                tempBuf[0] = 1;
                tempBuf[1] = 6;
                tempBuf[2] = (byte)(id >> 8);
                tempBuf[3] = (byte)id;
                tempBuf[4] = (byte)(sublen >> 8);
                tempBuf[5] = (byte)sublen;
                tempBuf[6] = 0;
                tempBuf[7] = 0;
                this._os.write(tempBuf, 0, 8);
                this._os.write(buf, offset, sublen);
                length -= sublen;
                offset += sublen;
            }
        }

        public void flush() throws IOException {
            if (!this._request._hasRequest) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._request.dbgId() + ":flush");
            }
            this._os.flush();
        }

        public void close() throws IOException {
            if (this._isClosed) {
                return;
            }
            this._isClosed = true;
            if (this._pendingData > 0) {
                this._is.skip((long)this._pendingData);
                this._pendingData = 0;
            }
            boolean keepalive = this._request.isKeepalive();
            if (!this._isClientClosed && log.isLoggable(Level.FINE)) {
                if (keepalive) {
                    log.fine(this._request.dbgId() + " quit channel");
                } else {
                    log.fine(this._request.dbgId() + " exit socket");
                }
            }
            if (keepalive) {
                this._os.flush();
            } else {
                this._os.close();
            }
        }
    }
}

