/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.CurrentTime;

public class MnodeUpdate
extends MnodeValue {
    public static final MnodeUpdate NULL = new MnodeUpdate(0L, 0L, 0L, 0L, 0L, 0L, -1L, -1, -1L, -1L);
    private final int _leaseOwner;
    private final long _accessTime;
    private final long _modifiedTime;

    public MnodeUpdate(long valueHash, long valueLength, long version, long flags, long accessedExpireTime, long modifiedExpireTime, long leaseExpireTime, int leaseOwner, long accessTime, long modifiedTime) {
        super(valueHash, valueLength, version, flags, accessedExpireTime, modifiedExpireTime, leaseExpireTime);
        this._leaseOwner = leaseOwner;
        this._accessTime = accessTime;
        this._modifiedTime = modifiedTime;
    }

    public MnodeUpdate(long valueHash, long valueLength, long version) {
        super(valueHash, valueLength, version);
        this._leaseOwner = -1;
        this._accessTime = this._modifiedTime = CurrentTime.getCurrentTime();
    }

    public MnodeUpdate(MnodeUpdate update) {
        super(update);
        this._leaseOwner = update._leaseOwner;
        this._modifiedTime = update._modifiedTime;
        this._accessTime = update._accessTime;
    }

    public MnodeUpdate(MnodeValue mnodeValue) {
        super(mnodeValue);
        this._leaseOwner = -1;
        this._accessTime = this._modifiedTime = CurrentTime.getCurrentTime();
    }

    public MnodeUpdate(MnodeValue mnodeValue, int leaseOwner, long modifiedTime) {
        super(mnodeValue);
        this._leaseOwner = leaseOwner;
        this._modifiedTime = modifiedTime;
        this._accessTime = modifiedTime;
    }

    public MnodeUpdate(long valueHash, long valueLength, long version, CacheConfig config) {
        super(valueHash, valueLength, version, config);
        this._leaseOwner = -1;
        this._accessTime = this._modifiedTime = CurrentTime.getCurrentTime();
    }

    public MnodeUpdate(long valueHash, long valueLength, long version, CacheConfig config, int leaseOwner, long leaseTimeout, long modifiedTime) {
        super(valueHash, valueLength, version, config);
        this._leaseOwner = leaseOwner;
        this._modifiedTime = modifiedTime;
        this._accessTime = modifiedTime;
    }

    public MnodeUpdate(long valueHash, long valueLength, long version, MnodeValue oldValue) {
        super(valueHash, valueLength, version, oldValue);
        this._leaseOwner = -1;
        this._accessTime = this._modifiedTime = CurrentTime.getCurrentTime();
    }

    public MnodeUpdate(long valueHash, long valueLength, long version, MnodeValue oldValue, int leaseOwner) {
        super(valueHash, valueLength, version, oldValue);
        this._leaseOwner = leaseOwner;
        this._accessTime = this._modifiedTime = CurrentTime.getCurrentTime();
    }

    public static MnodeUpdate createNull(long version, MnodeValue oldValue) {
        return new MnodeUpdate(0L, 0L, version, oldValue);
    }

    public static MnodeUpdate createNull(long version, CacheConfig config) {
        return new MnodeUpdate(0L, 0L, version, config);
    }

    public MnodeUpdate createRemote() {
        return new MnodeUpdate(this.getValueHash(), this.getValueLength(), this.getVersion(), this, this.getLeaseOwner());
    }

    public final int getLeaseOwner() {
        return this._leaseOwner;
    }

    public final long getLastAccessTime() {
        return this._accessTime;
    }

    public final long getLastModifiedTime() {
        return this._modifiedTime;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[value=" + Long.toHexString(this.getValueHash()) + ",len=" + this.getValueLength() + ",flags=" + Long.toHexString(this.getFlags()) + ",version=" + this.getVersion() + ",lease=" + this.getLeaseOwner() + "]";
    }
}

