/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.cloud.topology.TriadOwner;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheEngine;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.CacheLoaderExt;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.CacheUpdateWithSource;
import com.caucho.server.distcache.CacheWriterExt;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DataStreamSource;
import com.caucho.server.distcache.DistCacheEntryLoadCallback;
import com.caucho.server.distcache.DistCacheLoadListener;
import com.caucho.server.distcache.DistCacheLoadTask;
import com.caucho.server.distcache.LocalDataManager;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.util.Hex;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class DistCacheEntry {
    private static final L10N L = new L10N(DistCacheEntry.class);
    private static final Logger log = Logger.getLogger(DistCacheEntry.class.getName());
    private final CacheStoreManager _cacheService;
    private final HashKey _keyHash;
    private final CacheHandle _cache;
    private final TriadOwner _owner;
    private Object _key;
    private final AtomicBoolean _isReadUpdate = new AtomicBoolean();
    private final AtomicReference<MnodeEntry> _mnodeEntry = new AtomicReference<MnodeEntry>(MnodeEntry.NULL);
    private final AtomicInteger _loadCount = new AtomicInteger();
    private long _lastLoaderTime;

    DistCacheEntry(CacheStoreManager cacheService, HashKey keyHash, CacheHandle cache, TriadOwner owner) {
        this._cacheService = cacheService;
        this._keyHash = keyHash;
        this._cache = cache;
        this._owner = TriadOwner.getHashOwner(keyHash.getHash());
        this._mnodeEntry.set(MnodeEntry.createInitialNull(cache.getConfig()));
    }

    public final Object getKey() {
        return this._key;
    }

    public final void setKey(Object key) {
        if (this._key == null) {
            this._key = key;
        }
    }

    private LocalDataManager getLocalDataManager() {
        return this._cacheService.getLocalDataManager();
    }

    public final HashKey getKeyHash() {
        return this._keyHash;
    }

    public final TriadOwner getOwner() {
        return this._owner;
    }

    public HashKey getCacheKey() {
        return this._cache.getCacheKey();
    }

    public byte[] getCacheKeyHash() {
        return this._cache.getCacheKeyHash();
    }

    public CacheHandle getCache() {
        return this._cache;
    }

    public CacheConfig getConfig() {
        return this._cache.getConfig();
    }

    public CacheEngine getEngine() {
        return this.getConfig().getEngine();
    }

    public final MnodeEntry getMnodeEntry() {
        return this._mnodeEntry.get();
    }

    public Object get() {
        long now = CurrentTime.getCurrentTime();
        return this.get(now);
    }

    public MnodeEntry loadMnodeValue() {
        long now = CurrentTime.getCurrentTime();
        return this.loadMnodeValue(now, false);
    }

    public final StreamSource getValueStream() {
        MnodeEntry mnodeValue = this.getMnodeEntry();
        return this.getLocalDataManager().createDataSource(mnodeValue.getValueDataId(), mnodeValue.getValueDataTime());
    }

    public long getValueHash(Object value, CacheConfig config) {
        if (value == null) {
            return 0L;
        }
        return this._cacheService.calculateValueHash(value, config);
    }

    public CacheUpdateWithSource loadCacheStream(long requestVersion, boolean isValueStream) {
        MnodeEntry mnodeEntry = this.getMnodeEntry();
        if (mnodeEntry.getVersion() <= requestVersion) {
            return new CacheUpdateWithSource((MnodeValue)mnodeEntry, null, mnodeEntry.getLeaseOwner());
        }
        if (mnodeEntry.isImplicitNull()) {
            return new CacheUpdateWithSource((MnodeValue)mnodeEntry, null, mnodeEntry.getLeaseOwner());
        }
        StreamSource source = null;
        if (isValueStream) {
            long valueDataId = mnodeEntry.getValueDataId();
            long valueDataTime = mnodeEntry.getValueDataTime();
            DataStreamSource dataSource = this.getLocalDataManager().createDataSource(valueDataId, valueDataTime);
            if (dataSource != null) {
                source = new StreamSource((StreamSource)dataSource);
            }
        }
        return new CacheUpdateWithSource((MnodeValue)mnodeEntry, source, mnodeEntry.getLeaseOwner());
    }

    public final void put(Object value) {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry mnodeValue = this.loadLocalMnodeValue();
        this.put(value, now, mnodeValue, true);
    }

    public final void putInternal(Object value) {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry mnodeValue = this.loadLocalMnodeValue();
        this.put(value, now, mnodeValue, false);
    }

    public void put(InputStream is) throws IOException {
        long now;
        long lastAccessTime = now = CurrentTime.getCurrentTime();
        long lastModifiedTime = now;
        CacheConfig config = this.getConfig();
        this.putStream(is, config.getAccessedExpireTimeout(), config.getModifiedExpireTimeout(), 0, lastAccessTime, lastModifiedTime, 0L, false);
    }

    public void putLocal(InputStream is) throws IOException {
        long now;
        long lastAccessTime = now = CurrentTime.getCurrentTime();
        long lastModifiedTime = now;
        CacheConfig config = this.getConfig();
        this.putStream(is, config.getAccessedExpireTimeout(), config.getModifiedExpireTimeout(), 0, lastAccessTime, lastModifiedTime, 0L, true);
    }

    public void put(InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout) throws IOException {
        long now;
        long lastAccessTime = now = CurrentTime.getCurrentTime();
        long lastModifiedTime = now;
        this.putStream(is, accessedExpireTimeout, modifiedExpireTimeout, 0, lastAccessTime, lastModifiedTime, 0L, false);
    }

    public void put(InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, long lastAccessTime, long lastModifiedTime) throws IOException {
        this.putStream(is, accessedExpireTimeout, modifiedExpireTimeout, 0, lastAccessTime, lastModifiedTime, 0L, false);
    }

    public void put(InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, int flags) throws IOException {
        long now;
        long lastAccessTime = now = CurrentTime.getCurrentTime();
        long lastModifiedTime = now;
        this.putStream(is, accessedExpireTimeout, modifiedExpireTimeout, flags, lastAccessTime, lastModifiedTime, 0L, false);
    }

    public void putIfNewer(long version, InputStream is) throws IOException {
        long now;
        long lastAccessTime = now = CurrentTime.getCurrentTime();
        long lastModifiedTime = now;
        CacheConfig config = this.getConfig();
        this.putStream(is, config.getAccessedExpireTimeout(), config.getModifiedExpireTimeout(), 0, lastAccessTime, lastModifiedTime, version, false);
    }

    private final void putStream(InputStream is, long accessedExpireTime, long modifiedExpireTime, int userFlags, long lastAccessTime, long lastModifiedTime, long newVersion, boolean isLocal) throws IOException {
        this.loadLocalMnodeValue();
        LocalDataManager.DataItemLocal valueItem = this.getLocalDataManager().writeData(is);
        long valueHash = valueItem.getValueHash();
        long valueDataId = valueItem.getValueDataId();
        long valueDataTime = valueItem.getValueDataTime();
        long valueLength = valueItem.getLength();
        MnodeEntry mnodeEntry = this.getMnodeEntry();
        if (newVersion <= 0L) {
            newVersion = this.getNewVersion(this.getMnodeEntry());
        } else if (newVersion < mnodeEntry.getVersion()) {
            log.finer(this + " put with obsolete version current=0x" + Long.toHexString(mnodeEntry.getVersion()) + " new=0x" + Long.toHexString(newVersion));
        }
        CacheConfig config = this.getConfig();
        long flags = (long)config.getFlags() | (long)userFlags << 32;
        if (accessedExpireTime < 0L) {
            accessedExpireTime = config.getAccessedExpireTimeout();
        }
        if (modifiedExpireTime < 0L) {
            modifiedExpireTime = config.getModifiedExpireTimeout();
        }
        long now = CurrentTime.getCurrentTime();
        long delta = now - mnodeEntry.getLastAccessedTime();
        if (valueHash == mnodeEntry.getValueHash() && flags == mnodeEntry.getFlags() && delta < modifiedExpireTime && delta < accessedExpireTime) {
            return;
        }
        int leaseOwner = this.getMnodeEntry().getLeaseOwner();
        long leaseExpireTimeout = config.getLeaseExpireTimeout();
        MnodeUpdate mnodeUpdate = new MnodeUpdate(valueHash, valueLength, newVersion, flags, accessedExpireTime, modifiedExpireTime, leaseExpireTimeout, leaseOwner, lastAccessTime, lastModifiedTime);
        this.putLocalValue(mnodeUpdate, valueDataId, valueDataTime, null);
        config.getEngine().put(this.getKeyHash(), this.getCacheKey(), mnodeUpdate, valueDataId, valueDataTime);
        CacheWriterExt writer = config.getCacheWriterExt();
        if (!isLocal && writer != null && config.isWriteThrough()) {
            writer.write(this);
        }
    }

    public final boolean remove() {
        HashKey key = this.getKeyHash();
        MnodeEntry mnodeEntry = this.loadLocalMnodeValue();
        long oldValueHash = mnodeEntry.getValueHash();
        long newVersion = this.getNewVersion(mnodeEntry);
        CacheConfig config = this.getConfig();
        MnodeUpdate mnodeUpdate = MnodeUpdate.createNull(newVersion, config);
        this.putLocalValueImpl(mnodeUpdate, 0L, 0L, null);
        config.getEngine().remove(key, this.getCacheKey(), mnodeUpdate);
        CacheWriterExt writer = config.getCacheWriterExt();
        if (writer != null && config.isWriteThrough()) {
            writer.delete(this);
        }
        return oldValueHash != 0L;
    }

    public boolean putIfNew(MnodeUpdate update, InputStream is) throws IOException {
        MnodeEntry entry = this.getMnodeEntry();
        if (update.getVersion() < entry.getVersion()) {
            return false;
        }
        if (update.getVersion() == entry.getVersion() && update.getValueHash() == entry.getValueHash()) {
            return false;
        }
        MnodeValue newValue = this.putLocalValue(update, is);
        entry = this.getMnodeEntry();
        if (newValue.getValueHash() == update.getValueHash()) {
            this.getEngine().put(this.getKeyHash(), this.getCacheKey(), update, entry.getValueDataId(), entry.getValueDataTime());
        }
        return newValue.getValueHash() == update.getValueHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAndPut(long testValue, Object value) {
        MnodeEntry oldMnodeEntry = this.getMnodeEntry();
        CacheConfig config = this.getConfig();
        LocalDataManager.DataItemLocal dataItem = this.getLocalDataManager().writeValue(this.getMnodeEntry(), value, config);
        long valueDataId = dataItem.getValueDataId();
        long valueDataTime = dataItem.getValueDataTime();
        long newVersion = this.getNewVersion(oldMnodeEntry);
        try {
            MnodeUpdate update = new MnodeUpdate(dataItem.getValueHash(), dataItem.getLength(), newVersion, config);
            boolean bl = config.getEngine().compareAndPut(this, testValue, update, valueDataId, valueDataTime);
            return bl;
        }
        finally {
            MnodeEntry newMnodeValue = this.getMnodeEntry();
            if (newMnodeValue.getValueHash() != dataItem.getValueHash()) {
                this.getLocalDataManager().removeData(valueDataId, valueDataTime);
            }
        }
    }

    public final boolean compareAndPutLocal(long testValue, MnodeUpdate update, StreamSource source) {
        long version = update.getVersion();
        LocalDataManager.DataItemLocal dataItem = this.getLocalDataManager().writeData((MnodeValue)update, version, source);
        long valueDataId = dataItem.getValueDataId();
        long valueDataTime = dataItem.getValueDataTime();
        Object value = null;
        return this.compareAndPutLocal(testValue, update, valueDataId, valueDataTime, value);
    }

    public boolean compareAndPutLocal(long testValueHash, MnodeUpdate update, long valueDataId, long valueDataTime, Object value) {
        MnodeEntry mnodeValue = this.loadLocalMnodeValue();
        long oldValueHash = mnodeValue.getValueHash();
        if (testValueHash != oldValueHash && (testValueHash != MnodeEntry.ANY_KEY || oldValueHash == 0L)) {
            return false;
        }
        mnodeValue = this.putLocalValueImpl(update, valueDataId, valueDataTime, value);
        return mnodeValue != null;
    }

    protected boolean compareAndPut(DistCacheEntry entry, long testValue, MnodeUpdate mnodeUpdate, long valueDataId, long valueDataTime, Object value, CacheConfig config) {
        CacheEngine engine = config.getEngine();
        return engine.compareAndPut(entry, testValue, mnodeUpdate, valueDataId, valueDataTime);
    }

    public Object getAndRemove() {
        return this.getAndPut(null);
    }

    public Object getAndReplace(long testValue, Object value) {
        long prevDataId = this.getMnodeEntry().getValueDataId();
        long prevDataTime = this.getMnodeEntry().getValueDataTime();
        if (this.compareAndPut(testValue, value)) {
            long result = -1L;
            CacheConfig config = this.getConfig();
            return this.getLocalDataManager().readData(this.getKeyHash(), result, prevDataId, prevDataTime, config.getValueSerializer(), config);
        }
        return null;
    }

    public Object getAndPut(Object value) {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry mnodeValue = this.loadMnodeValue(now, true);
        return this.getAndPut(value, now, mnodeValue);
    }

    protected final Object getAndPut(Object value, long now, MnodeEntry mnodeValue) {
        CacheConfig config = this.getConfig();
        LocalDataManager.DataItemLocal dataItem = this.getLocalDataManager().writeValue(mnodeValue, value, config);
        long version = this.getNewVersion(this.getMnodeEntry());
        MnodeUpdate update = new MnodeUpdate(dataItem.getValueHash(), dataItem.getLength(), version, config);
        InputStream is = this.getAndPut(update, dataItem.getValueDataId(), dataItem.getValueDataTime());
        if (is == null) {
            return null;
        }
        Object oldValue = this.getLocalDataManager().decodeValue(is, config.getValueSerializer());
        return oldValue;
    }

    public DataStore.DataItem getAndPutLocal(MnodeUpdate mnodeUpdate, StreamSource source) {
        long oldValueDataId = this.getMnodeEntry().getValueDataId();
        long oldValueDataTime = this.getMnodeEntry().getValueDataTime();
        LocalDataManager.DataItemLocal dataItem = this.getLocalDataManager().writeData(source);
        long valueDataId = dataItem.getValueDataId();
        long valueDataTime = dataItem.getValueDataTime();
        Object value = null;
        this.putLocalValue(mnodeUpdate, valueDataId, valueDataTime, value);
        return new DataStore.DataItem(oldValueDataId, oldValueDataTime);
    }

    public long getAndPutLocal(DistCacheEntry entry, MnodeUpdate mnodeUpdate, long valueDataId, long valueDataTime, Object value) {
        long oldValueHash = entry.getMnodeEntry().getValueHash();
        entry.putLocalValue(mnodeUpdate, valueDataId, valueDataTime, value);
        return oldValueHash;
    }

    private InputStream getAndPut(MnodeUpdate mnodeValue, long valueDataId, long valueDataTime) {
        return this.getEngine().getAndPut(this, mnodeValue, valueDataId, valueDataTime);
    }

    public final boolean compareAndSetEntry(MnodeEntry oldMnodeValue, MnodeEntry mnodeValue) {
        if (mnodeValue == null) {
            throw new NullPointerException();
        }
        return this._mnodeEntry.compareAndSet(oldMnodeValue, mnodeValue);
    }

    public boolean readData(OutputStream os, CacheConfig config) throws IOException {
        return this.getLocalDataManager().readData(this.getKeyHash(), this.getMnodeEntry(), os, config);
    }

    public boolean isModified(MnodeValue newValue) {
        MnodeEntry oldValue = this.getMnodeEntry();
        if (oldValue.getVersion() < newValue.getVersion()) {
            return true;
        }
        return newValue.getVersion() >= oldValue.getVersion();
    }

    private long getNewVersion(MnodeValue mnodeValue) {
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        return this.getNewVersion(version);
    }

    private long getNewVersion(long version) {
        long newVersion = version + 1L;
        long now = CurrentTime.getCurrentTime();
        if (newVersion < now) {
            return now;
        }
        return newVersion;
    }

    public void clearLease(int oldLeaseOwner) {
        this.getMnodeEntry().clearLease(oldLeaseOwner);
    }

    public void clearLease() {
        this.getMnodeEntry().clearLease();
    }

    public boolean isLeaseExpired() {
        return this.getMnodeEntry().isLeaseExpired(CurrentTime.getCurrentTime());
    }

    public void updateLease(int leaseOwner) {
        if (leaseOwner <= 2) {
            return;
        }
        long now = CurrentTime.getCurrentTime();
        MnodeEntry entry = this.getMnodeEntry();
        if (this.isLeaseExpired() || entry.getLeaseOwner() == leaseOwner) {
            entry.setLeaseOwner(leaseOwner, now);
        }
    }

    public long getCost() {
        return 0L;
    }

    public void load() {
        long now = CurrentTime.getCurrentTime();
        this.loadMnodeValue(now, true);
    }

    public void load(DistCacheLoadListener listener) {
        this.loadMnodeValue(listener);
    }

    private Object get(long now) {
        MnodeEntry mnodeEntry = this.loadMnodeValue(now, true);
        if (mnodeEntry == null) {
            return null;
        }
        Object value = mnodeEntry.getValue();
        if (value != null) {
            return value;
        }
        long valueHash = mnodeEntry.getValueHash();
        if (valueHash == 0L) {
            return null;
        }
        this.updateAccessTime(mnodeEntry, now);
        CacheConfig config = this.getConfig();
        value = this._cacheService.getLocalDataManager().readData(this.getKeyHash(), valueHash, mnodeEntry.getValueDataId(), mnodeEntry.getValueDataTime(), config.getValueSerializer(), config);
        if (value == null) {
            log.warning("Missing or corrupted data in get for " + mnodeEntry + " " + this);
            this.remove();
        }
        if (!config.isStoreByValue() || this.isImmutable(value)) {
            mnodeEntry.setObjectValue(value);
        }
        return value;
    }

    private boolean isImmutable(Object value) {
        return value instanceof String;
    }

    public long getValueHash() {
        MnodeEntry entry = this.getMnodeEntry();
        return entry.getValueHash();
    }

    public long getVersion() {
        MnodeEntry entry = this.getMnodeEntry();
        return entry.getVersion();
    }

    public Object getValue() {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry entry = this.getMnodeEntry();
        return this.getValue(entry, now);
    }

    private Object getValue(MnodeEntry mnodeEntry, long now) {
        if (mnodeEntry == null) {
            return null;
        }
        Object value = mnodeEntry.getValue();
        if (value != null) {
            return value;
        }
        long valueHash = mnodeEntry.getValueHash();
        if (valueHash == 0L) {
            return null;
        }
        this.updateAccessTime(mnodeEntry, now);
        CacheConfig config = this.getConfig();
        value = this._cacheService.getLocalDataManager().readData(this.getKeyHash(), valueHash, mnodeEntry.getValueDataId(), mnodeEntry.getValueDataTime(), config.getValueSerializer(), config);
        if (value == null) {
            log.warning("Missing or corrupted data in get for " + mnodeEntry + " " + this);
            this.remove();
        }
        mnodeEntry.setObjectValue(value);
        return value;
    }

    private final MnodeEntry loadMnodeValue(long now, boolean isUpdateAccessTime) {
        MnodeEntry mnodeEntry = this.loadLocalMnodeValue();
        CacheConfig config = this.getConfig();
        int server = config.getServerIndex();
        if (mnodeEntry == null || mnodeEntry.isLocalExpired(server, now, config) || !this.isReadThroughLocalValid(now)) {
            this.reloadValue(now, isUpdateAccessTime);
        }
        if (isUpdateAccessTime) {
            this.updateAccessTime();
        }
        mnodeEntry = this.getMnodeEntry();
        return mnodeEntry;
    }

    private final void loadMnodeValue(DistCacheLoadListener listener) {
        MnodeEntry mnodeEntry = this.loadLocalMnodeValue();
        CacheConfig config = this.getConfig();
        int server = config.getServerIndex();
        long now = CurrentTime.getCurrentTime();
        if (mnodeEntry == null || mnodeEntry.isLocalExpired(server, now, config)) {
            DistCacheLoadTask task = new DistCacheLoadTask(this, listener);
            this._cacheService.schedule(task);
        } else {
            this.updateAccessTime();
            listener.onLoad(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadValue(long now, boolean isUpdateAccessTime) {
        if (this.startReadUpdate()) {
            try {
                this.loadExpiredValue(now, isUpdateAccessTime);
            }
            finally {
                this.finishReadUpdate();
            }
        }
    }

    private void loadExpiredValue(long now, boolean isUpdateAccessTime) {
        MnodeEntry mnodeEntry = this.getMnodeEntry();
        this._loadCount.incrementAndGet();
        CacheConfig config = this.getConfig();
        CacheEngine engine = config.getEngine();
        engine.get(this);
        mnodeEntry = this.getMnodeEntry();
        if (!mnodeEntry.isExpired(now) && this.isReadThroughLocalValid(now)) {
            if (isUpdateAccessTime) {
                mnodeEntry.setLastAccessTime(now);
            }
        } else if (this.loadFromCacheLoader(now)) {
            this._lastLoaderTime = now;
            mnodeEntry.setLastAccessTime(now);
        } else {
            MnodeEntry nullMnodeValue = new MnodeEntry(0L, 0L, mnodeEntry.getVersion(), 0L, config.getAccessedExpireTimeout(), config.getModifiedExpireTimeout(), config.getLeaseExpireTimeout(), 0L, 0L, null, now, now, true, true);
            this.compareAndSetEntry(mnodeEntry, nullMnodeValue);
        }
    }

    private boolean isReadThroughLocalValid(long now) {
        CacheConfig config = this.getConfig();
        if (!config.isReadThrough()) {
            return true;
        }
        return now - this._lastLoaderTime < config.getReadThroughExpireTimeout();
    }

    private boolean loadFromCacheLoader(long now) {
        CacheConfig config = this.getConfig();
        CacheLoaderExt loader = config.getCacheLoaderExt();
        if (loader != null && config.isReadThrough() && this.getKey() != null) {
            DistCacheEntryLoadCallback cb = new DistCacheEntryLoadCallback();
            loader.load(this, cb);
            return cb.get();
        }
        return false;
    }

    final void loadLocalEntry() {
        long now = CurrentTime.getCurrentTime();
        if (this.getMnodeEntry().isExpired(now) || !this.isReadThroughLocalValid(now)) {
            this.forceLoadMnodeValue();
        }
    }

    private MnodeEntry forceLoadMnodeValue() {
        HashKey key = this.getKeyHash();
        MnodeEntry mnodeValue = this.getMnodeEntry();
        MnodeEntry newMnodeValue = this._cacheService.getDataBacking().loadLocalEntryValue(key);
        if (newMnodeValue != null) {
            this.compareAndSetEntry(mnodeValue, newMnodeValue);
        }
        return this.getMnodeEntry();
    }

    public final boolean getStream(OutputStream os) throws IOException {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry mnodeValue = this.loadMnodeValue();
        if (mnodeValue == null) {
            return false;
        }
        this.updateAccessTime(mnodeValue, now);
        long valueHash = mnodeValue.getValueHash();
        if (valueHash == 0L) {
            return false;
        }
        CacheConfig config = this.getConfig();
        return this.getLocalDataManager().readData(this.getKeyHash(), mnodeValue, os, config);
    }

    public final boolean getLocalStream(OutputStream os) throws IOException {
        long now = CurrentTime.getCurrentTime();
        MnodeEntry mnodeValue = this.getMnodeEntry();
        if (mnodeValue == null) {
            return false;
        }
        long valueHash = mnodeValue.getValueHash();
        if (valueHash == 0L) {
            return false;
        }
        CacheConfig config = this.getConfig();
        return this.getLocalDataManager().readData(this.getKeyHash(), mnodeValue, os, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MnodeUpdate localUpdate(MnodeUpdate update, InputStream is) {
        MnodeEntry oldEntryValue = this.getMnodeEntry();
        long oldEntryHash = oldEntryValue.getValueHash();
        long oldValueDataId = oldEntryValue.getValueDataId();
        long oldValueDataTime = oldEntryValue.getValueDataTime();
        LocalDataManager.DataItemLocal data = null;
        if (update.getValueHash() != 0L && (oldEntryValue == null || oldEntryValue.getVersion() < update.getVersion() || oldEntryValue.getVersion() == update.getVersion() && update.getValueHash() < oldEntryHash)) {
            try {
                if (is != null) {
                    data = this._cacheService.getLocalDataManager().writeData((MnodeValue)update, update.getVersion(), is);
                }
            }
            finally {
                IoUtil.close((InputStream)is);
            }
        }
        if (data != null) {
            this.putLocalValueImpl(update, data.getValueDataId(), data.getValueDataTime(), null);
        } else {
            this.putLocalValueImpl(update, oldValueDataId, oldValueDataTime, null);
        }
        return this.getMnodeEntry().getRemoteUpdate();
    }

    public final MnodeValue putLocalValue(MnodeUpdate mnodeUpdate, InputStream is) {
        MnodeUpdate mnodeValue = this.localUpdate(mnodeUpdate, is);
        this._cacheService.notifyPutListeners(this.getKeyHash(), this.getCacheKey(), mnodeUpdate, mnodeValue);
        return mnodeValue;
    }

    public final MnodeEntry putLocalValue(MnodeUpdate mnodeUpdate, DataStore.DataItem valueData, Object value) {
        long valueDataId = 0L;
        long valueDataTime = 0L;
        if (valueData != null) {
            valueDataId = valueData.getId();
            valueDataTime = valueData.getTime();
        }
        return this.putLocalValue(mnodeUpdate, valueDataId, valueDataTime, value);
    }

    public final MnodeEntry putLocalValue(MnodeUpdate mnodeUpdate, long valueDataId, long valueDataTime, Object value) {
        MnodeEntry prevMnodeValue = this.getMnodeEntry();
        MnodeEntry mnodeValue = this.putLocalValueImpl(mnodeUpdate, valueDataId, valueDataTime, value);
        if (mnodeValue.getValueHash() != prevMnodeValue.getValueHash()) {
            this._cacheService.notifyPutListeners(this.getKeyHash(), this.getCacheKey(), mnodeUpdate, mnodeValue);
        }
        return mnodeValue;
    }

    private final MnodeEntry putLocalValueImpl(MnodeUpdate mnodeUpdate, long valueDataId, long valueDataTime, Object value) {
        int leaseOwner;
        long updateTime;
        long accessTime;
        Object saveValue;
        MnodeEntry mnodeValue;
        HashKey key = this.getKeyHash();
        long valueHash = mnodeUpdate.getValueHash();
        long version = mnodeUpdate.getVersion();
        MnodeEntry oldEntryValue = this.getMnodeEntry();
        int oldLeaseOwner = oldEntryValue.getLeaseOwner();
        do {
            long oldValueHash = (oldEntryValue = this.loadLocalMnodeValue()) != null ? oldEntryValue.getValueHash() : 0L;
            long oldVersion = oldEntryValue != null ? oldEntryValue.getVersion() : 0L;
            long now = CurrentTime.getCurrentTime();
            if (version < oldVersion || version == oldVersion && valueHash != 0L && valueHash <= oldValueHash) {
                return oldEntryValue;
            }
            accessTime = mnodeUpdate.getLastAccessTime();
            updateTime = mnodeUpdate.getLastModifiedTime();
            leaseOwner = oldLeaseOwner;
            saveValue = null;
            if (this.getConfig().isStoreByValue() && !this.isImmutable(value)) continue;
            saveValue = value;
        } while (!this.compareAndSetEntry(oldEntryValue, mnodeValue = new MnodeEntry(mnodeUpdate, valueDataId, valueDataTime, saveValue, accessTime, updateTime, true, false, leaseOwner)));
        this._cacheService.getDataBacking().putLocalValue(mnodeValue, key, this.getCacheKey(), oldEntryValue, mnodeUpdate);
        if (oldLeaseOwner != mnodeUpdate.getLeaseOwner()) {
            this.clearLease(oldLeaseOwner);
            this._cacheService.getCacheEngine().notifyLease(key, this.getCacheKey(), oldLeaseOwner);
        }
        return mnodeValue;
    }

    protected final void put(Object value, long now, MnodeEntry mnodeEntry, boolean isWriteThrough) {
        HashKey key = this.getKeyHash();
        CacheConfig config = this.getConfig();
        LocalDataManager.DataItemLocal dataItem = this._cacheService.getLocalDataManager().writeValue(mnodeEntry, value, config);
        long version = this.getNewVersion(mnodeEntry);
        MnodeUpdate update = new MnodeUpdate(dataItem.getValueHash(), dataItem.getLength(), version, config);
        mnodeEntry = this.putLocalValueImpl(update, dataItem.getValueDataId(), dataItem.getValueDataTime(), value);
        if (mnodeEntry == null) {
            return;
        }
        if (update.getValueHash() != 0L != (dataItem.getValueDataId() != 0L)) {
            throw new IllegalStateException(L.l("{0}: update: {1} dataItem: {2}", (Object)this, (Object)update, (Object)dataItem));
        }
        config.getEngine().put(key, this.getCacheKey(), update, dataItem.getValueDataId(), dataItem.getValueDataTime());
        CacheWriterExt writer = config.getCacheWriterExt();
        if (isWriteThrough && writer != null && config.isWriteThrough()) {
            writer.write(this);
        }
    }

    public final MnodeEntry putLocalValue(MnodeEntry mnodeValue) {
        MnodeEntry oldEntryValue = this.getMnodeEntry();
        if (oldEntryValue != null && mnodeValue.compareTo(oldEntryValue) <= 0) {
            return oldEntryValue;
        }
        if (!this.compareAndSetEntry(oldEntryValue, mnodeValue)) {
            log.fine(this + " mnodeValue update failed due to timing conflict (key=" + this.getKeyHash() + ")");
            return this.getMnodeEntry();
        }
        this._cacheService.getDataBacking().insertLocalValue(this.getKeyHash(), this.getCacheKey(), mnodeValue, oldEntryValue);
        return this.getMnodeEntry();
    }

    final MnodeEntry loadLocalMnodeValue() {
        HashKey key = this.getKeyHash();
        MnodeEntry mnodeValue = this.getMnodeEntry();
        if (mnodeValue.isImplicitNull()) {
            MnodeEntry newMnodeValue = this._cacheService.getDataBacking().loadLocalEntryValue(key);
            if (newMnodeValue == null) {
                newMnodeValue = MnodeEntry.NULL;
            }
            this.compareAndSetEntry(mnodeValue, newMnodeValue);
            mnodeValue = this.getMnodeEntry();
        }
        return mnodeValue;
    }

    public void updateModifiedTime() {
        MnodeEntry mnodeValue = this.getMnodeEntry();
        long now = CurrentTime.getCurrentTime();
        MnodeEntry newMnodeValue = mnodeValue.updateModifiedTime(now);
        this.compareAndSetEntry(mnodeValue, newMnodeValue);
    }

    void updateAccessTime(MnodeEntry mnodeValue, long now) {
        if (mnodeValue != null) {
            long idleTimeout = mnodeValue.getAccessedExpireTimeout();
            long updateTime = mnodeValue.getLastModifiedTime();
            if (idleTimeout < 0x3FFFFFFFFFFFFFFFL && updateTime + mnodeValue.getAccessExpireTimeoutWindow() < now) {
                mnodeValue.setLastAccessTime(now);
                this.saveUpdateTime(mnodeValue);
            }
        }
    }

    protected final void updateAccessTime() {
        MnodeEntry mnodeValue = this.getMnodeEntry();
        long accessedExpireTimeout = mnodeValue.getAccessedExpireTimeout();
        long accessedTime = mnodeValue.getLastAccessedTime();
        long now = CurrentTime.getCurrentTime();
        if (accessedExpireTimeout < 0x3FFFFFFFFFFFFFFFL && accessedTime + mnodeValue.getAccessExpireTimeoutWindow() < now) {
            mnodeValue.setLastAccessTime(now);
            this.saveUpdateTime(mnodeValue);
        }
    }

    final MnodeEntry saveUpdateTime(MnodeEntry mnodeValue) {
        MnodeEntry newEntryValue = this.saveLocalUpdateTime(mnodeValue);
        if (newEntryValue.getVersion() != mnodeValue.getVersion()) {
            return newEntryValue;
        }
        this._cacheService.getCacheEngine().updateTime(this.getKeyHash(), this.getCacheKey(), mnodeValue);
        CacheWriterExt writer = this.getConfig().getCacheWriterExt();
        if (writer != null && this.getConfig().isWriteThrough()) {
            writer.updateTime(this);
        }
        return mnodeValue;
    }

    final MnodeEntry saveLocalUpdateTime(MnodeEntry mnodeValue) {
        MnodeEntry oldEntryValue = this.getMnodeEntry();
        if (oldEntryValue != null && mnodeValue.getVersion() < oldEntryValue.getVersion()) {
            return oldEntryValue;
        }
        if (oldEntryValue != null && mnodeValue != oldEntryValue && mnodeValue.getLastAccessedTime() == oldEntryValue.getLastAccessedTime() && mnodeValue.getLastModifiedTime() == oldEntryValue.getLastModifiedTime()) {
            return oldEntryValue;
        }
        if (!this.compareAndSetEntry(oldEntryValue, mnodeValue)) {
            log.fine(this + " mnodeValue updateTime failed due to timing conflict (key=" + this.getKeyHash() + ")");
            return this.getMnodeEntry();
        }
        this._cacheService.getDataBacking().saveLocalUpdateTime(this.getKeyHash(), mnodeValue, oldEntryValue);
        return this.getMnodeEntry();
    }

    public void clear() {
        this._mnodeEntry.set(MnodeEntry.NULL);
    }

    private final boolean startReadUpdate() {
        return this._isReadUpdate.compareAndSet(false, true);
    }

    private final void finishReadUpdate() {
        this._isReadUpdate.set(false);
    }

    private long getNewVersion(MnodeEntry mnodeValue) {
        long version = mnodeValue != null ? mnodeValue.getVersion() : 0L;
        return this.getNewVersion(version);
    }

    public int getLoadCount() {
        return this._loadCount.get();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[key=" + this._key + ",keyHash=" + Hex.toHex((byte[])this._keyHash.getHash(), (int)0, (int)4) + ",owner=" + (Object)((Object)this._owner) + "]";
    }
}

