/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.env.service.ResinSystem;
import com.caucho.inject.Module;
import com.caucho.server.distcache.CacheEntryFactory;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.util.HashKey;
import com.caucho.util.LruCache;
import java.util.Iterator;

@Module
public final class CacheEntryManager {
    private final String _serverId;
    private final CacheEntryFactory _cacheEntryFactory;
    private final LruCache<HashKey, DistCacheEntry> _entryCache = new LruCache(65536);

    public CacheEntryManager(CacheEntryFactory cacheEntryFactory) {
        this._serverId = ResinSystem.getCurrentId();
        this._cacheEntryFactory = cacheEntryFactory;
    }

    public final DistCacheEntry getCacheEntry(HashKey key) {
        return (DistCacheEntry)this._entryCache.get((Object)key);
    }

    public final DistCacheEntry createCacheEntry(HashKey key, CacheHandle cache) {
        DistCacheEntry cacheEntry = (DistCacheEntry)this._entryCache.get((Object)key);
        if (cacheEntry != null) {
            return cacheEntry;
        }
        cacheEntry = this._cacheEntryFactory.createCacheEntry(key, cache);
        cacheEntry = (DistCacheEntry)this._entryCache.putIfNew((Object)cacheEntry.getKeyHash(), (Object)cacheEntry);
        cacheEntry.loadLocalMnodeValue();
        return cacheEntry;
    }

    public Iterator<DistCacheEntry> getEntries() {
        return this._entryCache.values();
    }

    public final void clearLeases() {
        Iterator iter = this._entryCache.values();
        while (iter.hasNext()) {
            DistCacheEntry entry = (DistCacheEntry)iter.next();
            entry.clearLease();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }
}

