/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.webapp.RequestDispatcherImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RewriteDispatchFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(RewriteDispatchFilterChain.class.getName());
    private String _url;

    public RewriteDispatchFilterChain(String url) {
        this._url = url;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            String url = this._url;
            RequestDispatcherImpl disp = (RequestDispatcherImpl)req.getRequestDispatcher(url);
            disp.dispatch(request, response);
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINE, e.toString(), e);
            res.sendError(404);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._url + "]";
    }
}

