/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.network.NetworkClusterSystem;
import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.env.service.ResinSystem;
import com.caucho.env.thread.ThreadPool;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.network.listen.TcpPort;
import com.caucho.rewrite.DispatchRule;
import com.caucho.server.admin.Management;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.distcache.PersistentStoreConfig;
import com.caucho.server.e_app.EarConfig;
import com.caucho.server.host.HostConfig;
import com.caucho.server.host.HostExpandDeployGenerator;
import com.caucho.server.httpcache.AbstractProxyCache;
import com.caucho.server.log.AccessLog;
import com.caucho.server.resin.Resin;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.server.webapp.ErrorPage;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import javax.annotation.PostConstruct;

@Configurable
public class ServletContainerConfig
implements EnvironmentBean,
SchemaBean {
    private static final L10N L = new L10N(ServletContainerConfig.class);
    private final ResinSystem _resinSystem;
    private final Resin _resin;
    private PersistentStoreConfig _persistentStoreConfig;
    private long _memoryFreeMin = 0x100000L;
    private long _permGenFreeMin = 0x100000L;
    private int _threadMax = 4096;
    private int _threadExecutorTaskMax = -1;
    private int _threadIdleMin = -1;
    private int _threadIdleMax = -1;
    private long _threadIdleTimeout = -1L;
    private CloudServer _selfServer;
    private ServletService _servletContainer;

    public ServletContainerConfig(ServletService servletContainer) {
        this._servletContainer = servletContainer;
        this._resinSystem = servletContainer.getResinSystem();
        this._resin = servletContainer.getResin();
        this._selfServer = NetworkClusterSystem.getCurrentSelfServer();
        Config.setProperty((String)"server", (Object)new ServerVar(this._selfServer), (ClassLoader)this.getClassLoader());
        Config.setProperty((String)"cluster", (Object)new ClusterVar(), (ClassLoader)this.getClassLoader());
    }

    public ResinSystem getResinSystem() {
        return this._resinSystem;
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._resinSystem.getClassLoader();
    }

    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    @Configurable
    public void setDevelopmentModeErrorPage(boolean isEnable) {
        this._servletContainer.setDevelopmentModeErrorPage(isEnable);
    }

    @Configurable
    public void setErrorPageServerId(boolean isEnable) {
        this._servletContainer.setErrorPageServerId(isEnable);
    }

    @Configurable
    public PersistentStoreConfig createPersistentStore() {
        if (this._persistentStoreConfig == null) {
            this._persistentStoreConfig = new PersistentStoreConfig();
            this._servletContainer.setPersistentStore(this._persistentStoreConfig);
        }
        return this._persistentStoreConfig;
    }

    public PersistentStoreConfig getPersistentStoreConfig() {
        return this._persistentStoreConfig;
    }

    public void startPersistentStore() {
    }

    @Configurable
    public Object createJdbcStore() throws ConfigException {
        return null;
    }

    @Configurable
    public void addJavaExe(String args) {
    }

    @Configurable
    public void addJvmArg(String args) {
    }

    @Configurable
    public void addJvmArgLine(String args) {
    }

    @Configurable
    public void addJvmClasspath(String args) {
    }

    @Configurable
    public void setStage(String stage) {
        if (stage == null || "".equals(stage)) {
            stage = "production";
        }
        this._servletContainer.setStage(stage);
    }

    @Configurable
    public void setSystemClassLoader(String loader) {
    }

    @Configurable
    public void addWatchdogArg(String args) {
    }

    @Configurable
    public void addWatchdogJvmArg(String args) {
    }

    @Configurable
    public void addWatchdogLog(ConfigProgram args) {
    }

    @Configurable
    public void addWatchdogPassword(String args) {
    }

    @Configurable
    public void addWatchdogPort(int port) {
    }

    @Configurable
    public void setDynamicServerEnable(boolean isEnable) {
    }

    @Configurable
    public void setMemoryFreeMin(Bytes min) {
        this._memoryFreeMin = min.getBytes();
    }

    public long getMemoryFreeMin() {
        return this._memoryFreeMin;
    }

    @Configurable
    public void setPermGenFreeMin(Bytes min) {
        this._permGenFreeMin = min.getBytes();
    }

    public long getPermGenFreeMin() {
        return this._permGenFreeMin;
    }

    @Configurable
    public Management createManagement() {
        if (this._resin != null) {
            return this._resin.createResinManagement();
        }
        return null;
    }

    @Configurable
    public void setRedeployMode(String redeployMode) {
    }

    @Configurable
    public void setShutdownWaitMax(Period waitTime) {
        this._servletContainer.setShutdownWaitMax(waitTime);
    }

    @Configurable
    public void setInvocationCacheSize(int count) {
        this._servletContainer.getInvocationServer().setInvocationCacheSize(count);
    }

    @Configurable
    public void setThreadMax(int max) {
        if (max < 0) {
            throw new ConfigException(L.l("<thread-max> ({0}) must be greater than zero.", (long)max));
        }
        this._threadMax = max;
    }

    @Configurable
    public void setThreadExecutorTaskMax(int max) {
        this._threadExecutorTaskMax = max;
    }

    @Configurable
    public void setThreadIdleMin(int min) {
        this._threadIdleMin = min;
    }

    @Configurable
    public void setThreadIdleMax(int max) {
        this._threadIdleMax = max;
    }

    @Configurable
    public void setThreadIdleTimeout(Period timeout) {
        this._threadIdleTimeout = timeout.getPeriod();
    }

    @Configurable
    public void setConnectionErrorPage(String errorPage) {
        this._servletContainer.setConnectionErrorPage(errorPage);
    }

    @Configurable
    public void setRootDirectory(Path path) {
        this._servletContainer.setRootDirectory(path);
        Vfs.setPwd((Path)path, (ClassLoader)this.getClassLoader());
    }

    @Configurable
    public void setRootDir(Path path) {
        this.setRootDirectory(path);
    }

    @Configurable
    public void setServerHeader(String serverHeader) {
        this._servletContainer.setServerHeader(serverHeader);
    }

    @Configurable
    public void setUrlLengthMax(int max) {
        this._servletContainer.setUrlLengthMax(max);
    }

    @Configurable
    public void setHeaderSizeMax(int max) {
        this._servletContainer.setHeaderSizeMax(max);
    }

    @Configurable
    public void setHeaderCountMax(int max) {
        this._servletContainer.setHeaderCountMax(max);
    }

    @Configurable
    public void setMaxUriLength(int max) {
        this.setUrlLengthMax(max);
    }

    @Configurable
    public void setIgnoreClientDisconnect(boolean isIgnore) {
        this._servletContainer.setIgnoreClientDisconnect(isIgnore);
    }

    @Configurable
    public void setSendfileEnable(boolean isEnable) {
        this._servletContainer.setSendfileEnable(isEnable);
    }

    @Configurable
    public void setSendfileMinLength(Bytes bytes) {
        this._servletContainer.setSendfileMinLength(bytes.getBytes());
    }

    @Configurable
    public void addWebAppDefault(WebAppConfig webAppConfig) {
        this._servletContainer.addWebAppDefault(webAppConfig);
    }

    @Configurable
    public void addEarDefault(EarConfig earConfig) {
        this._servletContainer.addEarDefault(earConfig);
    }

    @Configurable
    public void addHostDefault(HostConfig hostConfig) {
        this._servletContainer.addHostDefault(hostConfig);
    }

    @Configurable
    public HostExpandDeployGenerator createHostDeploy() {
        return this._servletContainer.createHostDeploy();
    }

    @Configurable
    public void addHostDeploy(HostExpandDeployGenerator deploy) {
        this._servletContainer.addHostDeploy(deploy);
    }

    @Configurable
    public void addHost(HostConfig host) {
        this._servletContainer.addHost(host);
    }

    @Configurable
    public RewriteDispatch createRewriteDispatch() {
        return this._servletContainer.createRewriteDispatch();
    }

    @Configurable
    public void add(DispatchRule rewrite) {
        this._servletContainer.add(rewrite);
    }

    @Configurable
    public AbstractProxyCache createProxyCache() throws ConfigException {
        AbstractProxyCache cache = this._servletContainer.createProxyCache();
        return cache;
    }

    @Configurable
    public AbstractProxyCache createCache() throws ConfigException {
        return this.createProxyCache();
    }

    @Configurable
    public void setAccessLog(AccessLog accessLog) {
        this._servletContainer.setAccessLog(accessLog);
    }

    @Configurable
    public void setAccessLogBufferSize(Bytes bufferSize) {
        this._servletContainer.setAccessLogBufferSize(bufferSize);
    }

    @Configurable
    public void setSessionCookie(String sessionCookie) {
        this._servletContainer.setSessionCookie(sessionCookie);
    }

    @Configurable
    public void setSSLSessionCookie(String cookie) {
        this._servletContainer.setSSLSessionCookie(cookie);
    }

    @Configurable
    public void setSessionUrlPrefix(String urlPrefix) {
        this._servletContainer.setSessionURLPrefix(urlPrefix);
    }

    @Configurable
    public void setAlternateSessionUrlPrefix(String urlPrefix) throws ConfigException {
        this._servletContainer.setAlternateSessionURLPrefix(urlPrefix);
    }

    @Configurable
    public void setUrlCharacterEncoding(String encoding) throws ConfigException {
        this._servletContainer.setURLCharacterEncoding(encoding);
    }

    public Object createPing() throws ConfigException {
        return this.createManagement().createPing();
    }

    public void addSelectManager(SelectManagerCompat selectManager) {
    }

    public void addErrorPage(ErrorPage errorPage) {
        this._servletContainer.addErrorPage(errorPage);
    }

    public void addLoadBalanceWeight(ConfigProgram program) {
    }

    public void setLoadBalanceWarmupTime(ConfigProgram program) {
    }

    @PostConstruct
    public void init() {
        if (this._threadIdleMax > 0 && this._threadMax > 0 && this._threadMax < this._threadIdleMax) {
            throw new ConfigException(L.l("<thread-idle-max> ({0}) must be less than <thread-max> ({1})", this._threadIdleMax, this._threadMax));
        }
        if (this._threadIdleMin > 0 && this._threadIdleMax > 0 && this._threadIdleMax < this._threadIdleMin) {
            throw new ConfigException(L.l("<thread-idle-min> ({0}) must be less than <thread-idle-max> ({1})", this._threadIdleMin, this._threadIdleMax));
        }
        if (this._threadMax > 0 && this._threadExecutorTaskMax > 0 && this._threadMax < this._threadExecutorTaskMax) {
            throw new ConfigException(L.l("<thread-executor-task-max> ({0}) must be less than <thread-max> ({1})", this._threadExecutorTaskMax, this._threadMax));
        }
        ThreadPool threadPool = ThreadPool.getThreadPool();
        if (this._threadMax > 0) {
            threadPool.setThreadMax(this._threadMax);
        }
        if (this._threadIdleMin > 0) {
            threadPool.setIdleMin(this._threadIdleMin);
        }
        if (this._threadIdleTimeout > 0L) {
            threadPool.setIdleTimeout(this._threadIdleTimeout);
        }
        threadPool.setExecutorTaskMax(this._threadExecutorTaskMax);
    }

    public static class SelectManagerCompat {
        private boolean _isEnable = true;

        public void setEnable(boolean isEnable) {
            this._isEnable = isEnable;
        }

        public boolean isEnable() {
            return this._isEnable;
        }
    }

    public class ServerVar {
        private final ClusterServer _server;

        public ServerVar(CloudServer server) {
            ClusterServer clusterServer = server.getData(ClusterServer.class);
            if (clusterServer == null) {
                throw new NullPointerException();
            }
            this._server = clusterServer;
        }

        public String getId() {
            String sid = (String)Config.getProperty((String)"rvar0");
            if (sid != null) {
                return sid;
            }
            return this._server.getId();
        }

        private int getPort(TcpPort port) {
            if (port == null) {
                return 0;
            }
            return port.getPort();
        }

        private String getAddress(TcpPort port) {
            if (port == null) {
                return null;
            }
            String address = port.getAddress();
            if (address == null || address.length() == 0) {
                address = "INADDR_ANY";
            }
            return address;
        }

        private TcpPort getFirstPort(String protocol, boolean isSSL) {
            ResinSystem resinSystem = ServletContainerConfig.this.getResinSystem();
            NetworkListenSystem listenService = (NetworkListenSystem)resinSystem.getService(NetworkListenSystem.class);
            for (TcpPort port : listenService.getListeners()) {
                if (!protocol.equals(port.getProtocolName()) || port.isSSL() != isSSL) continue;
                return port;
            }
            return null;
        }

        public String getAddress() {
            return ServletContainerConfig.this._selfServer.getAddress();
        }

        public int getPort() {
            return ServletContainerConfig.this._selfServer.getPort();
        }

        public String getHttpAddress() {
            return this.getAddress(this.getFirstPort("http", false));
        }

        public int getHttpPort() {
            return this.getPort(this.getFirstPort("http", false));
        }

        public String getHttpsAddress() {
            return this.getAddress(this.getFirstPort("http", true));
        }

        public int getHttpsPort() {
            return this.getPort(this.getFirstPort("http", true));
        }

        public Path getRoot() {
            Resin resin = Resin.getCurrent();
            return resin == null ? Vfs.getPwd() : resin.getRootDirectory();
        }
    }

    public class ClusterVar {
        public String getId() {
            return ServletContainerConfig.this._selfServer.getCluster().getId();
        }

        public Path getRoot() {
            return this.getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRootDirectory();
        }

        public Path getRootDirectory() {
            return ServletContainerConfig.this._servletContainer.getRootDirectory();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getId() + "]";
        }
    }
}

