/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.network.balance.ClientSocketFactory;

public final class OwnerServerTriad {
    private final ClusterServer _primary;
    private final ClusterServer _secondary;
    private final ClusterServer _tertiary;

    public OwnerServerTriad(ClusterServer primary, ClusterServer secondary, ClusterServer tertiary) {
        this._primary = primary;
        this._secondary = secondary;
        this._tertiary = tertiary;
    }

    public final ClusterServer getPrimary() {
        return this._primary;
    }

    public final ClusterServer getSecondary() {
        return this._secondary;
    }

    public final ClusterServer getTertiary() {
        return this._tertiary;
    }

    public final ClusterServer getPrimaryIfRemote() {
        ClusterServer primary = this._primary;
        if (primary.getClusterSocketPool() != null) {
            return primary;
        }
        return null;
    }

    public final ClusterServer getSecondaryIfRemote() {
        ClusterServer secondary = this._secondary;
        if (secondary == null) {
            return null;
        }
        if (secondary.getClusterSocketPool() != null) {
            return secondary;
        }
        return null;
    }

    public final ClusterServer getTertiaryIfRemote() {
        ClusterServer tertiary = this._tertiary;
        if (tertiary == null) {
            return null;
        }
        if (tertiary.getClusterSocketPool() != null) {
            return tertiary;
        }
        return null;
    }

    public final ClusterServer getPrimaryIfActiveRemote() {
        ClusterServer primary = this._primary;
        if (primary.isActiveRemote()) {
            return primary;
        }
        return null;
    }

    public final ClusterServer getSecondaryIfActiveRemote() {
        ClusterServer secondary = this._secondary;
        if (secondary == null) {
            return null;
        }
        if (secondary.isActiveRemote()) {
            return secondary;
        }
        return null;
    }

    public final ClusterServer getTertiaryIfActiveRemote() {
        ClusterServer tertiary = this._tertiary;
        if (tertiary == null) {
            return null;
        }
        if (tertiary.isActiveRemote()) {
            return tertiary;
        }
        return null;
    }

    public ClusterServer getActiveServer(ClusterServer oldServer) {
        ClientSocketFactory pool;
        ClusterServer server = this._primary;
        ClientSocketFactory clientSocketFactory = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this._secondary;
        ClientSocketFactory clientSocketFactory2 = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this._tertiary;
        ClientSocketFactory clientSocketFactory3 = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && pool.isActive() && server != oldServer) {
            return server;
        }
        server = this._primary;
        if (server != null && server.isHeartbeatActive() && (pool = server.getClusterSocketPool()) != null && server != oldServer) {
            return server;
        }
        server = this._secondary;
        if (server != null && server.isHeartbeatActive() && (pool = server.getClusterSocketPool()) != null && server != oldServer) {
            return server;
        }
        server = this._tertiary;
        if (server != null && server.isHeartbeatActive() && (pool = server.getClusterSocketPool()) != null && server != oldServer) {
            return server;
        }
        return null;
    }

    public ClusterServer getActiveOrSelfServer(ClusterServer oldServer) {
        ClientSocketFactory pool;
        ClusterServer server = this._primary;
        if (server != null && ((pool = server.getClusterSocketPool()) == null || pool.isActive() && server != oldServer)) {
            return server;
        }
        server = this._secondary;
        if (server != null && ((pool = server.getClusterSocketPool()) == null || pool.isActive() && server != oldServer)) {
            return server;
        }
        server = this._tertiary;
        if (server != null && ((pool = server.getClusterSocketPool()) == null || pool.isActive() && server != oldServer)) {
            return server;
        }
        server = this._primary;
        ClientSocketFactory clientSocketFactory = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this._secondary;
        ClientSocketFactory clientSocketFactory2 = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        server = this._tertiary;
        ClientSocketFactory clientSocketFactory3 = pool = server != null ? server.getClusterSocketPool() : null;
        if (pool != null && server != oldServer) {
            return server;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[primary=" + this._primary + ",seconary=" + this._secondary + ",tertiary=" + this._tertiary + "]";
    }
}

