/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.proxy.ProxyActor;
import com.caucho.cloud.bam.BamSystem;
import com.caucho.config.Service;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.admin.ManagerActor;
import com.caucho.server.admin.ManagerProxyActor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;

@Service
public class ManagerService {
    private static EnvironmentLocal<ManagerService> _localManagerService = new EnvironmentLocal();
    private AtomicBoolean _isInit = new AtomicBoolean();
    private ManagerActor _managerActor;
    private ManagerProxyActor _managerProxyBean;

    public ManagerService() {
        if (_localManagerService.get() == null) {
            this._managerActor = new ManagerActor();
            this._managerProxyBean = new ManagerProxyActor();
            _localManagerService.set((Object)this);
        }
    }

    public void setHprofDir(String dir) {
        this.getCurrentManagerActor().setHprofDir(dir);
    }

    public ManagerActor getCurrentManagerActor() {
        return ((ManagerService)_localManagerService.get()).getManagerActor();
    }

    private ManagerActor getManagerActor() {
        return this._managerActor;
    }

    @PostConstruct
    public void init() {
        ((ManagerService)_localManagerService.get()).initActors();
    }

    private void initActors() {
        if (this._isInit.getAndSet(true)) {
            return;
        }
        ManagedBroker broker = BamSystem.getCurrentBroker();
        ManagerActor managerActor = this._managerActor;
        managerActor.init();
        ProxyActor<ManagerProxyActor> actor = new ProxyActor<ManagerProxyActor>(this._managerProxyBean, "manager-proxy@resin.caucho", broker);
        String address = actor.getAddress();
        MultiworkerMailbox mailbox = new MultiworkerMailbox(actor.getAddress(), actor, broker, 2);
        broker.addMailbox(address, mailbox);
    }
}

