/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.Service;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.deploy.DeployActor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Service
public class DeployService {
    private static final Logger log = Logger.getLogger(DeployService.class.getName());
    private static EnvironmentLocal<DeployActor> _localDeployActor = new EnvironmentLocal();

    public DeployService() {
        if (_localDeployActor.get() == null) {
            _localDeployActor.set((Object)this.createDeployActor());
        }
    }

    public DeployActor getCurrentDeployActor() {
        return (DeployActor)_localDeployActor.get();
    }

    @PostConstruct
    public void init() {
        ((DeployActor)_localDeployActor.get()).init();
    }

    private DeployActor createDeployActor() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName("com.caucho.server.deploy.ProDeployActor", false, loader);
            return (DeployActor)cl.newInstance();
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.toString(), e);
            return new DeployActor();
        }
    }
}

