/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.Service;
import com.caucho.security.AbstractRoleMap;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import java.security.Principal;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@Service
public class XmlRoleMap
extends AbstractRoleMap {
    private static final Logger log = Logger.getLogger(XmlRoleMap.class.getName());
    private Path _path;
    private Hashtable<String, Role> _roleMap = new Hashtable();

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void addRole(Role role) {
        this._roleMap.put(role.getName(), role);
    }

    @Override
    @PostConstruct
    public synchronized void init() {
        super.init();
        this.reload();
    }

    @Override
    public Boolean isUserInRole(String roleName, Principal user) {
        Role role = this._roleMap.get(roleName);
        if (role == null) {
            return null;
        }
        String name = user.getName();
        if (role.containsUser(name)) {
            return Boolean.TRUE;
        }
        return null;
    }

    public synchronized void reload() {
        if (this._path == null) {
            return;
        }
        try {
            CurrentTime.getCurrentTime();
            new Depend(this._path);
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " loading users from " + this._path);
            }
            this._roleMap = new Hashtable();
            new Config().configureBean((Object)this, this._path);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public static class Role {
        private String _name;
        private HashSet<String> _userSet = new HashSet();
        private HashSet<String> _groupSet = new HashSet();

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void addUser(String user) {
            this._userSet.add(user);
        }

        public boolean containsUser(String user) {
            return this._userSet.contains(user);
        }

        public void addGroup(String group) {
            this._groupSet.add(group);
        }
    }
}

