/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.security.RoleMap;
import java.security.Principal;
import java.util.ArrayList;

public class RoleMapManager {
    private static final EnvironmentLocal<RoleMapManager> _localManager = new EnvironmentLocal();
    private final String _id;
    private final RoleMapManager _parent;
    private ArrayList<RoleMap> _roleMapList = new ArrayList();

    private RoleMapManager(RoleMapManager parent) {
        this._id = Environment.getEnvironmentName();
        this._parent = parent;
    }

    public static RoleMapManager getCurrent() {
        return (RoleMapManager)_localManager.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoleMapManager create() {
        EnvironmentLocal<RoleMapManager> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            RoleMapManager manager = (RoleMapManager)_localManager.getLevel();
            if (manager == null) {
                RoleMapManager parent = (RoleMapManager)_localManager.get();
                manager = new RoleMapManager(parent);
                _localManager.set((Object)manager);
            }
            return manager;
        }
    }

    public void addRoleMap(RoleMap roleMap) {
        this._roleMapList.add(roleMap);
    }

    public Boolean isUserInRole(String role, Principal user) {
        int size = this._roleMapList.size();
        for (int i = 0; i < size; ++i) {
            RoleMap roleMap = this._roleMapList.get(i);
            Boolean result = roleMap.isUserInRole(role, user);
            if (result == null) continue;
            return result;
        }
        if (this._parent != null) {
            return this._parent.isUserInRole(role, user);
        }
        if (size > 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

