/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Service;
import com.caucho.config.types.InitParam;
import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.PasswordUser;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;

@Service
public class LdapAuthenticator
extends AbstractAuthenticator {
    private static final Logger log = Logger.getLogger(LdapAuthenticator.class.getName());
    private String _host = "ldap://localhost:389";
    private String _userAttribute = "uid";
    private String _passwordAttribute = "userPassword";
    private String _roleAttribute;
    private String _baseDn;
    private String _dnPrefix;
    private String _dnSuffix;
    private Hashtable<String, String> _jndiEnv = new Hashtable();

    public LdapAuthenticator() {
        this._jndiEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this._jndiEnv.put("java.naming.provider.url", "ldap://localhost:389");
    }

    public void setDNPrefix(String prefix) {
        this._dnPrefix = prefix;
    }

    public void setDNSuffix(String suffix) {
        this._dnSuffix = suffix;
    }

    public void setBaseDn(String baseDn) {
        this._baseDn = baseDn;
    }

    public void setHost(String host) {
        if (!host.startsWith("ldap:")) {
            host = "ldap://" + host;
        }
        this.setURL(host);
    }

    public void addJNDIEnv(InitParam init) {
        this._jndiEnv.putAll(init.getParameters());
    }

    public void setURL(String url) {
        this._jndiEnv.put("java.naming.provider.url", url);
    }

    public void setUserAttribute(String user) {
        this._userAttribute = user;
    }

    public void setPasswordAttribute(String password) {
        this._passwordAttribute = password;
    }

    public void setRoleAttribute(String role) {
        this._roleAttribute = role;
    }

    public void setSecurityAuthentication(String type) {
        this._jndiEnv.put("java.naming.security.authentication", type);
    }

    public void setSecurityPrincipal(String user) {
        this._jndiEnv.put("java.naming.security.principal", user);
    }

    public void setSecurityCredentials(String password) {
        this._jndiEnv.put("java.naming.security.credentials", password);
    }

    @Override
    @PostConstruct
    public void init() throws ServletException {
        super.init();
    }

    @Override
    protected PasswordUser getPasswordUser(String userName) {
        try {
            String roleSet;
            Attribute roleAttr;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.putAll(this._jndiEnv);
            InitialDirContext ic = new InitialDirContext(env);
            String query = this._userAttribute + '=' + userName;
            if (this._baseDn != null && !this._baseDn.equals("")) {
                query = this._baseDn + ',' + query;
            }
            if (this._dnPrefix != null && !this._dnPrefix.equals("")) {
                query = this._dnPrefix + ',' + query;
            }
            if (this._dnSuffix != null && !this._dnSuffix.equals("")) {
                query = query + ',' + this._dnSuffix;
            }
            Attributes attributes = ic.getAttributes(query);
            if (log.isLoggable(Level.FINE)) {
                log.fine("ldap-authenticator: " + query + "->" + (attributes != null));
            }
            if (attributes == null) {
                return null;
            }
            Attribute passwordAttr = attributes.get(this._passwordAttribute);
            String ldapPassword = (String)passwordAttr.get();
            if (passwordAttr == null) {
                return null;
            }
            String[] roles = null;
            if (this._roleAttribute != null && (roleAttr = attributes.get(this._roleAttribute)) != null && (roleSet = (String)roleAttr.get()) != null) {
                roles = roleSet.split("[, ]+");
            }
            if (roles == null) {
                roles = new String[]{"user"};
            }
            BasicPrincipal principal = new BasicPrincipal(userName);
            boolean isDisabled = false;
            boolean isAnonymous = false;
            return new PasswordUser(principal, ldapPassword.toCharArray(), isDisabled, isAnonymous, roles);
        }
        catch (NamingException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }
}

