/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.Configurable;
import com.caucho.rewrite.RequestPredicate;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@Configurable
public class IfUserInRole
implements RequestPredicate {
    private static final Logger log = Logger.getLogger(IfUserInRole.class.getName());
    private String[] _roles = new String[0];

    @Configurable
    public void addRole(String role) {
        String[] newRoles = new String[this._roles.length + 1];
        System.arraycopy(this._roles, 0, newRoles, 0, this._roles.length);
        newRoles[this._roles.length] = role;
        this._roles = newRoles;
    }

    @Override
    public boolean isMatch(HttpServletRequest request) {
        Principal user = request.getUserPrincipal();
        if (user == null) {
            return false;
        }
        for (String role : this._roles) {
            if (role.equals("*")) {
                return true;
            }
            if (!request.isUserInRole(role)) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finer("IfUserInRole[" + role + "] " + user);
            }
            return true;
        }
        if (this._roles.length == 0) {
            return true;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " does not match " + user);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        for (int i = 0; i < this._roles.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this._roles[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

