/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.resin;

import com.caucho.jmx.Jmx;
import com.caucho.quercus.QuercusModuleException;
import com.caucho.quercus.annotation.Optional;
import com.caucho.quercus.env.ArrayValue;
import com.caucho.quercus.env.ArrayValueImpl;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.lib.resin.MBean;
import com.caucho.server.admin.RemoteMBeanConnectionFactory;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanServer {
    private static final L10N L = new L10N(MBeanServer.class);
    private static final Logger log = Logger.getLogger(MBeanServer.class.getName());
    private static final Comparator<ObjectName> OBJECTNAME_COMPARATOR = new Comparator<ObjectName>(){

        @Override
        public int compare(ObjectName o1, ObjectName o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getCanonicalName().compareTo(o2.getCanonicalName());
        }
    };
    private final String _serverId;
    private MBeanServerConnection _server;

    public MBeanServer(@Optional String serverId) {
        this._serverId = serverId;
        this.getServer();
    }

    public MBean lookup(Env env, @Optional String name) {
        try {
            if (name == null || name.length() == 0) {
                return null;
            }
            ObjectName objectName = Jmx.getObjectName((String)name);
            if (this.getServer().isRegistered(objectName)) {
                return new MBean(this._server, objectName);
            }
            return null;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException(L.l("'{0}' is an invalid JMX name.\n{1}", (Object)name, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }

    public ArrayValue query(Env env, String pattern) {
        try {
            ArrayValueImpl values = new ArrayValueImpl();
            ObjectName patternObjectName = new ObjectName(pattern);
            Set<ObjectName> objectNames = this.getServer().queryNames(patternObjectName, null);
            if (objectNames == null) {
                return values;
            }
            TreeSet<ObjectName> sortedObjectNames = new TreeSet<ObjectName>(OBJECTNAME_COMPARATOR);
            sortedObjectNames.addAll(objectNames);
            for (ObjectName objectName : sortedObjectNames) {
                values.put(env.wrapJava((Object)new MBean(this._server, objectName)));
            }
            return values;
        }
        catch (MalformedObjectNameException e) {
            throw new QuercusModuleException((Throwable)e);
        }
        catch (IOException e) {
            throw new QuercusModuleException((Throwable)e);
        }
    }

    private final MBeanServerConnection getServer() {
        if (this._server == null) {
            try {
                this._server = this.lookupServer(this._serverId);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        return this._server;
    }

    private MBeanServerConnection lookupServer(String serverId) {
        if (serverId == null || "".equals(serverId) || ServletService.getCurrent().getServerId().equals(serverId)) {
            return Jmx.getGlobalMBeanServer();
        }
        return RemoteMBeanConnectionFactory.create(serverId);
    }

    public String toString() {
        return "MBeanServer[" + this._server + "]";
    }
}

