/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.network.listen.TcpPort;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListenService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY_LISTEN = 2000;
    public static final int START_PRIORITY_CLUSTER = 2100;
    private static final L10N L = new L10N(ListenService.class);
    private static final Logger log = Logger.getLogger(ListenService.class.getName());
    private final ResinSystem _server;
    private final ArrayList<TcpPort> _listeners = new ArrayList();
    private final ContainerProgram _listenDefaults = new ContainerProgram();
    private final Lifecycle _lifecycle = new Lifecycle();
    private AtomicBoolean _isStartedListeners = new AtomicBoolean();

    private ListenService() {
        this._server = ResinSystem.getCurrent();
    }

    public static ListenService createAndAddService() {
        ResinSystem system = ListenService.preCreate(ListenService.class);
        ListenService service = new ListenService();
        system.addService(ListenService.class, (ResinSubSystem)service);
        return service;
    }

    public static ListenService getCurrent() {
        return (ListenService)ResinSystem.getCurrentService(ListenService.class);
    }

    public TcpPort createListener() {
        TcpPort listener = new TcpPort();
        this.applyListenerDefaults(listener);
        return listener;
    }

    public void addListener(TcpPort listener) {
        try {
            if (this._listeners.contains(listener)) {
                throw new IllegalStateException(L.l("listener '{0}' has already been registered", (Object)listener));
            }
            this._listeners.add(listener);
            if (this._lifecycle.getState().isAfterStarting()) {
                listener.bind();
                listener.start();
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public Collection<TcpPort> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    private void applyListenerDefaults(TcpPort port) {
        this._listenDefaults.configure((Object)port);
    }

    public int getStartPriority() {
        return 2000;
    }

    public void start() throws Exception {
        this.bindListeners();
        this.startListeners();
    }

    public void stop() throws Exception {
        ArrayList<TcpPort> listeners = this._listeners;
        for (int i = 0; i < listeners.size(); ++i) {
            TcpPort listener = listeners.get(i);
            try {
                listener.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindListeners() throws Exception {
        if (this._isStartedListeners.getAndSet(true)) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this._server.getClassLoader());
            ArrayList<TcpPort> listeners = this._listeners;
            boolean isFirst = true;
            for (int i = 0; i < listeners.size(); ++i) {
                TcpPort listener = listeners.get(i);
                if (listener.isAfterBind()) continue;
                if (isFirst) {
                    log.info("");
                    isFirst = false;
                }
                listener.bind();
            }
            if (!isFirst) {
                log.info("");
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListeners() throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this._server.getClassLoader());
            ArrayList<TcpPort> listeners = this._listeners;
            for (int i = 0; i < listeners.size(); ++i) {
                TcpPort listener = listeners.get(i);
                listener.start();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }
}

