/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.broker.MessageBroker;
import com.caucho.message.tourmaline.AbstractNautilusEndpoint;
import com.caucho.message.tourmaline.NautilusPublish;
import com.caucho.message.tourmaline.NautilusReceive;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NautilusServerEndpoint
extends AbstractNautilusEndpoint {
    private static final Logger log = Logger.getLogger(NautilusServerEndpoint.class.getName());
    private MessageBroker _broker;
    private NautilusPublish _publish;
    private NautilusReceive _receive;

    NautilusServerEndpoint(MessageBroker broker) {
        this._broker = broker;
    }

    MessageBroker getBroker() {
        return this._broker;
    }

    NautilusPublish getPublish() {
        return this._publish;
    }

    @Override
    protected void publishStart(InputStream is) throws IOException {
        String line;
        ReadStream in = Vfs.openRead((InputStream)is);
        NautilusPublish publish = new NautilusPublish(this);
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(58);
            if (p < 0) continue;
            String key = line.substring(0, p).trim();
            String value = line.substring(p + 1).trim();
            publish.add(key, value);
        }
        this.publishStart(publish);
    }

    private void publishStart(NautilusPublish publish) {
        this._publish = publish;
        publish.init();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " attach-sender " + publish);
        }
    }

    @Override
    protected void receiveStart(InputStream is) throws IOException {
        String line;
        ReadStream in = Vfs.openRead((InputStream)is);
        NautilusReceive receive = new NautilusReceive(this);
        while ((line = in.readLine()) != null) {
            int p = line.indexOf(58);
            if (p < 0) continue;
            String key = line.substring(0, p).trim();
            String value = line.substring(p + 1).trim();
            receive.add(key, value);
        }
        this.receiveStart(receive);
    }

    private void receiveStart(NautilusReceive receive) {
        this._receive = receive;
        receive.init();
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " attach-receiver " + receive);
        }
    }

    @Override
    protected void onSend(InputStream is) throws IOException {
        this._publish.publish(is);
    }

    @Override
    protected void onFlow(int credit, long sequence) {
        this._receive.flow(sequence, credit);
    }

    @Override
    protected void onClose() {
        NautilusPublish publish = this._publish;
        this._publish = null;
        if (publish != null) {
            publish.close();
        }
        NautilusReceive receiver = this._receive;
        this._receive = null;
        if (receiver != null) {
            receiver.close();
        }
    }
}

