/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.tourmaline.NautilusCode;
import com.caucho.websocket.AbstractWebSocketListener;
import com.caucho.websocket.WebSocketContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class AbstractNautilusEndpoint
extends AbstractWebSocketListener {
    private static final Command[] _dispatch = new Command[NautilusCode.CLOSE.ordinal() + 1];
    private WebSocketContext _wsContext;

    AbstractNautilusEndpoint() {
    }

    final WebSocketContext getContext() {
        return this._wsContext;
    }

    @Override
    public void onStart(WebSocketContext context) throws IOException {
        this._wsContext = context;
    }

    @Override
    public void onReadBinary(WebSocketContext context, InputStream is) throws IOException {
        int code = is.read();
        _dispatch[code].onMessage(this, is);
    }

    @Override
    public void onClose(WebSocketContext context) throws IOException {
        this.onClose();
    }

    protected void publishStart(InputStream is) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected void receiveStart(InputStream is) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected void onSend(InputStream is) throws IOException {
    }

    private final void onFlow(InputStream is) throws IOException {
        int credit = this.readInt(is);
        long sequence = this.readLong(is);
        this.onFlow(credit, sequence);
    }

    protected void onFlow(int credit, long sequence) {
    }

    protected void onClose() {
    }

    protected final int readInt(InputStream is) throws IOException {
        return (is.read() << 24) + (is.read() << 16) + (is.read() << 8) + is.read();
    }

    protected final long readLong(InputStream is) throws IOException {
        return ((long)is.read() << 56) + ((long)is.read() << 48) + ((long)is.read() << 40) + ((long)is.read() << 32) + ((long)is.read() << 24) + ((long)is.read() << 16) + ((long)is.read() << 8) + (long)is.read();
    }

    protected void writeInt(OutputStream os, int value) throws IOException {
        os.write(value >> 24);
        os.write(value >> 16);
        os.write(value >> 8);
        os.write(value);
    }

    protected void writeLong(OutputStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    protected void write(OutputStream os, String msg) throws IOException {
        int len = msg.length();
        for (int i = 0; i < len; ++i) {
            os.write(msg.charAt(i));
        }
    }

    public void close() {
        WebSocketContext cxt = this._wsContext;
        this._wsContext = null;
        if (cxt != null) {
            cxt.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static {
        AbstractNautilusEndpoint._dispatch[NautilusCode.NULL.ordinal()] = new NullCommand();
        AbstractNautilusEndpoint._dispatch[NautilusCode.PUBLISH.ordinal()] = new PublishCommand();
        AbstractNautilusEndpoint._dispatch[NautilusCode.RECEIVE.ordinal()] = new ReceiveCommand();
        AbstractNautilusEndpoint._dispatch[NautilusCode.SEND.ordinal()] = new SendCommand();
        AbstractNautilusEndpoint._dispatch[NautilusCode.FLOW.ordinal()] = new FlowCommand();
    }

    private static class FlowCommand
    extends Command {
        private FlowCommand() {
        }

        @Override
        void onMessage(AbstractNautilusEndpoint endpoint, InputStream is) throws IOException {
            endpoint.onFlow(is);
        }
    }

    private static class SendCommand
    extends Command {
        private SendCommand() {
        }

        @Override
        void onMessage(AbstractNautilusEndpoint endpoint, InputStream is) throws IOException {
            endpoint.onSend(is);
        }
    }

    private static class ReceiveCommand
    extends Command {
        private ReceiveCommand() {
        }

        @Override
        void onMessage(AbstractNautilusEndpoint endpoint, InputStream is) throws IOException {
            endpoint.receiveStart(is);
        }
    }

    private static class PublishCommand
    extends Command {
        private PublishCommand() {
        }

        @Override
        void onMessage(AbstractNautilusEndpoint endpoint, InputStream is) throws IOException {
            endpoint.publishStart(is);
        }
    }

    private static class NullCommand
    extends Command {
        private NullCommand() {
        }

        @Override
        void onMessage(AbstractNautilusEndpoint endpoint, InputStream is) throws IOException {
        }
    }

    private static abstract class Command {
        private Command() {
        }

        abstract void onMessage(AbstractNautilusEndpoint var1, InputStream var2) throws IOException;
    }
}

