/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.stomp;

import com.caucho.message.stomp.StompClient;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class StompClientReceiver
implements Runnable {
    private static final L10N L = new L10N(StompClientReceiver.class);
    private static final Logger log = Logger.getLogger(StompClientReceiver.class.getName());
    private StompClient _client;
    private ReadStream _is;
    private volatile boolean _isClosed;
    private boolean _isConnected;

    StompClientReceiver(StompClient client, ReadStream is) {
        this._client = client;
        this._is = is;
    }

    void close() {
        this._isClosed = true;
    }

    @Override
    public void run() {
        try {
            while (!this._isClosed && this.readMessage()) {
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
    }

    boolean isConnected() {
        return this._isConnected && !this._isClosed;
    }

    boolean readMessage() throws IOException {
        int ch;
        int p;
        String line;
        String cmd = this._is.readLine();
        if (this._isClosed) {
            return false;
        }
        if (cmd == null) {
            throw new IOException("EOF:");
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        while ((line = this._is.readLine()) != null && !"".equals(line) && (p = line.indexOf(58)) >= 0) {
            String key = line.substring(0, p);
            String value = line.substring(p + 1);
            headers.put(key, value);
        }
        StringBuffer sb = new StringBuffer();
        while ((ch = this._is.read()) > 0) {
            sb.append((char)ch);
        }
        String body = sb.toString();
        if (ch != 0) {
            throw new IOException("Unexpected body");
        }
        if ("CONNECTED".equals(cmd)) {
            this._isConnected = true;
            return true;
        }
        if ("MESSAGE".equals(cmd)) {
            this.addMessage(headers, body);
            return true;
        }
        System.out.println("CMDR: " + cmd + " " + headers + "\n" + body);
        throw new IOException(L.l("unknown command: " + cmd));
    }

    private void addMessage(HashMap<String, String> headers, String body) {
        String subscription = headers.get("subscription");
        this._client.addMessage(subscription, headers, body);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._client + "]";
    }
}

