/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.XmlIfTag;
import com.caucho.util.L10N;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlForEachTag
extends TagSupport
implements IterationTag {
    private static L10N L = new L10N(XmlIfTag.class);
    private Expr _select;
    private String _var;
    private String _varStatus;
    private Node _oldEnv;
    private int _begin;
    private int _end = 0x3FFFFFFF;
    private int _step = 1;
    private int _count;
    private Iterator _iterator;
    private Object _current;

    public void setSelect(Expr select) {
        this._select = select;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setVarStatus(String varStatus) {
        this._varStatus = varStatus;
    }

    public void setBegin(int begin) {
        this._begin = begin;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setStep(int step) {
        this._step = step;
    }

    public int doStartTag() throws JspException {
        try {
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            Env env = XPath.createEnv();
            env.setVarEnv(pageContext.getVarEnv());
            this._oldEnv = pageContext.getNodeEnv();
            Object obj = this._select.evalObject(this._oldEnv, (ExprEnvironment)env);
            env.free();
            if (obj == null) {
                return 0;
            }
            if (obj instanceof Iterator) {
                this._iterator = (Iterator)obj;
            } else if (obj instanceof Collection) {
                this._iterator = ((Collection)obj).iterator();
            } else if (obj instanceof NodeList) {
                NodeList nodeList = (NodeList)obj;
                ArrayList<Node> list = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    list.add(nodeList.item(i));
                }
                this._iterator = list.iterator();
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(obj);
                this._iterator = list.iterator();
            }
            this._count = 0;
            while (this._count < this._begin && this._iterator.hasNext()) {
                this._iterator.next();
                ++this._count;
            }
            if (this._end < this._count || !this._iterator.hasNext()) {
                return 0;
            }
            Object value = this._current = this._iterator.next();
            ++this._count;
            if (this._var != null) {
                pageContext.setAttribute(this._var, value);
            }
            if (this._varStatus != null) {
                pageContext.setAttribute(this._varStatus, new Status());
            }
            if (value instanceof Node) {
                pageContext.setNodeEnv((Node)value);
            }
            return 1;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doAfterBody() throws JspException {
        PageContextImpl pageContext = (PageContextImpl)this.pageContext;
        int step = this._step;
        Object value = null;
        do {
            if (this._end < this._count || !this._iterator.hasNext()) {
                pageContext.setNodeEnv(this._oldEnv);
                if (this._var != null) {
                    pageContext.removeAttribute(this._var);
                }
                if (this._varStatus != null) {
                    pageContext.removeAttribute(this._varStatus);
                }
                return 0;
            }
            value = this._iterator.next();
            ++this._count;
        } while (--step > 0);
        this._current = value;
        if (this._var != null) {
            pageContext.setAttribute(this._var, value);
        }
        if (value instanceof Node) {
            pageContext.setNodeEnv(value);
        }
        return 2;
    }

    class Status
    implements LoopTagStatus {
        Status() {
        }

        public Object getCurrent() {
            return XmlForEachTag.this._current;
        }

        public int getIndex() {
            return XmlForEachTag.this._count;
        }

        public int getCount() {
            return XmlForEachTag.this._count;
        }

        public boolean isFirst() {
            return XmlForEachTag.this._count == XmlForEachTag.this._begin + 1;
        }

        public boolean isLast() {
            return XmlForEachTag.this._count == XmlForEachTag.this._end || !XmlForEachTag.this._iterator.hasNext();
        }

        public Integer getBegin() {
            return XmlForEachTag.this._begin;
        }

        public Integer getEnd() {
            return XmlForEachTag.this._end;
        }

        public Integer getStep() {
            return XmlForEachTag.this._step;
        }

        public String toString() {
            return "XmlForEachTag$Status[]";
        }
    }
}

