/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.util.L10N;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public class BundleTag
extends TagSupport
implements TryCatchFinally {
    private static L10N L = new L10N(BundleTag.class);
    private Expr _basenameExpr;
    private Expr _prefixExpr;
    private Object _oldBundle;
    private Object _oldPrefix;

    public void setBasename(Expr basename) {
        this._basenameExpr = basename;
    }

    public void setPrefix(Expr prefix) {
        this._prefixExpr = prefix;
    }

    public int doStartTag() throws JspException {
        PageContextImpl pc = (PageContextImpl)this.pageContext;
        String basename = this._basenameExpr.evalString(pc.getELContext());
        this._oldBundle = pc.getAttribute("caucho.bundle");
        this._oldPrefix = pc.getAttribute("caucho.bundle.prefix");
        LocalizationContext bundle = pc.getBundle(basename);
        pc.setAttribute("caucho.bundle", bundle);
        if (this._prefixExpr != null) {
            String prefix = this._prefixExpr.evalString(pc.getELContext());
            pc.setAttribute("caucho.bundle.prefix", prefix);
        } else if (this._oldPrefix != null) {
            pc.removeAttribute("caucho.bundle.prefix");
        }
        return 1;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this._oldBundle == null) {
            this.pageContext.removeAttribute("caucho.bundle");
        } else {
            this.pageContext.setAttribute("caucho.bundle", this._oldBundle);
        }
        if (this._oldPrefix == null) {
            this.pageContext.removeAttribute("caucho.bundle.prefix");
        } else {
            this.pageContext.setAttribute("caucho.bundle.prefix", this._oldPrefix);
        }
    }

    public static Object setBundle(String baseName, PageContextImpl pc) {
        Object oldBundle = pc.getAttribute("caucho.bundle");
        LocalizationContext bundle = pc.getBundle(baseName);
        pc.setAttribute("caucho.bundle", bundle);
        return oldBundle;
    }
}

