/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.java.JavaTagGenerator;
import com.caucho.jsp.java.JspJavaWriter;
import com.caucho.jsp.java.JspNode;
import com.caucho.util.L10N;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.QName;
import java.io.IOException;
import java.util.Locale;

public class JspDirectiveTag
extends JspNode {
    private static final QName IMPORT = new QName("import");
    private static final QName DISPLAY_NAME = new QName("display-name");
    private static final QName BODY_CONTENT = new QName("body-content");
    private static final QName DYNAMIC_ATTRIBUTES = new QName("dynamic-attributes");
    private static final QName SMALL_ICON = new QName("small-icon");
    private static final QName LARGE_ICON = new QName("large-icon");
    private static final QName DESCRIPTION = new QName("description");
    private static final QName EXAMPLE = new QName("example");
    private static final QName LANGUAGE = new QName("language");
    private static final QName PAGE_ENCODING = new QName("pageEncoding");
    private static final QName IS_EL_IGNORED = new QName("isELIgnored");
    private static final QName DEFERRED_AS_LITERAL = new QName("deferredSyntaxAllowedAsLiteral");
    private static final QName TRIM_WHITESPACES = new QName("trimDirectiveWhitespaces");
    private static final QName IS_VELOCITY_ENABLED = new QName("isVelocityEnabled");
    static final L10N L = new L10N(JspDirectiveTag.class);
    private String _import;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addAttribute(QName name, String value) throws JspParseException {
        if (!this._gen.isTag()) {
            throw this.error(L.l("@tag directive is only allowed in tag files"));
        }
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        if (IS_EL_IGNORED.equals((Object)name)) {
            boolean isIgnored = value.equals("true");
            if (this._parseState.isELIgnoredPageSpecified() && isIgnored != this._parseState.isELIgnored()) {
                throw this.error(L.l("isELIgnored values conflict"));
            }
            this._parseState.setELIgnored(isIgnored);
            this._parseState.setELIgnoredPageSpecified(true);
            return;
        } else if (IS_VELOCITY_ENABLED.equals((Object)name)) {
            this._parseState.setVelocityEnabled(value.equals("true"));
            return;
        } else if (PAGE_ENCODING.equals((Object)name)) {
            String oldEncoding = this._parseState.getPageEncoding();
            if (oldEncoding != null && !value.equals(oldEncoding)) {
                throw this.error(L.l("pageEncoding '{0}' conflicts with previous value of pageEncoding '{1}'.  Check the .jsp and any included .jsp files for conflicts.", (Object)value, (Object)oldEncoding));
            }
            this._parseState.setPageEncoding(value);
            this._parseState.setCharEncoding(value);
            return;
        } else {
            if (LANGUAGE.equals((Object)name)) {
                if (value.equals("java")) return;
                throw this.error(L.l("'{0}' is not supported as a JSP scripting language.", (Object)value));
            }
            if (IMPORT.equals((Object)name)) {
                this._import = value;
                this._parseState.addImport(value);
                return;
            } else if (DISPLAY_NAME.equals((Object)name)) {
                String oldValue = gen.getDisplayName();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag display-name '{0}' conflicts with previous value '{1}'.  The display-name attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                gen.setDisplayName(value);
                return;
            } else if (SMALL_ICON.equals((Object)name)) {
                String oldValue = gen.getSmallIcon();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag small-icon '{0}' conflicts with previous value '{1}'.  The small-icon attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                gen.setSmallIcon(value);
                return;
            } else if (LARGE_ICON.equals((Object)name)) {
                String oldValue = gen.getLargeIcon();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag large-icon '{0}' conflicts with previous value '{1}'.  The large-icon attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                gen.setLargeIcon(value);
                return;
            } else if (DESCRIPTION.equals((Object)name)) {
                String oldValue = gen.getDescription();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag description '{0}' conflicts with previous value '{1}'.  The description attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                gen.setDescription(value);
                return;
            } else if (EXAMPLE.equals((Object)name)) {
                String oldValue = gen.getExample();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag example '{0}' conflicts with previous value '{1}'.  The example attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                gen.setExample(value);
                return;
            } else if (DYNAMIC_ATTRIBUTES.equals((Object)name)) {
                String oldValue = gen.getDynamicAttributes();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag dynamic-attributes '{0}' conflicts with previous value '{1}'.  The dynamic-attributes attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                if (gen.findAttribute(value) != null) {
                    throw this.error(L.l("@tag dynamic-attributes '{0}' conflicts with an attribute.", (Object)value));
                }
                if (gen.findVariable(value) != null) {
                    throw this.error(L.l("@tag dynamic-attributes '{0}' conflicts with a variable.", (Object)value));
                }
                gen.setDynamicAttributes(value);
                return;
            } else if (BODY_CONTENT.equals((Object)name)) {
                String oldValue = gen.getBodyContent();
                if (oldValue != null && !oldValue.equals(value)) {
                    throw this.error(L.l("@tag body-content '{0}' conflicts with previous value '{1}'.  The body-content attribute may only be specified once.", (Object)value, (Object)oldValue));
                }
                if (!(value.equals("scriptless") || value.equals("tagdependent") || value.equals("empty"))) {
                    throw this.error(L.l("'{0}' is an unknown body-content value for the JSP tag directive attribute.  'scriptless', 'tagdependent', and 'empty' are the allowed values.", (Object)value));
                }
                gen.setBodyContent(value);
                return;
            } else if (DEFERRED_AS_LITERAL.equals((Object)name)) {
                this._parseState.setDeferredSyntaxAllowedAsLiteral(value.equals("true"));
                return;
            } else {
                if (!TRIM_WHITESPACES.equals((Object)name)) throw this.error(L.l("'{0}' is an unknown JSP tag directive attribute.  The valid attributes are: body-content, deferredSyntaxAllowedAsLiteral, display-name, dynamic-attributes, example, isELIgnored, language, large-icon, pageEncoding, small-icon, trimDirectiveWhitespaces.", (Object)name.getName()));
                if (value.equals("true")) {
                    this._parseState.setTrimWhitespace(true);
                    return;
                } else {
                    if (!value.equals("false")) throw this.error(L.l("trimDirectiveWhitespaces expects 'true' or 'false' at '{0}'", (Object)value));
                    this._parseState.setTrimWhitespace(false);
                }
            }
        }
    }

    protected String getRelativeUrl(String value) {
        if (value.length() > 0 && value.charAt(0) == '/') {
            return value;
        }
        return this._parseState.getUriPwd() + value;
    }

    static String parseCharEncoding(String type) throws JspParseException {
        int i;
        type = type.toLowerCase(Locale.ENGLISH);
        while ((i = type.indexOf(59)) >= 0 && i < type.length()) {
            char ch;
            ++i;
            while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                ++i;
            }
            if (i >= type.length()) {
                return null;
            }
            if ((i = (type = type.substring(i)).indexOf(61)) >= 0) {
                if (!type.startsWith("charset")) continue;
                ++i;
                while (i < type.length() && ((ch = type.charAt(i)) == ' ' || ch == '\t')) {
                    ++i;
                }
                type = type.substring(i);
            }
            for (i = 0; i < type.length() && (ch = type.charAt(i)) != ';' && ch != ' '; ++i) {
            }
            return type.substring(0, i);
        }
        return null;
    }

    @Override
    public void endAttributes() throws JspParseException {
        if (!this._gen.isTag()) {
            throw this.error(L.l("tag directive is only allowed in tag files."));
        }
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public void printXml(WriteStream os) throws IOException {
        String dynAttr;
        JavaTagGenerator gen = (JavaTagGenerator)this._gen;
        os.print("<jsp:directive.tag");
        os.print(" jsp:id=\"" + gen.generateJspId() + "\"");
        if (this._parseState.isELIgnoredPageSpecified()) {
            os.print(" el-ignored='" + this._parseState.isELIgnored() + "'");
        }
        if (this._import != null) {
            os.print(" import='" + this._import + "'");
        }
        if ((dynAttr = gen.getDynamicAttributes()) != null) {
            os.print(" dynamic-attributes='" + dynAttr + "'");
        }
        os.print("/>");
    }

    @Override
    public void generate(JspJavaWriter out) throws Exception {
    }
}

