/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.FileSetType;
import com.caucho.config.types.Period;
import com.caucho.jsp.JspServlet;
import com.caucho.jsp.JspXmlServlet;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletException;
import javax.servlet.descriptor.JspPropertyGroupDescriptor;

public class JspPropertyGroup
implements JspPropertyGroupDescriptor {
    private static final L10N L = new L10N(JspPropertyGroup.class);
    private static int _gId;
    private WebApp _webApp;
    private String _id;
    private ArrayList<String> _urlPatterns = new ArrayList();
    private String _pageEncoding;
    private Boolean _isELIgnored;
    private Boolean _isScriptingInvalid = null;
    private Boolean _isXml = null;
    private ArrayList<String> _includePrelude = new ArrayList();
    private ArrayList<String> _includeCoda = new ArrayList();
    private String _characterEncoding;
    private boolean _precompile = true;
    private boolean _fastJstl = true;
    private boolean _fastJsf = false;
    private boolean _ideHack = false;
    private boolean _velocity = false;
    private boolean _session = true;
    private boolean _staticEncoding = true;
    private boolean _recycleTags = true;
    private boolean _autoCompile = true;
    private boolean _requireSource = false;
    private boolean _ignoreELException = true;
    private boolean _isValidateTaglibSchema = true;
    private boolean _isPrintNullAsBlank = false;
    private int _jspMax = 0;
    private boolean _disableLog = true;
    private long _dependencyCheckInterval = -1L;
    private boolean _staticPageGeneratesClass = true;
    private boolean _loadTldOnInit = false;
    private boolean _recompileOnError = false;
    private FileSetType _tldFileSet;
    private Boolean _isTrimWhitespace = null;
    private Boolean _isDeferredSyntaxAllowedAsLiteral = null;
    private boolean _isELIgnoredForOldWebApp = false;
    private String _defaultContentType;
    private String _buffer;
    private Boolean _isErrorOnUndeclaredNamespace;

    public JspPropertyGroup() {
    }

    public JspPropertyGroup(WebApp webApp) {
        this._webApp = webApp;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setDescription(String description) {
    }

    public void setDisplayName(String displayName) {
    }

    public void addURLPattern(String urlPattern) {
        this._urlPatterns.add(urlPattern);
    }

    public Collection<String> getUrlPatterns() {
        return this._urlPatterns;
    }

    public void setPageEncoding(String pageEncoding) {
        this._pageEncoding = pageEncoding;
    }

    public String getPageEncoding() {
        return this._pageEncoding;
    }

    public void setELIgnored(boolean isELIgnored) {
        this._isELIgnored = isELIgnored ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isELIgnored() {
        return this._isELIgnored;
    }

    public String getElIgnored() {
        return this._isELIgnored == null ? null : this._isELIgnored.toString();
    }

    public void setLoadTldOnInit(boolean isPreload) {
        this._loadTldOnInit = isPreload;
    }

    public boolean isLoadTldOnInit() {
        return this._loadTldOnInit;
    }

    public void setDependencyCheckInterval(Period period) {
        this.setDependencyCheckIntervalMillis(period.getPeriod());
    }

    public void setDependencyCheckIntervalMillis(long time) {
        this._dependencyCheckInterval = time;
    }

    public long getDependencyCheckInterval() {
        return this._dependencyCheckInterval;
    }

    public void setScriptingInvalid(boolean isScriptingInvalid) {
        this._isScriptingInvalid = isScriptingInvalid;
    }

    public boolean isScriptingInvalid() {
        if (this._isScriptingInvalid == null) {
            return false;
        }
        return this._isScriptingInvalid;
    }

    public String getScriptingInvalid() {
        return this._isScriptingInvalid == null ? null : this._isScriptingInvalid.toString();
    }

    public void setIsXml(boolean isXml) {
        this._isXml = isXml ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isXml() {
        return this._isXml;
    }

    public String getIsXml() {
        return this._isXml == null ? null : this._isXml.toString();
    }

    public void addIncludePrelude(String url) {
        this._includePrelude.add(url);
    }

    public ArrayList<String> getIncludePreludeList() {
        return this._includePrelude;
    }

    public Collection<String> getIncludePreludes() {
        return this._includePrelude;
    }

    public void addIncludeCoda(String url) {
        this._includeCoda.add(url);
    }

    public ArrayList<String> getIncludeCodaList() {
        return this._includeCoda;
    }

    public Collection<String> getIncludeCodas() {
        return this._includeCoda;
    }

    public String getCharacterEncoding() {
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this._characterEncoding = characterEncoding;
    }

    public void setPrecompile(boolean precompile) {
        this._precompile = precompile;
    }

    public boolean getPrecompile() {
        return this._precompile;
    }

    public boolean isAutoCompile() {
        return this._autoCompile;
    }

    public void setAutoCompile(boolean compile) {
        this._autoCompile = compile;
    }

    public void setRequireSource(boolean requireSource) {
        this._requireSource = requireSource;
    }

    public boolean getRequireSource() {
        return this._requireSource;
    }

    public void setPrintNullAsBlank(boolean enable) {
        this._isPrintNullAsBlank = enable;
    }

    public boolean isPrintNullAsBlank() {
        return this._isPrintNullAsBlank;
    }

    public boolean isIgnoreELException() {
        return this._ignoreELException;
    }

    public void setIgnoreELException(boolean ignore) {
        this._ignoreELException = ignore;
    }

    public void setFastJstl(boolean fastJstl) {
        this._fastJstl = fastJstl;
    }

    public boolean isFastJstl() {
        return this._fastJstl;
    }

    public void setFastJsf(boolean fastJsf) {
        this._fastJsf = fastJsf;
    }

    public boolean isFastJsf() {
        return this._fastJsf;
    }

    public void setVelocityEnabled(boolean velocity) {
        this._velocity = velocity;
    }

    public boolean isVelocityEnabled() {
        return this._velocity;
    }

    public void setSession(boolean session) {
        this._session = session;
    }

    public boolean isSession() {
        return this._session;
    }

    public void setStaticEncoding(boolean staticEncoding) {
        this._staticEncoding = staticEncoding;
    }

    public boolean isStaticEncoding() {
        return this._staticEncoding;
    }

    public void setRecycleTags(boolean recycleTags) {
        this._recycleTags = recycleTags;
    }

    public boolean isRecycleTags() {
        return this._recycleTags;
    }

    public void setIdeHack(boolean ideHack) {
        this._ideHack = ideHack;
    }

    public boolean getIdeHack() {
        return this._ideHack;
    }

    public void setJspMax(int max) throws ConfigException {
        if (max <= 0) {
            throw new ConfigException(L.l("`{0}' is too small a value for jsp-max", (long)max));
        }
        this._jspMax = max;
    }

    public int getJspMax() {
        return this._jspMax;
    }

    public boolean isDisableLog() {
        return this._disableLog;
    }

    public void setDeferredSyntaxAllowedAsLiteral(boolean isAllowed) {
        this._isDeferredSyntaxAllowedAsLiteral = isAllowed;
    }

    public boolean isDeferredSyntaxAllowedAsLiteral() {
        return this._isDeferredSyntaxAllowedAsLiteral == null ? false : this._isDeferredSyntaxAllowedAsLiteral;
    }

    public String getDeferredSyntaxAllowedAsLiteral() {
        return this._isDeferredSyntaxAllowedAsLiteral == null ? null : this._isDeferredSyntaxAllowedAsLiteral.toString();
    }

    public String getDefaultContentType() {
        return this._defaultContentType;
    }

    public void setDefaultContentType(String defaultContentType) {
        this._defaultContentType = defaultContentType;
    }

    public String getBuffer() {
        return this._buffer;
    }

    public void setBuffer(String buffer) {
        this._buffer = buffer;
    }

    public boolean isErrorOnUndeclaredNamespace() {
        return this._isErrorOnUndeclaredNamespace == null ? true : this._isErrorOnUndeclaredNamespace;
    }

    public String getErrorOnUndeclaredNamespace() {
        return this._isErrorOnUndeclaredNamespace == null ? null : this._isErrorOnUndeclaredNamespace.toString();
    }

    public void setErrorOnUndeclaredNamespace(Boolean errorOnUndeclaredNamespace) {
        this._isErrorOnUndeclaredNamespace = errorOnUndeclaredNamespace;
    }

    public void setRecompileOnError(boolean recompile) {
        this._recompileOnError = recompile;
    }

    public boolean isRecompileOnError() {
        return this._recompileOnError;
    }

    public void setValidateTaglibSchema(boolean isValidate) {
        this._isValidateTaglibSchema = isValidate;
    }

    public boolean isValidateTaglibSchema() {
        return this._isValidateTaglibSchema;
    }

    public void setTldFileSet(FileSetType fileSet) {
        this._tldFileSet = fileSet;
    }

    public FileSetType getTldFileSet() {
        return this._tldFileSet;
    }

    public void setTldDir(Path tldDir) {
        this._tldFileSet = new FileSetType();
        this._tldFileSet.setDir(tldDir);
    }

    public void setStaticPageGeneratesClass(boolean generate) {
        this._staticPageGeneratesClass = generate;
    }

    public boolean getStaticPageGeneratesClass() {
        return this._staticPageGeneratesClass;
    }

    public boolean isTrimDirectiveWhitespaces() {
        return this._isTrimWhitespace == null ? false : this._isTrimWhitespace;
    }

    public void setTrimDirectiveWhitespaces(boolean isTrim) {
        this._isTrimWhitespace = isTrim;
    }

    public String getTrimDirectiveWhitespaces() {
        return this._isTrimWhitespace == null ? null : this._isTrimWhitespace.toString();
    }

    @PostConstruct
    public void init() throws ServletException {
        if (this._webApp != null) {
            ServletMapping mapping = this._webApp.createServletMapping();
            mapping.setServletName("jsp-property-group-" + _gId++);
            if (Boolean.TRUE.equals(this._isXml)) {
                mapping.setServletClass(JspXmlServlet.class.getName());
            } else {
                mapping.setServletClass(JspServlet.class.getName());
            }
            for (int i = 0; i < this._urlPatterns.size(); ++i) {
                mapping.addURLPattern(this._urlPatterns.get(i));
            }
            this._webApp.addServletMapping(mapping);
        }
    }

    public boolean match(String url) {
        if (this._urlPatterns.size() == 0) {
            return true;
        }
        for (int i = 0; i < this._urlPatterns.size(); ++i) {
            String urlPattern = this._urlPatterns.get(i);
            String regexpPattern = UrlMap.urlPatternToRegexpPattern(urlPattern);
            if (!Pattern.compile(regexpPattern).matcher(url).find()) continue;
            return true;
        }
        return false;
    }
}

