/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspParseException;
import com.caucho.jsp.TagFileManager;
import com.caucho.jsp.TagInfoImpl;
import com.caucho.jsp.cfg.TldFunction;
import com.caucho.jsp.cfg.TldTag;
import com.caucho.jsp.cfg.TldTagFile;
import com.caucho.jsp.cfg.TldTaglib;
import com.caucho.jsp.cfg.TldValidator;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;

public class Taglib
extends TagLibraryInfo {
    private static final Logger log = Logger.getLogger(Taglib.class.getName());
    static final L10N L = new L10N(Taglib.class);
    private TldTaglib _tldTaglib;
    private TagFileManager _tagFileManager;
    TagLibraryValidator _validator;
    private ArrayList<TldFunction> _functionList = new ArrayList();
    private ArrayList<Taglib> _libraryList = new ArrayList();

    Taglib(String prefix, String uri, TldTaglib tldTaglib, TagFileManager tagFileManager) throws JspParseException {
        super(prefix, uri);
        try {
            this._tldTaglib = tldTaglib;
            this._tagFileManager = tagFileManager;
            this.fillTagLibraryInfo(tldTaglib, tagFileManager);
            this._libraryList.add(this);
        }
        catch (JspParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspParseException(e);
        }
    }

    Taglib(Taglib taglib, String prefix) throws JspParseException {
        this(prefix, taglib.getURI(), taglib._tldTaglib, taglib._tagFileManager);
    }

    public Taglib create(String prefix) throws JspParseException {
        if (prefix.equals(this.getPrefixString())) {
            return this;
        }
        return new Taglib(this, prefix);
    }

    public TagLibraryValidator getValidator() throws JspParseException {
        return this._validator;
    }

    public ArrayList<TldFunction> getFunctionList() {
        return this._functionList;
    }

    public Path getPath() {
        if (this._tldTaglib != null) {
            return this._tldTaglib.getJarPath();
        }
        return null;
    }

    private void fillTagLibraryInfo(TldTaglib taglib, TagFileManager tagFileManager) throws Exception {
        int i;
        TldValidator validator;
        this.tlibversion = taglib.getTlibVersion();
        this.jspversion = taglib.getJspVersion();
        this.shortname = taglib.getShortName();
        this.urn = taglib.getURI();
        this.info = taglib.getInfo();
        if (taglib.getDescription() != null) {
            this.info = taglib.getDescription();
        }
        if ((validator = taglib.getValidator()) != null) {
            this._validator = validator.getValidator();
        }
        ArrayList<TldTag> tagList = taglib.getTagList();
        this.tags = new TagInfo[tagList.size()];
        for (int i2 = 0; i2 < tagList.size(); ++i2) {
            TldTag tag = tagList.get(i2);
            TagInfoImpl tagInfo = tag.getBaseTag() != null ? new TagInfoImpl(tag, tag.getBaseTag(), this) : new TagInfoImpl(tag, this);
            this.tags[i2] = tagInfo;
        }
        ArrayList<TldTagFile> tagFileList = taglib.getTagFileList();
        this.tagFiles = new TagFileInfo[tagFileList.size()];
        for (i = 0; i < tagFileList.size(); ++i) {
            TldTagFile tagFile = tagFileList.get(i);
            TagFileInfoExt tagFileInfo = new TagFileInfoExt(tagFileManager, tagFile.getName(), tagFile.getPath());
            this.tagFiles[i] = tagFileInfo;
        }
        this._functionList = taglib.getFunctionList();
        this.functions = new FunctionInfo[this._functionList.size()];
        for (i = 0; i < this._functionList.size(); ++i) {
            this.functions[i] = this._functionList.get(i).toFunctionInfo();
        }
    }

    public Class getClass(String tagName) throws Exception {
        String className;
        TagInfo info = this.getTag(tagName);
        String string = className = info == null ? null : info.getTagClassName();
        if (className != null) {
            return CauchoSystem.loadClass((String)className);
        }
        return null;
    }

    public ArrayList<String> getSingleTagClassNames() {
        ArrayList<String> singleTags = new ArrayList<String>();
        TagInfo[] tags = this.getTags();
        for (int i = 0; tags != null && i < tags.length; ++i) {
            String name = tags[i].getTagClassName();
            if (name == null || name.indexOf(46) >= 0) continue;
            singleTags.add(name);
        }
        return singleTags;
    }

    TagExtraInfo getTagExtraInfo(String tagName) {
        TagInfo info = this.getTag(tagName);
        return info != null ? info.getTagExtraInfo() : null;
    }

    public TagInfo getTag(String name) {
        if (this.tags == null) {
            return null;
        }
        for (int i = 0; i < this.tags.length; ++i) {
            if (!this.tags[i].getTagName().equals(name)) continue;
            return this.tags[i];
        }
        return null;
    }

    public String getTagFilePath(String name) {
        if (this._tldTaglib == null) {
            return null;
        }
        ArrayList<TldTagFile> tagFiles = this._tldTaglib.getTagFileList();
        for (int i = 0; i < tagFiles.size(); ++i) {
            TldTagFile tagFile = tagFiles.get(i);
            if (!tagFile.getName().equals(name)) continue;
            return tagFile.getPath();
        }
        return null;
    }

    public void addTaglib(Taglib taglib) {
        if (!this._libraryList.contains((Object)taglib)) {
            this._libraryList.add(taglib);
        }
    }

    public Taglib copy() throws JspParseException {
        return new Taglib(this.getPrefixString(), this.getURI(), this._tldTaglib, this._tagFileManager);
    }

    public TagLibraryInfo[] getTagLibraryInfos() {
        TagLibraryInfo[] infoArray = new TagLibraryInfo[this._libraryList.size()];
        this._libraryList.toArray(infoArray);
        return infoArray;
    }

    public String toString() {
        return "Taglib[prefix=" + this.prefix + ",uri=" + this.uri + "]";
    }

    class TagFileInfoExt
    extends TagFileInfo {
        private TagFileManager _manager;
        private TagInfo _tagInfo;

        TagFileInfoExt(TagFileManager manager, String name, String path) {
            super(name, path, null);
            this._manager = manager;
        }

        public TagInfo getTagInfo() {
            if (this._tagInfo == null) {
                try {
                    this._tagInfo = this._manager.getTag("", this.getName(), this.getPath());
                }
                catch (JspParseException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
            return this._tagInfo;
        }
    }
}

