/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.java.JavaCompilerUtil;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jsp.PageContextWrapper;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.Environment;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CacheListener;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeRing;
import com.caucho.util.LruCache;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;

public abstract class PageManager {
    private static final Logger log = Logger.getLogger(PageManager.class.getName());
    static final long ACCESS_INTERVAL = 60000L;
    private FreeRing<PageContextImpl> _freePages = new FreeRing(256);
    private FreeRing<PageContextWrapper> _freePageWrappers = new FreeRing(256);
    protected WebApp _webApp;
    private Path _classDir;
    private long _updateInterval = 1000L;
    private boolean _isAdapter;
    private boolean _omitInitLog;
    private int _pageCacheMax = 4096;
    private LruCache<String, Entry> _cache;
    protected boolean _autoCompile = true;

    PageManager() {
    }

    void initWebApp(WebApp webApp) {
        this._webApp = webApp;
        this._classDir = CauchoSystem.getWorkPath();
        long interval = Environment.getDependencyCheckInterval();
        JspPropertyGroup jspPropertyGroup = this._webApp.getJsp();
        if (jspPropertyGroup != null) {
            this._autoCompile = jspPropertyGroup.isAutoCompile();
            if (jspPropertyGroup.getJspMax() > 0) {
                this._pageCacheMax = jspPropertyGroup.getJspMax();
            }
            if (jspPropertyGroup.getDependencyCheckInterval() != Long.MIN_VALUE) {
                interval = jspPropertyGroup.getDependencyCheckInterval();
            }
        }
        if (interval < 0L) {
            interval = 0x3FFFFFFFL;
        }
        this._updateInterval = interval;
    }

    void setPageCacheMax(int max) {
        this._pageCacheMax = max;
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        Path appDir = this._webApp.getRootDirectory();
        if (appDir instanceof MemoryPath) {
            String workPathName = "./" + this._webApp.getURL();
            Path path = CauchoSystem.getWorkPath().lookup(workPathName);
            return path;
        }
        return appDir.lookup("WEB-INF/work");
    }

    public Path getAppDir() {
        return this._webApp.getRootDirectory();
    }

    WebApp getWebApp() {
        return this._webApp;
    }

    public PageContextImpl allocatePageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int buffer, boolean autoFlush) {
        PageContextImpl pc = (PageContextImpl)((Object)this._freePages.allocate());
        if (pc == null) {
            pc = new PageContextImpl();
        }
        try {
            pc.initialize(servlet, request, response, errorPageURL, needsSession, buffer, autoFlush);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pc;
    }

    public PageContextImpl allocatePageContext(Servlet servlet, WebApp app, ServletRequest request, ServletResponse response, String errorPageURL, HttpSession session, int buffer, boolean autoFlush, boolean isPrintNullAsBlank) {
        PageContextImpl pc = (PageContextImpl)((Object)this._freePages.allocate());
        if (pc == null) {
            pc = new PageContextImpl();
        }
        pc.initialize(servlet, app, request, response, errorPageURL, session, buffer, autoFlush, isPrintNullAsBlank);
        return pc;
    }

    public void freePageContext(PageContext pc) {
        if (pc != null) {
            pc.release();
            if (pc instanceof PageContextImpl) {
                this._freePages.free((Object)((PageContextImpl)pc));
            }
        }
    }

    public PageContextWrapper createPageContextWrapper(JspContext parent) {
        PageContextWrapper wrapper = (PageContextWrapper)((Object)this._freePageWrappers.allocate());
        if (wrapper == null) {
            wrapper = new PageContextWrapper();
        }
        wrapper.init((PageContextImpl)parent);
        return wrapper;
    }

    public void freePageContextWrapper(PageContextWrapper wrapper) {
        this._freePageWrappers.free((Object)wrapper);
    }

    public Page getPage(String uri, Path path) throws Exception {
        return this.getPage(uri, uri, path, null);
    }

    public Page getPage(String uri, String pageURI, Path path, ServletConfig config) throws Exception {
        return this.getPage(uri, pageURI, path, config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String uri, String pageURI, Path path, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        LruCache<String, Entry> cache = this._cache;
        if (cache == null) {
            this.initPageManager();
            PageManager pageManager = this;
            synchronized (pageManager) {
                if (this._cache == null) {
                    this._cache = new LruCache(this._pageCacheMax);
                }
                cache = this._cache;
            }
        }
        Entry entry = null;
        LruCache<String, Entry> lruCache = cache;
        synchronized (lruCache) {
            entry = (Entry)cache.get((Object)uri);
            if (entry == null) {
                entry = new Entry(uri);
                cache.put((Object)uri, (Object)entry);
            }
        }
        Page page = entry.getPage();
        if (page != null && !page._caucho_isModified()) {
            return page;
        }
        if (entry.startCompile()) {
            try {
                Entry entry2 = entry;
                synchronized (entry2) {
                    page = this.getPageEntry(entry, uri, pageURI, path, config, dependList);
                    entry.setPage(page);
                }
            }
            finally {
                entry.endCompile();
            }
        }
        return entry.getPage();
    }

    private Page getPageEntry(Entry entry, String uri, String pageURI, Path path, ServletConfig config, ArrayList<PersistentDependency> dependList) throws Exception {
        String className;
        Page page = entry.getPage();
        if (page != null && !page._caucho_isModified()) {
            return page;
        }
        if (page != null && !page.isDead()) {
            try {
                page.destroy();
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Jsp[] uri:" + uri + "(cp:" + this.getWebApp().getContextPath() + ",app:" + this.getWebApp().getRootDirectory() + ") -> " + path);
        }
        Path rootDir = this.getWebApp().getRootDirectory();
        String rawClassName = pageURI;
        if (path.getPath().startsWith(rootDir.getPath())) {
            rawClassName = path.getPath().substring(rootDir.getPath().length());
        }
        if ((page = this.createPage(path, pageURI, className = JavaCompilerUtil.mangleName((String)("jsp/" + rawClassName)), config, dependList)) == null) {
            log.fine("Jsp[] cannot create page " + path.getURL());
            throw new FileNotFoundException(this.getWebApp().getContextPath() + pageURI);
        }
        if (!this._autoCompile) {
            page._caucho_setNeverModified(true);
        }
        page._caucho_setUpdateInterval(this._updateInterval);
        page._caucho_isModified();
        try {
            InjectManager beanManager = InjectManager.create();
            InjectionTarget inject = beanManager.createInjectionTarget(page.getClass());
            OwnerCreationalContext env = new OwnerCreationalContext(null);
            inject.inject((Object)page, (CreationalContext)env);
            inject.postConstruct((Object)page);
        }
        catch (InjectionException e) {
            throw ConfigException.createConfig((Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return page;
    }

    protected void initPageManager() {
    }

    abstract Page createPage(Path var1, String var2, String var3, ServletConfig var4, ArrayList<PersistentDependency> var5) throws Exception;

    void killPage(HttpServletRequest request, HttpServletResponse response, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LruCache<String, Entry> cache = this._cache;
        this._cache = null;
        if (cache == null) {
            return;
        }
        LruCache<String, Entry> lruCache = cache;
        synchronized (lruCache) {
            Iterator iter = cache.values();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                Page page = entry != null ? entry.getPage() : null;
                try {
                    if (page == null || page.isDead()) continue;
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    public class Entry
    implements CacheListener {
        private String _key;
        private Page _page;
        private AtomicInteger _compileCount = new AtomicInteger();
        private long _lastAccessTime;

        Entry(String key) {
            this._key = key;
        }

        public boolean startCompile() {
            Page page = this._page;
            if (page == null) {
                this._compileCount.incrementAndGet();
                return true;
            }
            return this._compileCount.compareAndSet(0, 1);
        }

        public void endCompile() {
            this._compileCount.decrementAndGet();
        }

        void setPage(Page page) {
            this._page = page;
            if (page != null) {
                page._caucho_setEntry(this);
            }
        }

        Page getPage() {
            return this._page;
        }

        public void accessPage() {
            long now = CurrentTime.getCurrentTime();
            if (now < this._lastAccessTime + 60000L) {
                return;
            }
            this._lastAccessTime = now;
            if (PageManager.this._cache != null) {
                PageManager.this._cache.get((Object)this._key);
            }
        }

        public void removeEvent() {
            Page page = this._page;
            this._page = null;
            if (page != null && !page.isDead()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("dropping page " + page);
                }
                page.setDead();
                page.destroy();
            }
        }
    }
}

