/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.resource;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.program.ContainerProgram;
import com.caucho.jms.JmsConnectionFactory;
import com.caucho.jms.queue.AbstractDestination;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Startup;
import javax.inject.Singleton;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

@Singleton
@Startup
public class ListenerResource {
    private static L10N L = new L10N(ListenerResource.class);
    protected static Logger log = Logger.getLogger(ListenerResource.class.getName());
    private ConnectionFactory _connFactory;
    private Connection _conn;
    private Destination _destination;
    private int _listenerMax = 5;
    private ListenerConfig _listenerConfig;

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connFactory = factory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public void setListener(ListenerConfig config) {
        this._listenerConfig = config;
    }

    public void setListenerMax(int listenerMax) {
        this._listenerMax = listenerMax;
    }

    @PostConstruct
    public void init() throws ConfigException, JMSException {
        if (this._destination == null) {
            throw new ConfigException(L.l("'destination' is required for ListenerResource."));
        }
        if (this._listenerConfig == null) {
            throw new ConfigException(L.l("'listener' is required for ListenerResource."));
        }
        if (this._connFactory == null && this._destination instanceof AbstractDestination) {
            this._connFactory = new JmsConnectionFactory();
        }
        if (this._connFactory == null) {
            throw new ConfigException(L.l("connection-factory is required for ListenerResource."));
        }
        this._conn = this._connFactory.createConnection();
        if (this._destination instanceof Topic) {
            this._listenerMax = 1;
        }
        this.start();
    }

    private void start() {
        try {
            for (int i = 0; i < this._listenerMax; ++i) {
                MessageListener listener = this._listenerConfig.newInstance();
                Session session = this._conn.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer(this._destination);
                consumer.setMessageListener(listener);
            }
            this._conn.start();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        log.fine("ListenerResource[" + this._destination + "] started");
    }

    @PreDestroy
    public void stop() throws JMSException {
        this._conn.stop();
        log.fine("ListenerResource[" + this._destination + "] stopped");
    }

    public static class ListenerConfig {
        private Class _type;
        private ContainerProgram _init;

        public void setType(Class type) throws ConfigException {
            Config.validate((Class)type, MessageListener.class);
            this._type = type;
        }

        public void setInit(ContainerProgram init) {
            this._init = init;
        }

        @PostConstruct
        public void init() throws ConfigException {
            if (this._type == null) {
                throw new ConfigException(L.l("'type' is required for listener."));
            }
        }

        public MessageListener newInstance() throws Throwable, InstantiationException {
            MessageListener listener = (MessageListener)this._type.newInstance();
            if (this._init != null) {
                this._init.configure((Object)listener);
            }
            return listener;
        }
    }
}

