/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.jms.JmsExceptionWrapper;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.MessageType;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.StreamImplOutputStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    private TempStream _tempStream;

    public ObjectMessageImpl() {
    }

    public ObjectMessageImpl(ObjectMessage msg) throws JMSException {
        super((Message)msg);
        this.setObject(msg.getObject());
    }

    public ObjectMessageImpl(ObjectMessageImpl msg) {
        super(msg);
        this._tempStream = msg._tempStream;
    }

    public ObjectMessageImpl(Serializable value) throws JMSException {
        this.setObject(value);
    }

    @Override
    public MessageType getType() {
        return MessageType.OBJECT;
    }

    public void setObject(Serializable o) throws JMSException {
        this.checkBodyWriteable();
        this._tempStream = new TempStream();
        try {
            StreamImplOutputStream ws = new StreamImplOutputStream((StreamImpl)this._tempStream);
            Hessian2Output out = new Hessian2Output((OutputStream)ws);
            out.writeObject((Object)o);
            out.close();
            ws.close();
        }
        catch (Exception e) {
            throw JmsExceptionWrapper.create(e);
        }
    }

    public Serializable getObject() throws JMSException {
        if (this._tempStream == null) {
            return null;
        }
        try {
            ReadStream is = this._tempStream.openReadAndSaveBuffer();
            Hessian2Input in = new Hessian2Input((InputStream)is);
            Serializable object = (Serializable)in.readObject();
            in.close();
            is.close();
            return object;
        }
        catch (Exception e) {
            throw JmsExceptionWrapper.create(e);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this._tempStream = null;
    }

    @Override
    public MessageImpl copy() {
        return new ObjectMessageImpl(this);
    }

    @Override
    public InputStream bodyToInputStream() throws IOException {
        if (this._tempStream != null) {
            return this._tempStream.openReadAndSaveBuffer();
        }
        return null;
    }

    @Override
    public void readBody(InputStream is) throws IOException, JMSException {
        if (is == null) {
            return;
        }
        this._tempStream = new TempStream();
        this._tempStream.openWrite();
        WriteStream ws = new WriteStream((StreamImpl)this._tempStream);
        ws.writeStream(is);
        ws.close();
    }
}

