/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jca;

import com.caucho.config.ConfigException;
import com.caucho.jms.jca.MessageListenerSpec;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class ResourceAdapterImpl
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(ResourceAdapterImpl.class.getName());
    private static final L10N L = new L10N(ResourceAdapterImpl.class);
    private BootstrapContext _ctx;
    private ConnectionFactory _connectionFactory;
    private Destination _destination;
    private ArrayList<MessageListenerSpec> _listeners = new ArrayList();

    public void setConnectionFactory(ConnectionFactory factory) {
        this._connectionFactory = factory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._connectionFactory;
    }

    public void setDestination(Destination destination) {
        this._destination = destination;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void init() throws ConfigException {
        if (this._connectionFactory == null) {
            throw new ConfigException(L.l("connection-factory is not configured.  The JMS resource adapter needs a connection factory."));
        }
        if (this._destination == null) {
            throw new ConfigException(L.l("destination is not configured.  The JMS resource adapter needs a destination."));
        }
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this._ctx = ctx;
    }

    public void stop() {
        this._ctx = null;
    }

    WorkManager getWorkManager() {
        return this._ctx.getWorkManager();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws NotSupportedException, ResourceException {
        MessageListenerSpec listener = (MessageListenerSpec)spec;
        listener.setEndpointFactory(endpointFactory);
        try {
            listener.start();
        }
        catch (ResourceException e) {
            throw new NotSupportedException((Throwable)e);
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }
}

