/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class TemporaryQueueImpl
extends MemoryQueue
implements TemporaryQueue {
    private static final L10N L = new L10N(TemporaryQueueImpl.class);
    private static int _idCount;
    private JmsSession _session;
    private boolean _isClosed;
    private AtomicInteger _messageConsumerCount;

    TemporaryQueueImpl(JmsSession session) {
        this._session = session;
        this._messageConsumerCount = new AtomicInteger();
        this.setName("TemporaryQueue-" + _idCount++);
    }

    JmsSession getSession() {
        return this._session;
    }

    public void addMessageConsumer() {
        this._messageConsumerCount.incrementAndGet();
    }

    public void removeMessageConsumer() {
        this._messageConsumerCount.decrementAndGet();
    }

    public void delete() throws JMSException {
        if (this._messageConsumerCount.get() > 0) {
            throw new IllegalStateException(L.l("temporary queue is still active"));
        }
    }
}

