/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.Names;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.CurrentLiteral;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.types.Period;
import com.caucho.env.dbpool.ConnectionPool;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import com.caucho.jca.ra.ResourceManagerImpl;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;

public class ConnectionFactoryConfig
extends BeanConfig {
    private static final Logger log = Logger.getLogger(ConnectionFactoryConfig.class.getName());
    private static L10N L = new L10N(ConnectionFactoryConfig.class);
    private ResourceAdapter _ra;
    private int _maxConnections = 1024;
    private long _maxActiveTime = 0x3FFFFFFFFFFFFFFFL;
    @Inject
    private Instance<ResourceAdapter> _raInstance;

    public ConnectionFactoryConfig() {
        this.setBeanConfigClass(ManagedConnectionFactory.class);
    }

    protected String getDefaultScope() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this._ra = ra;
    }

    public void setMaxConnections(int max) {
        this._maxConnections = max;
    }

    public void setMaxActiveTime(Period period) {
        this._maxActiveTime = period.getPeriod();
    }

    @PostConstruct
    public void init() {
        super.init();
        Bean comp = this.getComponent();
        InjectManager cdiManager = InjectManager.create();
        ManagedConnectionFactory managedFactory = (ManagedConnectionFactory)cdiManager.getReference(comp);
        if (managedFactory instanceof ResourceAdapterAssociation) {
            Class<?> cl = managedFactory.getClass();
            ResourceAdapter ra = this.findResourceAdapter(cl);
            ResourceAdapterAssociation factoryAssoc = (ResourceAdapterAssociation)managedFactory;
            try {
                factoryAssoc.setResourceAdapter(ra);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        ResourceManagerImpl rm = ResourceManagerImpl.create();
        ConnectionPool cm = rm.createConnectionPool();
        if (this.getName() != null) {
            cm.setName(this.getName());
        }
        cm.setMaxConnections(this._maxConnections);
        cm.setMaxActiveTime(this._maxActiveTime);
        ResourceArchive rar = null;
        if (rar != null) {
            String trans = rar.getTransactionSupport();
            if (trans == null) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("XATransaction")) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("NoTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(false);
            } else if (trans.equals("LocalTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(true);
            }
        }
        try {
            Object connectionFactory = cm.init(managedFactory);
            cm.start();
            BeanBuilder factory = cdiManager.createBeanFactory(connectionFactory.getClass());
            if (this.getName() != null) {
                Jndi.bindDeepShort((String)this.getName(), (Object)connectionFactory);
                factory.name(this.getName());
                factory.qualifier((Annotation)Names.create((String)this.getName()));
                factory.qualifier((Annotation)CurrentLiteral.CURRENT);
            }
            factory.qualifier((Annotation)DefaultLiteral.DEFAULT);
            Bean bean = factory.singleton(connectionFactory);
            cdiManager.addBeanDiscover(bean);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private ResourceAdapter findResourceAdapter(Class cl) {
        CreationalContext env;
        if (this._ra != null) {
            return this._ra;
        }
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(cl.getName());
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' does not have a defined resource-adapter.  Either define it in a &lt;resource-adapter> property or check the rar or META-INF/resin-ra.xml files", (Object)cl.getName()));
        }
        InjectManager cdiManager = InjectManager.create();
        String raName = ra.getResourceAdapterClass().getSimpleName();
        raName = Character.toLowerCase(raName.charAt(0)) + raName.substring(1);
        Instance instance = this._raInstance.select(new Annotation[]{Names.create((String)raName)});
        Bean bean = cdiManager.resolve(cdiManager.getBeans(ResourceAdapter.class, new Annotation[]{Names.create((String)raName)}));
        ResourceAdapter resourceAdapter = (ResourceAdapter)cdiManager.getReference(bean, ResourceAdapter.class, env = cdiManager.createCreationalContext((Contextual)bean));
        if (resourceAdapter == null) {
            throw new ConfigException(L.l("'{0}' does not have a configured resource-adapter for '{1}'.", (Object)raName, (Object)cl.getName()));
        }
        return resourceAdapter;
    }

    public void deploy() {
    }
}

