/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.services;

import com.caucho.bam.actor.SimpleActor;
import com.caucho.config.ConfigException;
import com.caucho.hemp.services.BamMailService;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

public class BamLogService
extends SimpleActor {
    private static final L10N L = new L10N(BamLogService.class);
    private static final Logger log = Logger.getLogger(BamMailService.class.getName());
    private Logger _log = log;
    private Level _level = Level.INFO;

    public void setName(String name) {
        this._log = Logger.getLogger(name);
    }

    public void setLevel(String level) {
        if ("off".equals(level)) {
            this._level = Level.OFF;
        } else if ("all".equals(level)) {
            this._level = Level.ALL;
        } else if ("finest".equals(level)) {
            this._level = Level.FINEST;
        } else if ("finer".equals(level)) {
            this._level = Level.FINER;
        } else if ("fine".equals(level)) {
            this._level = Level.FINE;
        } else if ("config".equals(level)) {
            this._level = Level.CONFIG;
        } else if ("info".equals(level)) {
            this._level = Level.INFO;
        } else if ("warning".equals(level)) {
            this._level = Level.WARNING;
        } else if ("severe".equals(level)) {
            this._level = Level.SEVERE;
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown logging level", (Object)level));
        }
    }

    @Override
    public void message(String to, String from, Serializable value) {
        String text = this.messageToText(value);
        if (this._log.isLoggable(this._level)) {
            this._log.log(this._level, text);
        }
    }

    protected String messageToText(Serializable value) {
        String text = null;
        if (value instanceof String) {
            text = value.toString();
        } else if (value instanceof TextMessage) {
            try {
                text = ((TextMessage)value).getText();
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        } else if (value instanceof ObjectMessage) {
            try {
                text = String.valueOf(((ObjectMessage)value).getObject());
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (text == null) {
            text = String.valueOf(value);
        }
        return text;
    }
}

