/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.FreeList;
import com.caucho.util.RuntimeExceptionWrapper;
import com.caucho.vfs.GzipStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GzipFilter
implements Filter {
    private final FreeList<GzipResponse> _freeList = new FreeList(16);
    private final FreeList<GzipPlainResponse> _plainFreeList = new FreeList(16);
    private static final int NONE = 0;
    private static final int GZIP = 1;
    private static final int DEFLATE = 2;
    private static final AllowEntry ALLOW = new AllowEntry();
    private static final AllowEntry DENY = new AllowEntry();
    private ServletContext _app;
    private boolean _embedError;
    private boolean _useVary = true;
    private boolean _noCache = false;
    private HashMap<String, AllowEntry> _contentTypeMap;
    private boolean _hasDeny;

    public void setUseVary(boolean useVary) {
        this._useVary = useVary;
    }

    public void setNoCache(boolean noCache) {
        this._noCache = noCache;
    }

    public void setEmbedErrorInOutput(boolean embedError) {
        this._embedError = embedError;
    }

    public void addAllowContentType(String type) {
        if (this._contentTypeMap == null) {
            this._contentTypeMap = new HashMap();
        }
        this._contentTypeMap.put(type, ALLOW);
    }

    public void addDenyContentType(String type) {
        if (this._contentTypeMap == null) {
            this._contentTypeMap = new HashMap();
        }
        this._hasDeny = true;
        this._contentTypeMap.put(type, DENY);
    }

    public void init(FilterConfig config) throws ServletException {
        this._app = config.getServletContext();
        this._embedError = !"false".equals(config.getInitParameter("embed-error-in-output"));
        String value = config.getInitParameter("use-vary");
        if (value != null) {
            if ("false".equals(value)) {
                this._useVary = false;
            } else if ("false".equals(value)) {
                this._useVary = true;
            }
        }
        if ((value = config.getInitParameter("no-cache")) != null) {
            if ("true".equals(value)) {
                this._noCache = true;
            } else if ("false".equals(value)) {
                this._noCache = true;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        int encoding = this.allowGzip(req, res);
        if (encoding != 0) {
            boolean isNew;
            GzipResponse gzipResponse = (GzipResponse)req.getAttribute("caucho.gzip");
            boolean bl = isNew = gzipResponse == null;
            if (gzipResponse == null) {
                gzipResponse = (GzipResponse)this._freeList.allocate();
            }
            if (gzipResponse == null) {
                gzipResponse = new GzipResponse();
            }
            gzipResponse.setUseDeflate(encoding == 2);
            if (isNew) {
                gzipResponse.init(res);
            }
            try {
                nextFilter.doFilter((ServletRequest)req, (ServletResponse)gzipResponse);
            }
            catch (Exception e) {
                this.handleError(e, gzipResponse);
            }
            if (this.isAsync(req)) {
                req.setAttribute("caucho.gzip", (Object)gzipResponse);
                gzipResponse.flush();
            } else {
                gzipResponse.close();
                this._freeList.free((Object)gzipResponse);
            }
        } else {
            GzipPlainResponse plainRes = (GzipPlainResponse)this._plainFreeList.allocate();
            if (plainRes == null) {
                plainRes = new GzipPlainResponse();
            }
            plainRes.init(res);
            nextFilter.doFilter((ServletRequest)req, (ServletResponse)plainRes);
            plainRes.close();
            this._plainFreeList.free((Object)plainRes);
        }
    }

    private boolean isAsync(HttpServletRequest request) {
        if (!(request instanceof CauchoRequest)) {
            return false;
        }
        CauchoRequest cReq = (CauchoRequest)request;
        return cReq.isComet();
    }

    protected void addVaryHeader(HttpServletResponse response) {
        if (this._noCache) {
            response.setHeader("Cache-Control", "no-cache");
        } else if (this._useVary) {
            if (!response.containsHeader("Vary")) {
                response.addHeader("Vary", "Accept-Encoding");
            }
        } else {
            response.setHeader("Cache-Control", "private");
        }
    }

    protected int allowGzip(HttpServletRequest req, HttpServletResponse res) {
        String acceptEncoding = req.getHeader("Accept-Encoding");
        if (acceptEncoding == null) {
            return 0;
        }
        if (req.getHeader("Range") != null) {
            return 0;
        }
        if (acceptEncoding.indexOf("gzip") >= 0) {
            return 1;
        }
        if (acceptEncoding.indexOf("deflate") >= 0) {
            return 2;
        }
        return 0;
    }

    public void destroy() {
    }

    private void handleError(Exception e, CauchoResponseWrapper res) throws ServletException, IOException {
        if (!this._embedError || !res.isCommitted()) {
            if (e instanceof ServletException) {
                throw (ServletException)((Object)e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw RuntimeExceptionWrapper.create((Throwable)e);
        }
        this._app.log(e.getMessage(), (Throwable)e);
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.flush();
        res.getWriter().print(writer.toCharArray());
    }

    static class AllowEntry {
        AllowEntry() {
        }
    }

    class GzipPlainResponse
    extends CauchoResponseWrapper {
        private boolean _useVary = true;

        GzipPlainResponse() {
        }

        @Override
        public void setContentType(String value) {
            AllowEntry entry;
            super.setContentType(value);
            if (GzipFilter.this._contentTypeMap == null) {
                return;
            }
            int p = value.indexOf(59);
            if (p > 0) {
                value = value.substring(0, p);
            }
            this._useVary = (entry = (AllowEntry)GzipFilter.this._contentTypeMap.get(value)) == ALLOW ? true : (entry == DENY ? false : GzipFilter.this._hasDeny);
        }

        @Override
        public OutputStream getStream() throws IOException {
            if (this._useVary) {
                GzipFilter.this.addVaryHeader(this._response);
            }
            return this._response.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this._useVary = true;
            }
        }
    }

    class GzipResponse
    extends CauchoResponseWrapper {
        private boolean _useVary = true;
        private boolean _allowGzip = true;
        private boolean _useDeflate = false;
        private final GzipStream _savedGzipStream = new GzipStream();
        private GzipStream _gzipStream;

        GzipResponse() {
        }

        public void setUseDeflate(boolean useDeflate) {
            this._useDeflate = useDeflate;
        }

        @Override
        public void setContentType(String value) {
            AllowEntry entry;
            super.setContentType(value);
            if (GzipFilter.this._contentTypeMap == null) {
                return;
            }
            int p = value.indexOf(59);
            if (p > 0) {
                value = value.substring(0, p);
            }
            if ((entry = (AllowEntry)GzipFilter.this._contentTypeMap.get(value)) == ALLOW) {
                this._allowGzip = true;
            } else if (entry == DENY) {
                this._useVary = false;
                this._allowGzip = false;
            } else if (!GzipFilter.this._hasDeny) {
                this._useVary = false;
                this._allowGzip = false;
            } else {
                this._allowGzip = true;
            }
        }

        @Override
        public void setHeader(String header, String value) {
            if (header.equalsIgnoreCase("Content-Type")) {
                this.setContentType(value);
            } else if (header.equalsIgnoreCase("Content-Encoding")) {
                this._allowGzip = false;
                super.setHeader(header, value);
            } else if (!header.equalsIgnoreCase("Content-Length")) {
                super.setHeader(header, value);
            }
        }

        @Override
        public void addHeader(String header, String value) {
            if (header.equalsIgnoreCase("Content-Type")) {
                this.setContentType(value);
            } else if (header.equalsIgnoreCase("Content-Encoding")) {
                this._allowGzip = false;
                super.addHeader(header, value);
            } else if (!header.equalsIgnoreCase("Content-Length")) {
                super.addHeader(header, value);
            }
        }

        @Override
        public void setIntHeader(String header, int value) {
            if (!header.equalsIgnoreCase("Content-Length")) {
                super.setIntHeader(header, value);
            }
        }

        @Override
        public void addIntHeader(String header, int value) {
            if (!header.equalsIgnoreCase("Content-Length")) {
                super.addIntHeader(header, value);
            }
        }

        @Override
        public void setContentLength(int length) {
        }

        @Override
        public void setContentLength(long length) {
        }

        @Override
        public void setStatus(int status, String message) {
            super.setStatus(status, message);
            if (this._gzipStream != null) {
                this._gzipStream.setEnable(false);
                this._response.setHeader("Content-Encoding", "plain");
            }
            this._allowGzip = false;
        }

        @Override
        public void setStatus(int status) {
            super.setStatus(status);
            if (status == 200) {
                return;
            }
            this._allowGzip = false;
        }

        @Override
        public void reset() {
            super.reset();
            if (this._gzipStream != null) {
                this._gzipStream.reset();
            }
        }

        @Override
        public OutputStream getStream() throws IOException {
            if (this._useVary) {
                GzipFilter.this.addVaryHeader(this._response);
            }
            if (!this._allowGzip) {
                return this._response.getOutputStream();
            }
            ServletOutputStream os = this._response.getOutputStream();
            if (this._useDeflate) {
                this._response.setHeader("Content-Encoding", "deflate");
            } else {
                this._response.setHeader("Content-Encoding", "gzip");
            }
            this._gzipStream = this._savedGzipStream;
            this._gzipStream.setGzip(!this._useDeflate);
            this._gzipStream.init((OutputStream)os);
            return this._gzipStream;
        }

        public void flush() throws IOException {
            this._gzipStream.flush();
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this._useVary = true;
                this._allowGzip = true;
                this._useDeflate = false;
                GzipStream gzipStream = this._gzipStream;
                this._gzipStream = null;
                if (gzipStream != null) {
                    if (gzipStream.isData()) {
                        gzipStream.close();
                    } else {
                        gzipStream.free();
                    }
                }
            }
        }
    }
}

