/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.FilterWrapperResponseStream;
import com.caucho.server.http.AbstractResponseStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ResponseWrapper;
import com.caucho.server.http.ResponseWriter;
import com.caucho.server.http.ServletOutputStreamImpl;
import com.caucho.vfs.FlushBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CauchoResponseWrapper
extends ResponseWrapper
implements CauchoResponse {
    private static final Logger log = Logger.getLogger(CauchoResponseWrapper.class.getName());
    private FlushBuffer _flushBuffer;
    private final FilterWrapperResponseStream _originalStream;
    protected AbstractResponseStream _stream;
    private ResponseWriter _writer;
    private ServletOutputStreamImpl _os = new ServletOutputStreamImpl();
    private boolean _hasError;

    public CauchoResponseWrapper() {
        this._writer = new ResponseWriter();
        this._originalStream = new FilterWrapperResponseStream();
    }

    public CauchoResponseWrapper(HttpServletResponse response) {
        this();
        this.init(response);
    }

    public void init(HttpServletResponse response) {
        this.setResponse(response);
        this._stream = this._originalStream;
        this._os.init((OutputStream)((Object)this._originalStream));
        this._writer.init(this._originalStream);
        this._hasError = false;
        this._originalStream.init(this);
        this._originalStream.start();
    }

    @Override
    public void close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        } else {
            this._originalStream.close();
        }
    }

    @Override
    public ServletResponse getResponse() {
        return this._response;
    }

    @Override
    public void setContentType(String value) {
        this._response.setContentType(value);
        try {
            this._stream.setEncoding(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void setResponseStream(AbstractResponseStream stream) {
        this._stream = stream;
        this._os.init((OutputStream)((Object)stream));
        this._writer.init(stream);
    }

    @Override
    public AbstractResponseStream getResponseStream() {
        return this._stream;
    }

    @Override
    public boolean isCauchoResponseStream() {
        return true;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this._os;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this._writer;
    }

    protected OutputStream getStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void setFlushBuffer(FlushBuffer flushBuffer) {
        this._flushBuffer = flushBuffer;
    }

    public FlushBuffer getFlushBuffer() {
        return this._flushBuffer;
    }

    @Override
    public void flushBuffer() throws IOException {
        if (this._flushBuffer != null) {
            this._flushBuffer.flushBuffer();
        }
        this._stream.flushBuffer();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetBuffer();
    }

    @Override
    public void resetBuffer() {
        if (this._stream != null) {
            this._stream.clearBuffer();
        }
        this._response.resetBuffer();
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    @Override
    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
        try {
            this._stream.setLocale(this._response.getLocale());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public String getHeader(String key) {
        try {
            return this._response.getHeader(key);
        }
        catch (AbstractMethodError e) {
            log.log(Level.FINEST, e.toString(), e);
            return null;
        }
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    @Override
    public void setContentLength(long length) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setContentLength(length);
        } else if (length <= Integer.MAX_VALUE) {
            this._response.setContentLength((int)length);
        }
    }

    @Override
    public void setFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setFooter(key, value);
        }
    }

    @Override
    public void addFooter(String key, String value) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).addFooter(key, value);
        }
    }

    public int getRemaining() {
        return this._stream.getRemaining();
    }

    @Override
    public void setForbidForward(boolean forbid) {
    }

    @Override
    public boolean getForbidForward() {
        return false;
    }

    @Override
    public String getStatusMessage() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).getStatusMessage();
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName());
    }

    @Override
    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    @Override
    public boolean hasError() {
        return this._hasError;
    }

    @Override
    public void killCache() {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).killCache();
        }
    }

    @Override
    public void completeCache() {
    }

    @Override
    public void setSessionId(String id) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setSessionId(id);
        }
    }

    @Override
    public void setPrivateCache(boolean isPrivate) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setPrivateCache(isPrivate);
        }
    }

    @Override
    public void setNoCache(boolean isPrivate) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setNoCache(isPrivate);
        }
    }

    @Override
    public void writeHeaders(int length) throws IOException {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).writeHeaders(length);
        }
    }

    public int getStatus() {
        return this._response.getStatus();
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaderNames();
    }

    @Override
    public void setForwardEnclosed(boolean isForwardEnclosed) {
    }

    @Override
    public boolean isForwardEnclosed() {
        return false;
    }

    @Override
    public boolean isNoCacheUnlessVary() {
        return false;
    }

    @Override
    public String getCharacterEncodingAssigned() {
        return null;
    }
}

