/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.vfs;

import com.caucho.config.ConfigException;
import com.caucho.env.repository.RepositorySpi;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryRoot {
    private static final Logger log = Logger.getLogger(RepositoryRoot.class.getName());
    private String _id;
    private RepositorySpi _repository;
    private Path _rootDirectory;
    private String _rootHash;

    public RepositoryRoot(String id, RepositorySpi repository, Path rootDirectory) {
        this._id = id;
        this._repository = repository;
        this._rootDirectory = rootDirectory;
        if (this._repository == null) {
            throw new NullPointerException();
        }
    }

    private String getId() {
        return this._id;
    }

    private Path getRootDirectory() {
        return this._rootDirectory;
    }

    public void update() {
        if (this._repository.isActive()) {
            if (!this.exists()) {
                this.deleteLocalCopy();
            } else if (this.isModified()) {
                try {
                    this.extractFromRepository();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean exists() {
        String tag = this.getId();
        String treeHash = this._repository.getTagContentHash(tag);
        return treeHash != null;
    }

    private boolean isModified() {
        String tag = this.getId();
        String treeHash = this._repository.getTagContentHash(tag);
        if (treeHash == null) {
            return false;
        }
        return !treeHash.equals(this._rootHash);
    }

    private synchronized boolean deleteLocalCopy() {
        try {
            Path pwd = this.getRootDirectory();
            pwd.removeAll();
            return true;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    private synchronized boolean extractFromRepository() throws IOException {
        try {
            String tag = this.getId();
            String treeHash = this._repository.getTagContentHash(tag);
            if (treeHash == null) {
                return false;
            }
            if (treeHash.equals(this._rootHash)) {
                return false;
            }
            Path pwd = this.getRootDirectory();
            pwd.mkdirs();
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " extract from repository tag=" + tag + "\n  root=" + this.getRootDirectory() + "\n  contentHash=" + treeHash);
            }
            this._repository.expandToPath(treeHash, pwd);
            this._rootHash = treeHash;
            return true;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

