/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.git;

import java.io.IOException;
import java.io.InputStream;

public class GitInputStream
extends InputStream {
    private InputStream _is;
    private byte[] _buffer;
    private int _bufferOffset;
    private int _bufferLength;

    public GitInputStream(String type, long length, InputStream is) throws IOException {
        this._is = is;
        this._buffer = new byte[64];
        int offset = 0;
        for (int i = 0; i < type.length(); ++i) {
            this._buffer[offset++] = (byte)type.charAt(i);
        }
        this._buffer[offset++] = 32;
        String lengthStr = String.valueOf(length);
        for (int i = 0; i < lengthStr.length(); ++i) {
            this._buffer[offset++] = (byte)lengthStr.charAt(i);
        }
        this._buffer[offset++] = 0;
        this._bufferLength = offset;
        this._bufferOffset = 0;
    }

    @Override
    public int read() throws IOException {
        if (this._bufferOffset < this._bufferLength) {
            return this._buffer[this._bufferOffset++] & 0xFF;
        }
        return this._is.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen = this._bufferLength - this._bufferOffset;
        if (sublen > 0) {
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(this._buffer, this._bufferOffset, buffer, offset, sublen);
            this._bufferOffset += sublen;
            offset += sublen;
            length -= sublen;
        }
        if (length > 0) {
            int readLength = this._is.read(buffer, offset, length);
            if (readLength > 0) {
                return sublen + readLength;
            }
            if (sublen > 0) {
                return sublen;
            }
            return -1;
        }
        return sublen;
    }

    @Override
    public void close() throws IOException {
        this._is.close();
    }
}

